/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManager;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerTestCase;
import org.apache.bookkeeper.meta.LongHierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.MSLedgerManagerFactory;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.versioning.Version;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class LedgerManagerIteratorTest
extends LedgerManagerTestCase {
    public LedgerManagerIteratorTest(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        super(lmFactoryCls);
    }

    void removeLedger(LedgerManager lm, Long ledgerId) throws Exception {
        lm.removeLedgerMetadata(ledgerId.longValue(), Version.ANY).get();
    }

    void createLedger(LedgerManager lm, Long ledgerId) throws Exception {
        ArrayList ensemble = Lists.newArrayList((Object[])new BookieSocketAddress[]{new BookieSocketAddress("192.0.2.1", 1234), new BookieSocketAddress("192.0.2.2", 1234), new BookieSocketAddress("192.0.2.3", 1234)});
        LedgerMetadata meta = LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).withPassword("passwd".getBytes()).withDigestType(BookKeeper.DigestType.CRC32.toApiDigestType()).newEnsembleEntry(0L, (List)ensemble).build();
        lm.createLedgerMetadata(ledgerId.longValue(), meta).get();
    }

    static Set<Long> ledgerRangeToSet(LedgerManager.LedgerRangeIterator lri) throws IOException {
        TreeSet<Long> ret = new TreeSet<Long>();
        long last = -1L;
        while (lri.hasNext()) {
            LedgerManager.LedgerRange lr = lri.next();
            Assert.assertFalse((String)"ledger range must not be empty", (boolean)lr.getLedgers().isEmpty());
            Assert.assertTrue((String)"ledger ranges must not overlap", (last < lr.start() ? 1 : 0) != 0);
            ret.addAll(lr.getLedgers());
            last = lr.end();
        }
        return ret;
    }

    static Set<Long> getLedgerIdsByUsingAsyncProcessLedgers(LedgerManager lm) throws InterruptedException {
        ConcurrentHashMap.KeySetView ledgersReadAsync = ConcurrentHashMap.newKeySet();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger finalRC = new AtomicInteger();
        lm.asyncProcessLedgers((ledgerId, callback) -> {
            ledgersReadAsync.add(ledgerId);
            callback.processResult(0, null, null);
        }, (rc, s, obj) -> {
            finalRC.set(rc);
            latch.countDown();
        }, null, 0, -1);
        latch.await();
        Assert.assertEquals((String)"Final RC of asyncProcessLedgers", (long)0L, (long)finalRC.get());
        return ledgersReadAsync;
    }

    @Test
    public void testIterateNoLedgers() throws Exception {
        LedgerManager lm = this.getLedgerManager();
        LedgerManager.LedgerRangeIterator lri = lm.getLedgerRanges();
        Assert.assertNotNull((Object)lri);
        if (lri.hasNext()) {
            lri.next();
        }
        Assert.assertEquals((Object)false, (Object)lri.hasNext());
    }

    @Test
    public void testSingleLedger() throws Throwable {
        LedgerManager lm = this.getLedgerManager();
        long id = 2020202L;
        this.createLedger(lm, id);
        LedgerManager.LedgerRangeIterator lri = lm.getLedgerRanges();
        Assert.assertNotNull((Object)lri);
        Set<Long> lids = LedgerManagerIteratorTest.ledgerRangeToSet(lri);
        Assert.assertEquals((long)lids.size(), (long)1L);
        Assert.assertEquals((long)lids.iterator().next(), (long)id);
        Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(lm);
        Assert.assertEquals((String)"Comparing LedgersIds read asynchronously", lids, ledgersReadAsync);
    }

    @Test
    public void testTwoLedgers() throws Throwable {
        LedgerManager lm = this.getLedgerManager();
        TreeSet<Long> ids = new TreeSet<Long>(Arrays.asList(101010101L, 2020340302L));
        for (Long id : ids) {
            this.createLedger(lm, id);
        }
        LedgerManager.LedgerRangeIterator lri = lm.getLedgerRanges();
        Assert.assertNotNull((Object)lri);
        Set<Long> returnedIds = LedgerManagerIteratorTest.ledgerRangeToSet(lri);
        Assert.assertEquals(ids, returnedIds);
        Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(lm);
        Assert.assertEquals((String)"Comparing LedgersIds read asynchronously", ids, ledgersReadAsync);
    }

    @Test
    public void testSeveralContiguousLedgers() throws Throwable {
        LedgerManager lm = this.getLedgerManager();
        TreeSet<Long> ids = new TreeSet<Long>();
        for (long i = 0L; i < 2000L; ++i) {
            this.createLedger(lm, i);
            ids.add(i);
        }
        LedgerManager.LedgerRangeIterator lri = lm.getLedgerRanges();
        Assert.assertNotNull((Object)lri);
        Set<Long> returnedIds = LedgerManagerIteratorTest.ledgerRangeToSet(lri);
        Assert.assertEquals(ids, returnedIds);
        Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(lm);
        Assert.assertEquals((String)"Comparing LedgersIds read asynchronously", ids, ledgersReadAsync);
    }

    @Test
    public void testRemovalOfNodeJustTraversed() throws Throwable {
        if (this.baseConf.getLedgerManagerFactoryClass() != LongHierarchicalLedgerManagerFactory.class) {
            return;
        }
        LedgerManager lm = this.getLedgerManager();
        TreeSet<Long> toRemove = new TreeSet<Long>(Arrays.asList(3394498498348983841L, 3394498498348983842L, 3394498498348993841L));
        long first = 2345678901234567890L;
        TreeSet<Long> mustHave = new TreeSet<Long>(Arrays.asList(first, 6334994393848474732L));
        TreeSet<Long> ids = new TreeSet<Long>();
        ids.addAll(toRemove);
        ids.addAll(mustHave);
        for (Long id : ids) {
            this.createLedger(lm, id);
        }
        TreeSet found = new TreeSet();
        LedgerManager.LedgerRangeIterator lri = lm.getLedgerRanges();
        while (lri.hasNext()) {
            LedgerManager.LedgerRange lr = lri.next();
            found.addAll(lr.getLedgers());
            if (!lr.getLedgers().contains(first)) continue;
            Iterator iterator = toRemove.iterator();
            while (iterator.hasNext()) {
                long id = (Long)iterator.next();
                this.removeLedger(lm, id);
            }
            toRemove.clear();
        }
        Iterator iterator = mustHave.iterator();
        while (iterator.hasNext()) {
            long id = (Long)iterator.next();
            Assert.assertTrue((boolean)found.contains(id));
        }
    }

    @Test
    public void validateEmptyL4PathSkipped() throws Throwable {
        String[] paths;
        if (this.baseConf.getLedgerManagerFactoryClass() != LongHierarchicalLedgerManagerFactory.class) {
            return;
        }
        LedgerManager lm = this.getLedgerManager();
        TreeSet<Long> ids = new TreeSet<Long>(Arrays.asList(2345678901234567890L, 3394498498348983841L, 6334994393848474732L, 7349370101927398483L));
        for (Long l : ids) {
            this.createLedger(lm, l);
        }
        for (String path : paths = new String[]{"/ledgers/633/4994/3938/4948"}) {
            ZkUtils.createFullPathOptimistic((ZooKeeper)this.zkc, (String)path, (byte[])"data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        LedgerManager.LedgerRangeIterator ledgerRangeIterator = lm.getLedgerRanges();
        Assert.assertNotNull((Object)ledgerRangeIterator);
        Set<Long> returnedIds = LedgerManagerIteratorTest.ledgerRangeToSet(ledgerRangeIterator);
        Assert.assertEquals(ids, returnedIds);
        Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(lm);
        Assert.assertEquals((String)"Comparing LedgersIds read asynchronously", ids, ledgersReadAsync);
        LedgerManager.LedgerRangeIterator ledgerRangeIterator2 = lm.getLedgerRanges();
        int emptyRanges = 0;
        while (ledgerRangeIterator2.hasNext()) {
            if (!ledgerRangeIterator2.next().getLedgers().isEmpty()) continue;
            ++emptyRanges;
        }
        Assert.assertEquals((long)0L, (long)emptyRanges);
    }

    @Test
    public void testWithSeveralIncompletePaths() throws Throwable {
        String[] paths;
        if (this.baseConf.getLedgerManagerFactoryClass() != LongHierarchicalLedgerManagerFactory.class) {
            return;
        }
        LedgerManager lm = this.getLedgerManager();
        TreeSet<Long> ids = new TreeSet<Long>(Arrays.asList(2345678901234567890L, 3394498498348983841L, 6334994393848474732L, 7349370101927398483L));
        for (Long l : ids) {
            this.createLedger(lm, l);
        }
        for (String path : paths = new String[]{"/ledgers/000/0000/0000", "/ledgers/234/5678/9999", "/ledgers/339/0000/0000", "/ledgers/633/4994/3938/0000", "/ledgers/922/3372/0000/0000"}) {
            ZkUtils.createFullPathOptimistic((ZooKeeper)this.zkc, (String)path, (byte[])"data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        LedgerManager.LedgerRangeIterator ledgerRangeIterator = lm.getLedgerRanges();
        Assert.assertNotNull((Object)ledgerRangeIterator);
        Set<Long> returnedIds = LedgerManagerIteratorTest.ledgerRangeToSet(ledgerRangeIterator);
        Assert.assertEquals(ids, returnedIds);
        Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(lm);
        Assert.assertEquals((String)"Comparing LedgersIds read asynchronously", ids, ledgersReadAsync);
    }

    @Test
    public void checkConcurrentModifications() throws Throwable {
        Future f2;
        int i;
        int numWriters = 10;
        int numCheckers = 10;
        int numLedgers = 100;
        long runtime = TimeUnit.NANOSECONDS.convert(2L, TimeUnit.SECONDS);
        boolean longRange = this.baseConf.getLedgerManagerFactoryClass() == LongHierarchicalLedgerManagerFactory.class;
        TreeSet<Long> mustExist = new TreeSet<Long>();
        LedgerManager lm = this.getLedgerManager();
        Random rng = new Random();
        for (int i2 = 0; i2 < 100; ++i2) {
            long lid = Math.abs(rng.nextLong());
            if (!longRange) {
                lid %= 1000000L;
            }
            this.createLedger(lm, lid);
            mustExist.add(lid);
        }
        long start = MathUtils.nowInNano();
        CountDownLatch latch = new CountDownLatch(1);
        ArrayList<Future> futures = new ArrayList<Future>();
        ExecutorService executor = Executors.newCachedThreadPool();
        ConcurrentSkipListSet createdLedgers = new ConcurrentSkipListSet();
        for (i = 0; i < 10; ++i) {
            f2 = executor.submit(() -> {
                LedgerManager writerLM = this.getIndependentLedgerManager();
                Random writerRNG = new Random(rng.nextLong());
                latch.await();
                while (MathUtils.elapsedNanos((long)start) < runtime) {
                    long candidate = 0L;
                    do {
                        candidate = Math.abs(writerRNG.nextLong());
                        if (longRange) continue;
                        candidate %= 1000000L;
                    } while (mustExist.contains(candidate) || !createdLedgers.add(candidate));
                    this.createLedger(writerLM, candidate);
                    this.removeLedger(writerLM, candidate);
                }
                return null;
            });
            futures.add(f2);
        }
        for (i = 0; i < 10; ++i) {
            f2 = executor.submit(() -> {
                LedgerManager checkerLM = this.getIndependentLedgerManager();
                latch.await();
                while (MathUtils.elapsedNanos((long)start) < runtime) {
                    LedgerManager.LedgerRangeIterator lri = checkerLM.getLedgerRanges();
                    Set<Long> returnedIds = LedgerManagerIteratorTest.ledgerRangeToSet(lri);
                    Iterator iterator = mustExist.iterator();
                    while (iterator.hasNext()) {
                        long id = (Long)iterator.next();
                        Assert.assertTrue((boolean)returnedIds.contains(id));
                    }
                    Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(checkerLM);
                    Iterator iterator2 = mustExist.iterator();
                    while (iterator2.hasNext()) {
                        long id = (Long)iterator2.next();
                        Assert.assertTrue((boolean)ledgersReadAsync.contains(id));
                    }
                }
                return null;
            });
            futures.add(f2);
        }
        latch.countDown();
        for (Future f2 : futures) {
            f2.get();
        }
        executor.shutdownNow();
    }

    @Test
    public void testLedgerParentNode() throws Throwable {
        Assume.assumeTrue((!this.baseConf.getLedgerManagerFactoryClass().equals(MSLedgerManagerFactory.class) ? 1 : 0) != 0);
        AbstractZkLedgerManager lm = (AbstractZkLedgerManager)this.getLedgerManager();
        List<Long> ledgerIds = this.baseConf.getLedgerManagerFactoryClass().equals(HierarchicalLedgerManagerFactory.class) || this.baseConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class) ? Arrays.asList(100L, 0x4FFFFFFF6L) : Arrays.asList(100L, 0x7FFFFFF5L);
        for (long ledgerId : ledgerIds) {
            String fullLedgerPath = lm.getLedgerPath(ledgerId);
            String ledgerPath = fullLedgerPath.replaceAll(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf) + "/", "");
            String[] znodesOfLedger = ledgerPath.split("/");
            Assert.assertTrue((String)(znodesOfLedger[0] + " is supposed to be valid parent "), (boolean)lm.isLedgerParentNode(znodesOfLedger[0]));
        }
    }

    @Test
    public void testLedgerManagerFormat() throws Throwable {
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf);
        Assume.assumeTrue((!this.baseConf.getLedgerManagerFactoryClass().equals(MSLedgerManagerFactory.class) ? 1 : 0) != 0);
        AbstractZkLedgerManager lm = (AbstractZkLedgerManager)this.getLedgerManager();
        List<Long> ids = Arrays.asList(1234567890L, 2L, 32345L, 23456789L);
        if (this.baseConf.getLedgerManagerFactoryClass().equals(HierarchicalLedgerManagerFactory.class) || this.baseConf.getLedgerManagerFactoryClass().equals(LongHierarchicalLedgerManagerFactory.class)) {
            ids = new ArrayList<Long>(ids);
            ids.add(0xFFFFFFFEL);
            ids.add(1234567891234L);
        }
        for (Long l : ids) {
            this.createLedger((LedgerManager)lm, l);
        }
        List<String> invalidZnodes = Arrays.asList("12345", "12345678901L", "abc", "123d");
        for (String invalidZnode : invalidZnodes) {
            ZkUtils.createFullPathOptimistic((ZooKeeper)this.zkc, (String)(zkLedgersRootPath + "/" + invalidZnode), (byte[])"data".getBytes(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        }
        List list = this.zkc.getChildren(zkLedgersRootPath, false);
        int totalChildrenOfLedgersRootPath = list.size();
        int totalParentNodesOfLedgers = 0;
        for (String childOfLedgersRootPath : list) {
            if (!lm.isLedgerParentNode(childOfLedgersRootPath)) continue;
            ++totalParentNodesOfLedgers;
        }
        this.ledgerManagerFactory.format((AbstractConfiguration)this.baseConf, (LayoutManager)new ZkLayoutManager(this.zkc, zkLedgersRootPath, ZkUtils.getACLs((AbstractConfiguration)this.baseConf)));
        List childrenOfLedgersRootPathAfterFormat = this.zkc.getChildren(zkLedgersRootPath, false);
        int totalChildrenOfLedgersRootPathAfterFormat = childrenOfLedgersRootPathAfterFormat.size();
        Assert.assertEquals((String)"totalChildrenOfLedgersRootPathAfterFormat", (long)(totalChildrenOfLedgersRootPath - totalParentNodesOfLedgers), (long)totalChildrenOfLedgersRootPathAfterFormat);
        Assert.assertTrue((String)"ChildrenOfLedgersRootPathAfterFormat should contain all the invalid znodes created", (boolean)childrenOfLedgersRootPathAfterFormat.containsAll(invalidZnodes));
    }

    @Test
    public void hierarchicalLedgerManagerAsyncProcessLedgersTest() throws Throwable {
        Assume.assumeTrue((boolean)this.baseConf.getLedgerManagerFactoryClass().equals(HierarchicalLedgerManagerFactory.class));
        LedgerManager lm = this.getLedgerManager();
        LedgerManager.LedgerRangeIterator lri = lm.getLedgerRanges();
        TreeSet<Long> ledgerIds = new TreeSet<Long>(Arrays.asList(1234L, 123456789123456789L));
        for (Long ledgerId : ledgerIds) {
            this.createLedger(lm, ledgerId);
        }
        Set<Long> ledgersReadThroughIterator = LedgerManagerIteratorTest.ledgerRangeToSet(lri);
        Assert.assertEquals((String)"Comparing LedgersIds read through Iterator", ledgerIds, ledgersReadThroughIterator);
        Set<Long> ledgersReadAsync = LedgerManagerIteratorTest.getLedgerIdsByUsingAsyncProcessLedgers(lm);
        Assert.assertEquals((String)"Comparing LedgersIds read asynchronously", ledgerIds, ledgersReadAsync);
    }
}

