/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.TestCase;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.ZkLedgerIdGenerator;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZkLedgerIdGenerator
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestZkLedgerIdGenerator.class);
    ZooKeeperUtil zkutil;
    ZooKeeper zk;
    LedgerIdGenerator ledgerIdGenerator;

    @Before
    public void setUp() throws Exception {
        LOG.info("Setting up test");
        super.setUp();
        this.zkutil = new ZooKeeperUtil();
        this.zkutil.startCluster();
        this.zk = this.zkutil.getZooKeeperClient();
        this.ledgerIdGenerator = new ZkLedgerIdGenerator(this.zk, "/test-zk-ledger-id-generator", "idgen", (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
    }

    @After
    public void tearDown() throws Exception {
        LOG.info("Tearing down test");
        this.ledgerIdGenerator.close();
        this.zk.close();
        this.zkutil.killCluster();
        super.tearDown();
    }

    @Test
    public void testGenerateLedgerId() throws Exception {
        int nThread = 2;
        int nLedgers = 2000;
        final CountDownLatch countDownLatch = new CountDownLatch(4000);
        final AtomicInteger errCount = new AtomicInteger(0);
        final ConcurrentLinkedQueue ledgerIds = new ConcurrentLinkedQueue();
        BookkeeperInternalCallbacks.GenericCallback<Long> cb = new BookkeeperInternalCallbacks.GenericCallback<Long>(){

            public void operationComplete(int rc, Long result) {
                if (KeeperException.Code.OK.intValue() == rc) {
                    ledgerIds.add(result);
                } else {
                    errCount.incrementAndGet();
                }
                countDownLatch.countDown();
            }
        };
        long start = System.currentTimeMillis();
        for (int i = 0; i < 2; ++i) {
            new Thread((BookkeeperInternalCallbacks.GenericCallback)cb){
                final /* synthetic */ BookkeeperInternalCallbacks.GenericCallback val$cb;
                {
                    this.val$cb = genericCallback;
                }

                @Override
                public void run() {
                    for (int j = 0; j < 2000; ++j) {
                        TestZkLedgerIdGenerator.this.ledgerIdGenerator.generateLedgerId(this.val$cb);
                    }
                }
            }.start();
        }
        TestZkLedgerIdGenerator.assertTrue((String)"Wait ledger id generation threads to stop timeout : ", (boolean)countDownLatch.await(30L, TimeUnit.SECONDS));
        LOG.info("Number of generated ledger id: {}, time used: {}", (Object)ledgerIds.size(), (Object)(System.currentTimeMillis() - start));
        TestZkLedgerIdGenerator.assertEquals((String)"Error occur during ledger id generation : ", (int)0, (int)errCount.get());
        HashSet<Long> ledgers = new HashSet<Long>();
        while (!ledgerIds.isEmpty()) {
            Long ledger = (Long)ledgerIds.poll();
            TestZkLedgerIdGenerator.assertNotNull((String)"Generated ledger id is null : ", (Object)ledger);
            TestZkLedgerIdGenerator.assertFalse((String)("Ledger id [" + ledger + "] conflict : "), (boolean)ledgers.contains(ledger));
            ledgers.add(ledger);
        }
    }
}

