/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.common.util.concurrent.UncheckedExecutionException;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestCallbacks;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Test;

public class AuditorRollingRestartTest
extends BookKeeperClusterTestCase {
    public AuditorRollingRestartTest() {
        super(3, 600);
        this.setAutoRecoveryEnabled(true);
    }

    @Test
    public void testAuditingDuringRollingRestart() throws Exception {
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)((ServerConfiguration)this.bsConfs.get(0)), mFactory -> {
            try {
                this.testAuditingDuringRollingRestart((LedgerManagerFactory)mFactory);
            }
            catch (Exception e) {
                throw new UncheckedExecutionException(e.getMessage(), (Throwable)e);
            }
            return null;
        });
    }

    private void testAuditingDuringRollingRestart(LedgerManagerFactory mFactory) throws Exception {
        LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
        LedgerHandle lh = this.bkc.createLedger(3, 3, BookKeeper.DigestType.CRC32, "passwd".getBytes());
        for (int i = 0; i < 10; ++i) {
            lh.asyncAddEntry("foobar".getBytes(), (AsyncCallback.AddCallback)new TestCallbacks.AddCallbackFuture(i), null);
        }
        lh.addEntry("foobar".getBytes());
        lh.close();
        Assert.assertEquals((String)"shouldn't be anything under replicated", (long)underReplicationManager.pollLedgerToRereplicate(), (long)-1L);
        underReplicationManager.disableLedgerReplication();
        BookieSocketAddress auditor = AuditorElector.getCurrentAuditor((ServerConfiguration)this.baseConf, (ZooKeeper)this.zkc);
        ServerConfiguration conf = this.killBookie(auditor);
        Thread.sleep(2000L);
        this.startBookie(conf);
        Thread.sleep(2000L);
        Assert.assertEquals((String)"shouldn't be anything under replicated", (long)-1L, (long)underReplicationManager.pollLedgerToRereplicate());
    }
}

