/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.replication;

import com.google.protobuf.Message;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.TextFormat;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.AbstractZkLedgerManagerFactory;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.ZkLayoutManager;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.DNS;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.test.ZooKeeperUtil;
import org.apache.bookkeeper.util.ZkUtils;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLedgerUnderreplicationManager {
    static final Logger LOG = LoggerFactory.getLogger(TestLedgerUnderreplicationManager.class);
    ZooKeeperUtil zkUtil = null;
    ServerConfiguration conf = null;
    ExecutorService executor = null;
    LedgerManagerFactory lmf1 = null;
    LedgerManagerFactory lmf2 = null;
    ZooKeeper zkc1 = null;
    ZooKeeper zkc2 = null;
    String basePath;
    String urLedgerPath;
    boolean isLedgerReplicationDisabled = true;

    @Before
    public void setupZooKeeper() throws Exception {
        this.zkUtil = new ZooKeeperUtil();
        this.zkUtil.startCluster();
        this.conf = TestBKConfiguration.newServerConfiguration();
        this.conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.executor = Executors.newCachedThreadPool();
        this.zkc1 = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();
        this.zkc2 = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(10000).build();
        String zkLedgersRootPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.conf);
        this.basePath = zkLedgersRootPath + '/' + "underreplication";
        this.urLedgerPath = this.basePath + "/ledgers";
        this.lmf1 = AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)this.conf, (LayoutManager)new ZkLayoutManager(this.zkc1, zkLedgersRootPath, ZkUtils.getACLs((AbstractConfiguration)this.conf)));
        this.lmf2 = AbstractZkLedgerManagerFactory.newLedgerManagerFactory((AbstractConfiguration)this.conf, (LayoutManager)new ZkLayoutManager(this.zkc2, zkLedgersRootPath, ZkUtils.getACLs((AbstractConfiguration)this.conf)));
    }

    @After
    public void teardownZooKeeper() throws Exception {
        if (this.zkUtil != null) {
            this.zkUtil.killCluster();
            this.zkUtil = null;
        }
        if (this.executor != null) {
            this.executor = null;
        }
        if (this.zkc1 != null) {
            this.zkc1.close();
            this.zkc1 = null;
        }
        if (this.zkc2 != null) {
            this.zkc2.close();
            this.zkc2 = null;
        }
        if (this.lmf1 != null) {
            this.lmf1.close();
            this.lmf1 = null;
        }
        if (this.lmf2 != null) {
            this.lmf2.close();
            this.lmf2 = null;
        }
    }

    private Future<Long> getLedgerToReplicate(final LedgerUnderreplicationManager m) {
        return this.executor.submit(new Callable<Long>(){

            @Override
            public Long call() {
                try {
                    return m.getLedgerToRereplicate();
                }
                catch (Exception e) {
                    LOG.error("Error getting ledger id", (Throwable)e);
                    return -1L;
                }
            }
        });
    }

    @Test
    public void testBasicInteraction() throws Exception {
        HashSet<Long> ledgers = new HashSet<Long>();
        ledgers.add(3735928559L);
        ledgers.add(3203386110L);
        ledgers.add(0xFFFFBEEFL);
        ledgers.add(4207853295L);
        String missingReplica = "localhost:3181";
        int count = 0;
        LedgerUnderreplicationManager m = this.lmf1.newLedgerUnderreplicationManager();
        Iterator iter = ledgers.iterator();
        while (iter.hasNext()) {
            m.markLedgerUnderreplicated(((Long)iter.next()).longValue(), missingReplica);
            ++count;
        }
        ArrayList<Future<Long>> futures = new ArrayList<Future<Long>>();
        for (int i = 0; i < count; ++i) {
            futures.add(this.getLedgerToReplicate(m));
        }
        for (Future future : futures) {
            Long l = (Long)future.get(5L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)ledgers.remove(l));
        }
        Future<Long> f = this.getLedgerToReplicate(m);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        Long l = 0xFEFEFEFEFEFEL;
        m.markLedgerUnderreplicated(l.longValue(), missingReplica);
        Assert.assertEquals((String)"Should have got the one just added", (Object)l, (Object)f.get(5L, TimeUnit.SECONDS));
    }

    @Test
    public void testLocking() throws Exception {
        String missingReplica = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf2.newLedgerUnderreplicationManager();
        Long ledger = 1093839814060L;
        m1.markLedgerUnderreplicated(ledger.longValue(), missingReplica);
        Future<Long> f = this.getLedgerToReplicate(m1);
        Long l = f.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I just marked", (Object)ledger, (Object)l);
        f = this.getLedgerToReplicate(m2);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        this.zkc1.close();
        this.zkc1 = null;
        l = f.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I marked", (Object)ledger, (Object)l);
    }

    @Test
    public void testMarkingAsReplicated() throws Exception {
        String missingReplica = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf2.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        Long ledgerB = 233811435L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica);
        m1.markLedgerUnderreplicated(ledgerB.longValue(), missingReplica);
        Future<Long> fA = this.getLedgerToReplicate(m1);
        Future<Long> fB = this.getLedgerToReplicate(m1);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        Long lB = fB.get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Should be the ledgers I just marked", (lA.equals(ledgerA) && lB.equals(ledgerB) || lA.equals(ledgerB) && lB.equals(ledgerA) ? 1 : 0) != 0);
        Future<Long> f = this.getLedgerToReplicate(m2);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        m1.markLedgerReplicated(lA.longValue());
        this.zkc1.close();
        this.zkc1 = null;
        Long l = f.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I marked", (Object)lB, (Object)l);
    }

    @Test
    public void testRelease() throws Exception {
        String missingReplica = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf2.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        Long ledgerB = 233811435L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica);
        m1.markLedgerUnderreplicated(ledgerB.longValue(), missingReplica);
        Future<Long> fA = this.getLedgerToReplicate(m1);
        Future<Long> fB = this.getLedgerToReplicate(m1);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        Long lB = fB.get(5L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Should be the ledgers I just marked", (lA.equals(ledgerA) && lB.equals(ledgerB) || lA.equals(ledgerB) && lB.equals(ledgerA) ? 1 : 0) != 0);
        Future<Long> f = this.getLedgerToReplicate(m2);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        m1.markLedgerReplicated(lA.longValue());
        m1.releaseUnderreplicatedLedger(lB.longValue());
        Long l = f.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I marked", (Object)lB, (Object)l);
    }

    @Test
    public void testManyFailures() throws Exception {
        String missingReplica1 = "localhost:3181";
        String missingReplica2 = "localhost:3182";
        LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        Future<Long> fA = this.getLedgerToReplicate(m1);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica2);
        Assert.assertEquals((String)"Should be the ledger I just marked", (Object)lA, (Object)ledgerA);
        m1.markLedgerReplicated(lA.longValue());
        Future<Long> f = this.getLedgerToReplicate(m1);
        lA = f.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I had marked previously", (Object)lA, (Object)ledgerA);
    }

    @Test
    public void testGetReplicationWorkerIdRereplicatingLedger() throws Exception {
        String missingReplica1 = "localhost:3181";
        String missingReplica2 = "localhost:3182";
        LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica2);
        Assert.assertEquals((String)"ReplicationWorkerId of the lock", null, (Object)m1.getReplicationWorkerIdRereplicatingLedger(ledgerA.longValue()));
        Future<Long> fA = this.getLedgerToReplicate(m1);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger that was just marked", (Object)lA, (Object)ledgerA);
        Assert.assertEquals((String)"ReplicationWorkerId of the lock", (Object)DNS.getDefaultHost((String)"default"), (Object)m1.getReplicationWorkerIdRereplicatingLedger(ledgerA.longValue()));
        m1.markLedgerReplicated(lA.longValue());
        Assert.assertEquals((String)"ReplicationWorkerId of the lock", null, (Object)m1.getReplicationWorkerIdRereplicatingLedger(ledgerA.longValue()));
    }

    @Test
    public void test2reportSame() throws Exception {
        String missingReplica1 = "localhost:3181";
        LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        LedgerUnderreplicationManager m2 = this.lmf2.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        m2.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        DataFormats.UnderreplicatedLedgerFormat.Builder builderA = DataFormats.UnderreplicatedLedgerFormat.newBuilder();
        String znode = this.getUrLedgerZnode(ledgerA);
        byte[] data = this.zkc1.getData(znode, false, null);
        TextFormat.merge((CharSequence)new String(data, Charset.forName("UTF-8")), (Message.Builder)builderA);
        ProtocolStringList replicaList = builderA.getReplicaList();
        Assert.assertEquals((String)("Published duplicate missing replica : " + replicaList), (long)1L, (long)replicaList.size());
        Assert.assertTrue((String)("Published duplicate missing replica : " + replicaList), (boolean)replicaList.contains(missingReplica1));
        Future<Long> fA = this.getLedgerToReplicate(m1);
        Long lA = fA.get(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"Should be the ledger I just marked", (Object)lA, (Object)ledgerA);
        m1.markLedgerReplicated(lA.longValue());
        Future<Long> f = this.getLedgerToReplicate(m2);
        try {
            f.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleManagersShouldBeAbleToTakeAndReleaseLock() throws Exception {
        String missingReplica1 = "localhost:3181";
        final LedgerUnderreplicationManager m1 = this.lmf1.newLedgerUnderreplicationManager();
        final LedgerUnderreplicationManager m2 = this.lmf2.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        m1.markLedgerUnderreplicated(ledgerA.longValue(), missingReplica1);
        int iterationCount = 100;
        final CountDownLatch latch1 = new CountDownLatch(100);
        final CountDownLatch latch2 = new CountDownLatch(100);
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                TestLedgerUnderreplicationManager.this.takeLedgerAndRelease(m1, latch1, 100);
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                TestLedgerUnderreplicationManager.this.takeLedgerAndRelease(m2, latch2, 100);
            }
        };
        thread1.start();
        thread2.start();
        while (!latch1.await(50L, TimeUnit.MILLISECONDS) && !latch2.await(50L, TimeUnit.MILLISECONDS)) {
            Thread.sleep(50L);
        }
        m1.close();
        m2.close();
        latch1.await();
        latch2.await();
    }

    @Test
    public void testMarkSimilarMissingReplica() throws Exception {
        ArrayList<String> missingReplica = new ArrayList<String>();
        missingReplica.add("localhost:3181");
        missingReplica.add("localhost:318");
        missingReplica.add("localhost:31812");
        missingReplica.add("1.cluster.com");
        missingReplica.add("2.cluster.com");
        missingReplica.add("11.cluster.com");
        missingReplica.add("12.cluster.com");
        this.verifyMarkLedgerUnderreplicated(missingReplica);
    }

    @Test
    public void testManyFailuresInAnEnsemble() throws Exception {
        ArrayList<String> missingReplica = new ArrayList<String>();
        missingReplica.add("localhost:3181");
        missingReplica.add("localhost:3182");
        this.verifyMarkLedgerUnderreplicated(missingReplica);
    }

    @Test
    public void testDisableLedegerReplication() throws Exception {
        LedgerUnderreplicationManager replicaMgr = this.lmf1.newLedgerUnderreplicationManager();
        Long ledgerA = 1093839814060L;
        String missingReplica = "localhost:3181";
        replicaMgr.disableLedgerReplication();
        LOG.info("Disabled Ledeger Replication");
        try {
            replicaMgr.markLedgerUnderreplicated(ledgerA.longValue(), "localhost:3181");
        }
        catch (ReplicationException.UnavailableException e) {
            LOG.debug("Unexpected exception while marking urLedger", (Throwable)e);
            Assert.fail((String)("Unexpected exception while marking urLedger" + e.getMessage()));
        }
        Future<Long> fA = this.getLedgerToReplicate(replicaMgr);
        try {
            fA.get(1L, TimeUnit.SECONDS);
            Assert.fail((String)"Shouldn't be able to find a ledger to replicate");
        }
        catch (TimeoutException te) {
            this.isLedgerReplicationDisabled = false;
        }
        Assert.assertTrue((String)"Ledger replication is not disabled!", (!this.isLedgerReplicationDisabled ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEnableLedgerReplication() throws Exception {
        this.isLedgerReplicationDisabled = true;
        final LedgerUnderreplicationManager replicaMgr = this.lmf1.newLedgerUnderreplicationManager();
        final Long ledgerA = 1093839814060L;
        String missingReplica = "localhost:3181";
        try {
            replicaMgr.markLedgerUnderreplicated(ledgerA.longValue(), "localhost:3181");
        }
        catch (ReplicationException.UnavailableException e) {
            LOG.debug("Unexpected exception while marking urLedger", (Throwable)e);
            Assert.fail((String)("Unexpected exception while marking urLedger" + e.getMessage()));
        }
        replicaMgr.disableLedgerReplication();
        LOG.debug("Disabled Ledeger Replication");
        String znodeA = this.getUrLedgerZnode(ledgerA);
        final CountDownLatch znodeLatch = new CountDownLatch(2);
        String urledgerA = StringUtils.substringAfterLast((String)znodeA, (String)"/");
        String urLockLedgerA = this.basePath + "/locks/" + urledgerA;
        this.zkc1.exists(urLockLedgerA, new Watcher(){

            public void process(WatchedEvent event) {
                if (event.getType() == Watcher.Event.EventType.NodeCreated) {
                    znodeLatch.countDown();
                    LOG.debug("Recieved node creation event for the zNodePath:" + event.getPath());
                }
            }
        });
        Thread thread1 = new Thread(){

            @Override
            public void run() {
                try {
                    Long lA = replicaMgr.getLedgerToRereplicate();
                    Assert.assertEquals((String)"Should be the ledger I just marked", (Object)lA, (Object)ledgerA);
                    TestLedgerUnderreplicationManager.this.isLedgerReplicationDisabled = false;
                    znodeLatch.countDown();
                }
                catch (ReplicationException.UnavailableException e) {
                    LOG.debug("Unexpected exception while marking urLedger", (Throwable)e);
                    TestLedgerUnderreplicationManager.this.isLedgerReplicationDisabled = false;
                }
            }
        };
        thread1.start();
        try {
            Assert.assertFalse((String)"shouldn't complete", (boolean)znodeLatch.await(1L, TimeUnit.SECONDS));
            Assert.assertTrue((String)"Ledger replication is not disabled!", (boolean)this.isLedgerReplicationDisabled);
            Assert.assertEquals((String)"Failed to disable ledger replication!", (long)2L, (long)znodeLatch.getCount());
            replicaMgr.enableLedgerReplication();
            znodeLatch.await(5L, TimeUnit.SECONDS);
            LOG.debug("Enabled Ledeger Replication");
            Assert.assertTrue((String)"Ledger replication is not disabled!", (!this.isLedgerReplicationDisabled ? 1 : 0) != 0);
            Assert.assertEquals((String)"Failed to disable ledger replication!", (long)0L, (long)znodeLatch.getCount());
        }
        finally {
            thread1.interrupt();
        }
    }

    @Test
    public void testHierarchyCleanup() throws Exception {
        long l2;
        long[] ledgers;
        LedgerUnderreplicationManager replicaMgr = this.lmf1.newLedgerUnderreplicationManager();
        for (long l2 : ledgers = new long[]{3735928559L, 3735928558L, 3203386110L, 3405697037L}) {
            replicaMgr.markLedgerUnderreplicated(l2, "localhost:3181");
        }
        String testPath = this.urLedgerPath + "/0000/0000";
        List children = this.zkc1.getChildren(testPath, false);
        Assert.assertEquals((String)"Wrong number of hierarchies", (long)3L, (long)children.size());
        int marked = 0;
        while (marked < 3) {
            l2 = replicaMgr.getLedgerToRereplicate();
            if (l2 != ledgers[0]) {
                replicaMgr.markLedgerReplicated(l2);
                ++marked;
                continue;
            }
            replicaMgr.releaseUnderreplicatedLedger(l2);
        }
        children = this.zkc1.getChildren(testPath, false);
        Assert.assertEquals((String)"Wrong number of hierarchies", (long)1L, (long)children.size());
        l2 = replicaMgr.getLedgerToRereplicate();
        Assert.assertEquals((String)"Got wrong ledger", (long)ledgers[0], (long)l2);
        replicaMgr.markLedgerReplicated(l2);
        children = this.zkc1.getChildren(this.urLedgerPath, false);
        Assert.assertEquals((String)"All hierarchies should be cleaned up", (long)0L, (long)children.size());
    }

    @Test
    public void testHierarchyCleanupInterference() throws Exception {
        final LedgerUnderreplicationManager replicaMgr1 = this.lmf1.newLedgerUnderreplicationManager();
        final LedgerUnderreplicationManager replicaMgr2 = this.lmf2.newLedgerUnderreplicationManager();
        int iterations = 100;
        final AtomicBoolean threadFailed = new AtomicBoolean(false);
        Thread markUnder = new Thread(){

            @Override
            public void run() {
                long l = 1L;
                try {
                    for (int i = 0; i < 100; ++i) {
                        replicaMgr1.markLedgerUnderreplicated(l, "localhost:3181");
                        l += 10000L;
                    }
                }
                catch (Exception e) {
                    LOG.error("markUnder Thread failed with exception", (Throwable)e);
                    threadFailed.set(true);
                    return;
                }
            }
        };
        final AtomicInteger processed = new AtomicInteger(0);
        Thread markRepl = new Thread(){

            @Override
            public void run() {
                try {
                    for (int i = 0; i < 100; ++i) {
                        long l = replicaMgr2.getLedgerToRereplicate();
                        replicaMgr2.markLedgerReplicated(l);
                        processed.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    LOG.error("markRepl Thread failed with exception", (Throwable)e);
                    threadFailed.set(true);
                    return;
                }
            }
        };
        markRepl.setDaemon(true);
        markUnder.setDaemon(true);
        markRepl.start();
        markUnder.start();
        markUnder.join();
        Assert.assertFalse((String)"Thread failed to complete", (boolean)threadFailed.get());
        int lastProcessed = 0;
        while (true) {
            markRepl.join(10000L);
            if (!markRepl.isAlive()) break;
            Assert.assertFalse((String)"markRepl thread not progressing", (lastProcessed == processed.get() ? 1 : 0) != 0);
        }
        Assert.assertFalse((String)"Thread failed to complete", (boolean)threadFailed.get());
        List children = this.zkc1.getChildren(this.urLedgerPath, false);
        for (String s : children) {
            LOG.info("s: {}", (Object)s);
        }
        Assert.assertEquals((String)"All hierarchies should be cleaned up", (long)0L, (long)children.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckAllLedgersCTime() throws Exception {
        LedgerUnderreplicationManager underReplicaMgr1 = this.lmf1.newLedgerUnderreplicationManager();
        try {
            LedgerUnderreplicationManager underReplicaMgr2 = this.lmf2.newLedgerUnderreplicationManager();
            try {
                Assert.assertEquals((long)-1L, (long)underReplicaMgr1.getCheckAllLedgersCTime());
                long curTime = System.currentTimeMillis();
                underReplicaMgr2.setCheckAllLedgersCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getCheckAllLedgersCTime());
                curTime = System.currentTimeMillis();
                underReplicaMgr2.setCheckAllLedgersCTime(curTime);
                Assert.assertEquals((long)curTime, (long)underReplicaMgr1.getCheckAllLedgersCTime());
            }
            finally {
                if (Collections.singletonList(underReplicaMgr2).get(0) != null) {
                    underReplicaMgr2.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(underReplicaMgr1).get(0) != null) {
                underReplicaMgr1.close();
            }
        }
    }

    private void verifyMarkLedgerUnderreplicated(Collection<String> missingReplica) throws KeeperException, InterruptedException, ReplicationException {
        Long ledgerA = 1093839814060L;
        String znodeA = this.getUrLedgerZnode(ledgerA);
        LedgerUnderreplicationManager replicaMgr = this.lmf1.newLedgerUnderreplicationManager();
        for (String replica : missingReplica) {
            replicaMgr.markLedgerUnderreplicated(ledgerA.longValue(), replica);
        }
        String urLedgerA = this.getData(znodeA);
        DataFormats.UnderreplicatedLedgerFormat.Builder builderA = DataFormats.UnderreplicatedLedgerFormat.newBuilder();
        for (String replica : missingReplica) {
            builderA.addReplica(replica);
        }
        ProtocolStringList replicaList = builderA.getReplicaList();
        for (String replica : missingReplica) {
            Assert.assertTrue((String)("UrLedger:" + urLedgerA + " doesn't contain failed bookie :" + replica), (boolean)replicaList.contains(replica));
        }
    }

    private String getData(String znode) {
        try {
            byte[] data = this.zkc1.getData(znode, false, null);
            return new String(data);
        }
        catch (KeeperException e) {
            LOG.error("Exception while reading data from znode :" + znode);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOG.error("Exception while reading data from znode :" + znode);
        }
        return "";
    }

    private String getUrLedgerZnode(long ledgerId) {
        return ZkLedgerUnderreplicationManager.getUrLedgerZnode((String)this.urLedgerPath, (long)ledgerId);
    }

    private void takeLedgerAndRelease(LedgerUnderreplicationManager m, CountDownLatch latch, int numberOfIterations) {
        for (int i = 0; i < numberOfIterations; ++i) {
            try {
                long ledgerToRereplicate = m.getLedgerToRereplicate();
                m.releaseUnderreplicatedLedger(ledgerToRereplicate);
            }
            catch (ReplicationException.UnavailableException e) {
                LOG.error("UnavailableException when taking or releasing lock", (Throwable)e);
            }
            latch.countDown();
        }
    }
}

