/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.sasl;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.login.Configuration;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.sasl.SASLBookieAuthProviderFactory;
import org.apache.bookkeeper.sasl.SASLClientProviderFactory;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5DigestBookKeeperTest
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(MD5DigestBookKeeperTest.class);
    private static final byte[] PASSWD = "testPasswd".getBytes();
    private static final byte[] ENTRY = "TestEntry".getBytes();

    public MD5DigestBookKeeperTest() {
        super(0);
    }

    private void connectAndWriteToBookie(ClientConfiguration conf, AtomicLong ledgerWritten) throws Exception {
        LOG.info("Connecting to bookie");
        BookKeeper bkc = new BookKeeper(conf, this.zkc);
        LedgerHandle l = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, PASSWD);
        ledgerWritten.set(l.getId());
        l.addEntry(ENTRY);
        l.close();
        bkc.close();
    }

    /*
     * Exception decompiling
     */
    private int entryCount(long ledgerId, ServerConfiguration bookieConf, ClientConfiguration clientConf) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test
    public void testSingleMessageAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(SASLBookieAuthProviderFactory.class.getName());
        bookieConf.setProperty("saslJaasClientAllowedIds", (Object)".*hd.*");
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SASLClientProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    BookieServer startAndStoreBookie(ServerConfiguration conf) throws Exception {
        this.bsConfs.add(conf);
        BookieServer s = this.startBookie(conf);
        this.bs.add(s);
        return s;
    }

    @AfterClass
    public static void resetJAAS() {
        System.clearProperty("java.security.auth.login.config");
        Configuration.getConfiguration().refresh();
    }

    static {
        System.setProperty("java.security.auth.login.config", new File("src/test/resources/jaas_md5.conf").getAbsolutePath());
    }
}

