/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.AuditorElector;
import org.apache.bookkeeper.server.http.BKHttpServiceProvider;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestHttpService
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestHttpService.class);
    private BKHttpServiceProvider bkHttpServiceProvider;
    private static final int numberOfBookies = 6;
    AuditorElector auditorElector;

    public TestHttpService() {
        super(6);
        try {
            File tmpDir = this.createTempDir("bookie_http", "test");
            this.baseConf.setJournalDirName(tmpDir.getPath()).setLedgerDirNames(new String[]{tmpDir.getPath()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.baseClientConf.setStoreSystemtimeAsLedgerCreationTime(true);
        this.bkHttpServiceProvider = new BKHttpServiceProvider.Builder().setBookieServer((BookieServer)this.bs.get(5)).setServerConfiguration(this.baseConf).build();
    }

    @Test
    public void testHeartbeatService() throws Exception {
        HttpEndpointService heartbeatService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.HEARTBEAT);
        HttpServiceResponse response = heartbeatService.handle(null);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"OK\n", (Object)response.getBody());
    }

    @Test
    public void testConfigServiceGet() throws Exception {
        try {
            String testProperty = "TEST_PROPERTY";
            String testValue = "TEST_VALUE";
            this.baseConf.setProperty(testProperty, (Object)testValue);
            HttpEndpointService configService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.SERVER_CONFIG);
            HttpServiceRequest getRequest = new HttpServiceRequest(null, HttpServer.Method.GET, null);
            HttpServiceResponse response = configService.handle(getRequest);
            Map configMap = (Map)JsonUtil.fromJson((String)response.getBody(), Map.class);
            Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
            Assert.assertEquals((Object)testValue, configMap.get(testProperty));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testConfigServicePut() throws Exception {
        HttpEndpointService configService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.SERVER_CONFIG);
        String putBody = "{\"TEST_PROPERTY1\": \"TEST_VALUE1\", \"TEST_PROPERTY2\": 2,  \"TEST_PROPERTY3\": true }";
        HttpServiceRequest putRequest1 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse putResponse1 = configService.handle(putRequest1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)putResponse1.getStatusCode());
        HttpServiceRequest putRequest2 = new HttpServiceRequest(putBody, HttpServer.Method.DELETE, null);
        HttpServiceResponse putResponse2 = configService.handle(putRequest2);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)putResponse2.getStatusCode());
        HttpServiceRequest putRequest3 = new HttpServiceRequest(putBody, HttpServer.Method.PUT, null);
        HttpServiceResponse putResponse3 = configService.handle(putRequest3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)putResponse3.getStatusCode());
        HttpServiceRequest getRequest = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response = configService.handle(getRequest);
        Map configMap = (Map)JsonUtil.fromJson((String)response.getBody(), Map.class);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response.getStatusCode());
        Assert.assertEquals((Object)"TEST_VALUE1", configMap.get("TEST_PROPERTY1"));
        Assert.assertEquals((Object)"2", configMap.get("TEST_PROPERTY2"));
        Assert.assertEquals((Object)"true", configMap.get("TEST_PROPERTY3"));
    }

    @Test
    public void testListBookiesService() throws Exception {
        HttpEndpointService listBookiesService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LIST_BOOKIES);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = listBookiesService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response1.getStatusCode());
        HashMap respBody = (HashMap)JsonUtil.fromJson((String)response1.getBody(), HashMap.class);
        Assert.assertEquals((long)6L, (long)respBody.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((Object)true, (Object)respBody.containsKey(this.getBookie(i).toString()));
            Assert.assertEquals(null, respBody.get(this.getBookie(i).toString()));
        }
        HashMap params = Maps.newHashMap();
        params.put("type", "rw");
        params.put("print_hostnames", "true");
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        HttpServiceResponse response2 = listBookiesService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        HashMap respBody2 = (HashMap)JsonUtil.fromJson((String)response2.getBody(), HashMap.class);
        Assert.assertEquals((long)6L, (long)respBody2.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((Object)true, (Object)respBody2.containsKey(this.getBookie(i).toString()));
            Assert.assertNotNull(respBody2.get(this.getBookie(i).toString()));
        }
        this.setBookieToReadOnly(this.getBookie(1));
        Thread.sleep(200L);
        HashMap params3 = Maps.newHashMap();
        params3.put("type", "ro");
        params3.put("print_hostnames", "true");
        HttpServiceRequest request3 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params3);
        HttpServiceResponse response3 = listBookiesService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
        HashMap respBody3 = (HashMap)JsonUtil.fromJson((String)response3.getBody(), HashMap.class);
        Assert.assertEquals((long)1L, (long)respBody3.size());
        Assert.assertEquals((Object)true, (Object)respBody3.containsKey(this.getBookie(1).toString()));
        HashMap params4 = Maps.newHashMap();
        params4.put("type", "rw");
        params4.put("print_hostnames", "true");
        HttpServiceRequest request4 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params4);
        HttpServiceResponse response4 = listBookiesService.handle(request4);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response4.getStatusCode());
        HashMap respBody4 = (HashMap)JsonUtil.fromJson((String)response4.getBody(), HashMap.class);
        Assert.assertEquals((long)5L, (long)respBody4.size());
        Assert.assertEquals((Object)true, (Object)respBody4.containsKey(this.getBookie(2).toString()));
    }

    @Test
    public void testListLedgerService() throws Exception {
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 430;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i = 0; i < numLedgers; ++i) {
            lh[i] = this.bkc.createLedger(digestType, "password".getBytes());
        }
        HttpEndpointService listLedgerService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LIST_LEDGER);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = listLedgerService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response1.getStatusCode());
        LinkedHashMap respBody = (LinkedHashMap)JsonUtil.fromJson((String)response1.getBody(), LinkedHashMap.class);
        Assert.assertEquals((long)numLedgers, (long)respBody.size());
        for (int i = 0; i < numLedgers; ++i) {
            Assert.assertEquals((Object)true, (Object)respBody.containsKey(Long.valueOf(lh[i].getId()).toString()));
            Assert.assertEquals(null, respBody.get(Long.valueOf(lh[i].getId()).toString()));
        }
        HashMap params = Maps.newHashMap();
        params.put("print_metadata", "true");
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        HttpServiceResponse response2 = listLedgerService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        LinkedHashMap respBody2 = (LinkedHashMap)JsonUtil.fromJson((String)response2.getBody(), LinkedHashMap.class);
        Assert.assertEquals((long)numLedgers, (long)respBody2.size());
        for (int i = 0; i < numLedgers; ++i) {
            Assert.assertEquals((Object)true, (Object)respBody2.containsKey(Long.valueOf(lh[i].getId()).toString()));
            Assert.assertNotNull(respBody2.get(Long.valueOf(lh[i].getId()).toString()));
        }
        HashMap params3 = Maps.newHashMap();
        params3.put("print_metadata", "true");
        params3.put("page", "5");
        HttpServiceRequest request3 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params3);
        HttpServiceResponse response3 = listLedgerService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
        LinkedHashMap respBody3 = (LinkedHashMap)JsonUtil.fromJson((String)response3.getBody(), LinkedHashMap.class);
        Assert.assertEquals((long)31L, (long)respBody3.size());
        for (int i = 400; i < 430; ++i) {
            Assert.assertEquals((Object)true, (Object)respBody3.containsKey(Long.valueOf(lh[i].getId()).toString()));
            Assert.assertNotNull(respBody3.get(Long.valueOf(lh[i].getId()).toString()));
        }
    }

    @Test
    public void testDeleteLedgerService() throws Exception {
        int i;
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 4;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "".getBytes());
        }
        String content = "Apache BookKeeper is cool!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService deleteLedgerService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.DELETE_LEDGER);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = deleteLedgerService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.DELETE, null);
        HttpServiceResponse response2 = deleteLedgerService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response2.getStatusCode());
        HashMap params = Maps.newHashMap();
        Long ledgerId = lh[0].getId();
        params.put("ledger_id", ledgerId.toString());
        HttpServiceRequest request3 = new HttpServiceRequest(null, HttpServer.Method.DELETE, (Map)params);
        HttpServiceResponse response3 = deleteLedgerService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
        HttpEndpointService listLedgerService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LIST_LEDGER);
        HttpServiceRequest request4 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response4 = listLedgerService.handle(request4);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response4.getStatusCode());
        LinkedHashMap respBody = (LinkedHashMap)JsonUtil.fromJson((String)response4.getBody(), LinkedHashMap.class);
        Assert.assertEquals((long)3L, (long)respBody.size());
    }

    @Test
    public void testGetLedgerMetaService() throws Exception {
        int i;
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 4;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "password".getBytes());
        }
        String content = "Apache BookKeeper is cool!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService getLedgerMetaService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.GET_LEDGER_META);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = getLedgerMetaService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HashMap params = Maps.newHashMap();
        Long ledgerId = lh[0].getId();
        params.put("ledger_id", ledgerId.toString());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        HttpServiceResponse response2 = getLedgerMetaService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        HashMap respBody = (HashMap)JsonUtil.fromJson((String)response2.getBody(), HashMap.class);
        Assert.assertEquals((long)1L, (long)respBody.size());
        HashMap expected = (HashMap)JsonUtil.fromJson((String)JsonUtil.toJson((Object)lh[0].getLedgerMetadata()), HashMap.class);
        HashMap actual = (HashMap)respBody.get(ledgerId.toString());
        Assert.assertTrue((boolean)Maps.difference((Map)expected, (Map)actual).areEqual());
    }

    @Test
    public void testReadLedgerEntryService() throws Exception {
        int i;
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 1;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "".getBytes());
        }
        String content = "Apache BookKeeper is cool!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService readLedgerEntryService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.READ_LEDGER_ENTRY);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = readLedgerEntryService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HashMap params = Maps.newHashMap();
        Long ledgerId = lh[0].getId();
        params.put("ledger_id", ledgerId.toString());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        HttpServiceResponse response2 = readLedgerEntryService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        HashMap respBody = (HashMap)JsonUtil.fromJson((String)response2.getBody(), HashMap.class);
        Assert.assertEquals((long)100L, (long)respBody.size());
        HashMap params3 = Maps.newHashMap();
        params3.put("ledger_id", ledgerId.toString());
        params3.put("start_entry_id", "1");
        params3.put("end_entry_id", "77");
        HttpServiceRequest request3 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params3);
        HttpServiceResponse response3 = readLedgerEntryService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
        HashMap respBody3 = (HashMap)JsonUtil.fromJson((String)response3.getBody(), HashMap.class);
        Assert.assertEquals((long)77L, (long)respBody3.size());
        Assert.assertTrue((boolean)((String)respBody3.get("17")).equals(content));
    }

    @Test
    public void testListBookieInfoService() throws Exception {
        HttpEndpointService listBookieInfoService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LIST_BOOKIE_INFO);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response1 = listBookieInfoService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response2 = listBookieInfoService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        LinkedHashMap respBody = (LinkedHashMap)JsonUtil.fromJson((String)response2.getBody(), LinkedHashMap.class);
        Assert.assertEquals((long)7L, (long)respBody.size());
        for (int i = 0; i < 6; ++i) {
            Assert.assertEquals((Object)true, (Object)respBody.containsKey(this.getBookie(i).toString()));
        }
    }

    @Test
    public void testGetLastLogMarkService() throws Exception {
        int i;
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 4;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "".getBytes());
        }
        String content = "Apache BookKeeper is cool!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService getLastLogMarkService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LAST_LOG_MARK);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response1 = getLastLogMarkService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response2 = getLastLogMarkService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        HashMap respBody = (HashMap)JsonUtil.fromJson((String)response2.getBody(), HashMap.class);
        Assert.assertEquals((long)1L, (long)respBody.size());
    }

    @Test
    public void testListDiskFilesService() throws Exception {
        int i;
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 4;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "".getBytes());
        }
        String content = "Apache BookKeeper is cool!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService listDiskFileService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LIST_DISK_FILE);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = listDiskFileService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response1.getStatusCode());
        HashMap respBody = (HashMap)JsonUtil.fromJson((String)response1.getBody(), HashMap.class);
        Assert.assertEquals((long)3L, (long)respBody.size());
        HashMap params = Maps.newHashMap();
        params.put("file_type", "journal");
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, (Map)params);
        HttpServiceResponse response2 = listDiskFileService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        HashMap respBody2 = (HashMap)JsonUtil.fromJson((String)response2.getBody(), HashMap.class);
        Assert.assertEquals((long)1L, (long)respBody2.size());
    }

    @Test
    public void testRecoveryBookieService() throws Exception {
        HttpEndpointService recoveryBookieService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.RECOVERY_BOOKIE);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = recoveryBookieService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response2 = recoveryBookieService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response2.getStatusCode());
        String bookieSrc = this.getBookie(0).toString();
        String putBody3 = "{\"bookie_src\": [ \"" + bookieSrc + "\" ],\"delete_cookie\": false }";
        HttpServiceRequest request3 = new HttpServiceRequest(putBody3, HttpServer.Method.PUT, null);
        HttpServiceResponse response3 = recoveryBookieService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
        String putBody5 = "{\"bookie_src\": [ \"" + bookieSrc + "\" ] }";
        HttpServiceRequest request5 = new HttpServiceRequest(putBody5, HttpServer.Method.PUT, null);
        HttpServiceResponse response5 = recoveryBookieService.handle(request5);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response5.getStatusCode());
    }

    private Future<?> startAuditorElector() throws Exception {
        String addr = ((BookieServer)this.bs.get(0)).getLocalAddress().toString();
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setAuditorPeriodicBookieCheckInterval(1L);
        conf.setMetadataServiceUri("zk://" + this.zkUtil.getZooKeeperConnectString() + "/ledgers");
        this.auditorElector = new AuditorElector(addr, conf);
        return this.auditorElector.start();
    }

    private void stopAuditorElector() throws Exception {
        this.auditorElector.shutdown();
    }

    @Test
    public void testTriggerAuditService() throws Exception {
        this.startAuditorElector();
        HttpEndpointService triggerAuditService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.TRIGGER_AUDIT);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = triggerAuditService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        this.killBookie(1);
        Thread.sleep(500L);
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response2 = triggerAuditService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
        this.stopAuditorElector();
    }

    @Test
    public void testWhoIsAuditorService() throws Exception {
        this.startAuditorElector().get();
        HttpEndpointService whoIsAuditorService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.WHO_IS_AUDITOR);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = whoIsAuditorService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response1.getStatusCode());
        LOG.info(response1.getBody());
        this.stopAuditorElector();
    }

    @Test
    public void testListUnderReplicatedLedgerService() throws Exception {
        MetadataDrivers.runFunctionWithLedgerManagerFactory((ServerConfiguration)this.baseConf, mFactory -> {
            try {
                this.testListUnderReplicatedLedgerService((LedgerManagerFactory)mFactory);
            }
            catch (Exception e) {
                LOG.info("Exception in test", (Throwable)e);
                throw new UncheckedExecutionException(e.getMessage(), e.getCause());
            }
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testListUnderReplicatedLedgerService(LedgerManagerFactory mFactory) throws Exception {
        this.startAuditorElector();
        HttpEndpointService listUnderReplicatedLedgerService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LIST_UNDER_REPLICATED_LEDGER);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response1 = listUnderReplicatedLedgerService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        LedgerManager ledgerManager = mFactory.newLedgerManager();
        try {
            LedgerUnderreplicationManager underReplicationManager = mFactory.newLedgerUnderreplicationManager();
            try {
                LedgerMetadataBuilder metadata = LedgerMetadataBuilder.create().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(3).newEnsembleEntry(0L, (List)Lists.newArrayList((Object[])new BookieSocketAddress[]{new BookieSocketAddress("192.0.2.1", 1000), this.getBookie(0), this.getBookie(1)}));
                ClientUtil.setupLedger(ledgerManager, 1L, metadata);
                long underReplicatedLedger = -1L;
                for (int i = 0; i < 120; ++i) {
                    underReplicatedLedger = underReplicationManager.pollLedgerToRereplicate();
                    if (underReplicatedLedger != -1L) {
                        LOG.info("Underreplicated ledgers found, breaking out of loop");
                        break;
                    }
                    Thread.sleep(1000L);
                }
                Assert.assertTrue((underReplicatedLedger != -1L ? 1 : 0) != 0);
                HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
                HttpServiceResponse response2 = listUnderReplicatedLedgerService.handle(request2);
                Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
                this.stopAuditorElector();
            }
            finally {
                if (Collections.singletonList(underReplicationManager).get(0) != null) {
                    underReplicationManager.close();
                }
            }
        }
        finally {
            if (Collections.singletonList(ledgerManager).get(0) != null) {
                ledgerManager.close();
            }
        }
    }

    @Test
    public void testLostBookieRecoveryDelayService() throws Exception {
        HttpEndpointService lostBookieRecoveryDelayService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.LOST_BOOKIE_RECOVERY_DELAY);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response1 = lostBookieRecoveryDelayService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response2 = lostBookieRecoveryDelayService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response2.getStatusCode());
        String putBody3 = "{\"delay_seconds\": 17 }";
        HttpServiceRequest request3 = new HttpServiceRequest(putBody3, HttpServer.Method.PUT, null);
        HttpServiceResponse response3 = lostBookieRecoveryDelayService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
    }

    @Test
    public void testDecommissionService() throws Exception {
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        this.startAuditorElector();
        HttpEndpointService decommissionService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.DECOMMISSION);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response1 = decommissionService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response1.getStatusCode());
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response2 = decommissionService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response2.getStatusCode());
        String putBody3 = "{\"bookie_src\": \"" + this.getBookie(1).toString() + "\"}";
        HttpServiceRequest request3 = new HttpServiceRequest(putBody3, HttpServer.Method.PUT, null);
        this.killBookie(1);
        HttpServiceResponse response3 = decommissionService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response3.getStatusCode());
        this.stopAuditorElector();
    }

    @Test
    public void testTriggerGCService() throws Exception {
        int i;
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 4;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "".getBytes());
        }
        String content = "Apache BookKeeper is cool!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService triggerGCService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.GC);
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = triggerGCService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response1.getStatusCode());
        Assert.assertTrue((boolean)response1.getBody().contains("\"is_in_force_gc\" : \"false\""));
        HttpServiceRequest request2 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response2 = triggerGCService.handle(request2);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response2.getStatusCode());
    }

    @Test
    public void testGCDetailsService() throws Exception {
        int i;
        this.baseConf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
        int numLedgers = 4;
        int numMsgs = 100;
        LedgerHandle[] lh = new LedgerHandle[numLedgers];
        for (int i2 = 0; i2 < numLedgers; ++i2) {
            lh[i2] = this.bkc.createLedger(digestType, "".getBytes());
        }
        String content = "This is test for GC details service!";
        for (i = 0; i < numMsgs; ++i) {
            for (int j = 0; j < numLedgers; ++j) {
                lh[j].addEntry(content.getBytes());
            }
        }
        for (i = 0; i < numLedgers; ++i) {
            lh[i].close();
        }
        HttpEndpointService gcDetailsService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.GC_DETAILS);
        HttpEndpointService triggerGCService = this.bkHttpServiceProvider.provideHttpEndpointService(HttpServer.ApiType.GC);
        HttpServiceRequest request0 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response0 = triggerGCService.handle(request0);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response0.getStatusCode());
        HttpServiceRequest request1 = new HttpServiceRequest(null, HttpServer.Method.GET, null);
        HttpServiceResponse response1 = gcDetailsService.handle(request1);
        Assert.assertEquals((long)HttpServer.StatusCode.OK.getValue(), (long)response1.getStatusCode());
        LOG.info("Get response: {}", (Object)response1.getBody());
        HttpServiceRequest request3 = new HttpServiceRequest(null, HttpServer.Method.PUT, null);
        HttpServiceResponse response3 = gcDetailsService.handle(request3);
        Assert.assertEquals((long)HttpServer.StatusCode.NOT_FOUND.getValue(), (long)response3.getStatusCode());
    }
}

