/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Transaction;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public interface ZooKeeperCluster {
    public ZooKeeper getZooKeeperClient();

    public String getZooKeeperConnectString();

    public String getMetadataServiceUri();

    public String getMetadataServiceUri(String var1);

    public String getMetadataServiceUri(String var1, String var2);

    public void startCluster() throws Exception;

    public void stopCluster() throws Exception;

    public void restartCluster() throws Exception;

    public void killCluster() throws Exception;

    public void sleepCluster(int var1, TimeUnit var2, CountDownLatch var3) throws InterruptedException, IOException;

    default public void expireSession(ZooKeeper zk) throws Exception {
        long id = zk.getSessionId();
        byte[] password = zk.getSessionPasswd();
        ZooKeeperWatcherBase w = new ZooKeeperWatcherBase(10000);
        ZooKeeper zk2 = new ZooKeeper(this.getZooKeeperConnectString(), zk.getSessionTimeout(), (Watcher)w, id, password);
        w.waitForConnection();
        zk2.close();
    }

    default public void createBKEnsemble(String ledgersPath) throws KeeperException, InterruptedException {
        Transaction txn = this.getZooKeeperClient().transaction();
        txn.create(ledgersPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        txn.create(ledgersPath + "/" + "available", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        txn.create(ledgersPath + "/" + "available" + "/" + "readonly", new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        txn.commit();
    }
}

