/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.DefaultSpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.client.SpeculativeRequestExecutionPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.feature.SettableFeatureProvider;

class ClientInternalConf {
    final Feature disableEnsembleChangeFeature;
    final boolean delayEnsembleChange;
    final Optional<SpeculativeRequestExecutionPolicy> readSpeculativeRequestPolicy;
    final Optional<SpeculativeRequestExecutionPolicy> readLACSpeculativeRequestPolicy;
    final int explicitLacInterval;
    final long waitForWriteSetMs;
    final long addEntryQuorumTimeoutNanos;
    final boolean enableParallelRecoveryRead;
    final boolean enableReorderReadSequence;
    final boolean enableStickyReads;
    final int recoveryReadBatchSize;
    final int throttleValue;
    final int bookieFailureHistoryExpirationMSec;
    final int maxAllowedEnsembleChanges;
    final long timeoutMonitorIntervalSec;
    final boolean enableBookieFailureTracking;
    final boolean useV2WireProtocol;

    static ClientInternalConf defaultValues() {
        return ClientInternalConf.fromConfig(new ClientConfiguration());
    }

    static ClientInternalConf fromConfig(ClientConfiguration conf) {
        return ClientInternalConf.fromConfigAndFeatureProvider(conf, SettableFeatureProvider.DISABLE_ALL);
    }

    static ClientInternalConf fromConfigAndFeatureProvider(ClientConfiguration conf, FeatureProvider featureProvider) {
        return new ClientInternalConf(conf, featureProvider);
    }

    private ClientInternalConf(ClientConfiguration conf, FeatureProvider featureProvider) {
        this.explicitLacInterval = conf.getExplictLacInterval();
        this.enableReorderReadSequence = conf.isReorderReadSequenceEnabled();
        this.enableParallelRecoveryRead = conf.getEnableParallelRecoveryRead();
        this.recoveryReadBatchSize = conf.getRecoveryReadBatchSize();
        this.waitForWriteSetMs = conf.getWaitTimeoutOnBackpressureMillis();
        this.addEntryQuorumTimeoutNanos = TimeUnit.SECONDS.toNanos(conf.getAddEntryQuorumTimeout());
        this.throttleValue = conf.getThrottleValue();
        this.bookieFailureHistoryExpirationMSec = conf.getBookieFailureHistoryExpirationMSec();
        this.disableEnsembleChangeFeature = featureProvider.getFeature(conf.getDisableEnsembleChangeFeatureName());
        this.delayEnsembleChange = conf.getDelayEnsembleChange();
        this.maxAllowedEnsembleChanges = conf.getMaxAllowedEnsembleChanges();
        this.timeoutMonitorIntervalSec = conf.getTimeoutMonitorIntervalSec();
        this.enableBookieFailureTracking = conf.getEnableBookieFailureTracking();
        this.useV2WireProtocol = conf.getUseV2WireProtocol();
        this.enableStickyReads = conf.isStickyReadsEnabled();
        this.readSpeculativeRequestPolicy = conf.getFirstSpeculativeReadTimeout() > 0 ? Optional.of((Object)new DefaultSpeculativeRequestExecutionPolicy(conf.getFirstSpeculativeReadTimeout(), conf.getMaxSpeculativeReadTimeout(), conf.getSpeculativeReadTimeoutBackoffMultiplier())) : Optional.absent();
        this.readLACSpeculativeRequestPolicy = conf.getFirstSpeculativeReadLACTimeout() > 0 ? Optional.of((Object)new DefaultSpeculativeRequestExecutionPolicy(conf.getFirstSpeculativeReadLACTimeout(), conf.getMaxSpeculativeReadLACTimeout(), conf.getSpeculativeReadLACTimeoutBackoffMultiplier())) : Optional.absent();
    }
}

