/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerMetadataImpl
implements LedgerMetadata {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadataImpl.class);
    private final int metadataFormatVersion;
    private final int ensembleSize;
    private final int writeQuorumSize;
    private final int ackQuorumSize;
    private final LedgerMetadata.State state;
    private final long length;
    private final long lastEntryId;
    private final long ctime;
    final boolean storeCtime;
    private final NavigableMap<Long, ImmutableList<BookieSocketAddress>> ensembles;
    private final ImmutableList<BookieSocketAddress> currentEnsemble;
    private final boolean hasPassword;
    private final DigestType digestType;
    private final byte[] password;
    private final Map<String, byte[]> customMetadata;

    LedgerMetadataImpl(int metadataFormatVersion, int ensembleSize, int writeQuorumSize, int ackQuorumSize, LedgerMetadata.State state, Optional<Long> lastEntryId, Optional<Long> length, Map<Long, List<BookieSocketAddress>> ensembles, Optional<DigestType> digestType, Optional<byte[]> password, long ctime, boolean storeCtime, Map<String, byte[]> customMetadata) {
        Preconditions.checkArgument((ensembles.size() > 0 ? 1 : 0) != 0, (Object)"There must be at least one ensemble in the ledger");
        if (state == LedgerMetadata.State.CLOSED) {
            Preconditions.checkArgument((boolean)length.isPresent(), (Object)"Closed ledger must have a length");
            Preconditions.checkArgument((boolean)lastEntryId.isPresent(), (Object)"Closed ledger must have a last entry");
        } else {
            Preconditions.checkArgument((!length.isPresent() ? 1 : 0) != 0, (Object)"Non-closed ledger must not have a length");
            Preconditions.checkArgument((!lastEntryId.isPresent() ? 1 : 0) != 0, (Object)"Non-closed ledger must not have a last entry");
        }
        Preconditions.checkArgument((digestType.isPresent() && password.isPresent() || !digestType.isPresent() && !password.isPresent() ? 1 : 0) != 0, (Object)"Either both password and digest type must be set, or neither");
        this.metadataFormatVersion = metadataFormatVersion;
        this.ensembleSize = ensembleSize;
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.state = state;
        this.lastEntryId = lastEntryId.orElse(-1L);
        this.length = length.orElse(0L);
        this.ensembles = Collections.unmodifiableNavigableMap(ensembles.entrySet().stream().collect(TreeMap::new, (m, e) -> m.put(e.getKey(), ImmutableList.copyOf((Collection)((Collection)e.getValue()))), TreeMap::putAll));
        this.currentEnsemble = state != LedgerMetadata.State.CLOSED ? this.ensembles.lastEntry().getValue() : null;
        if (password.isPresent()) {
            this.password = password.get();
            this.digestType = digestType.get();
            this.hasPassword = true;
        } else {
            this.password = null;
            this.hasPassword = false;
            this.digestType = null;
        }
        this.ctime = ctime;
        this.storeCtime = storeCtime;
        this.customMetadata = ImmutableMap.copyOf(customMetadata);
    }

    @Override
    public NavigableMap<Long, ? extends List<BookieSocketAddress>> getAllEnsembles() {
        return this.ensembles;
    }

    @Override
    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    @Override
    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    @Override
    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    @Override
    public long getCtime() {
        return this.ctime;
    }

    @Override
    public boolean hasPassword() {
        return this.hasPassword;
    }

    @Override
    public byte[] getPassword() {
        if (!this.hasPassword()) {
            return new byte[0];
        }
        return Arrays.copyOf(this.password, this.password.length);
    }

    @Override
    public DigestType getDigestType() {
        if (!this.hasPassword()) {
            return null;
        }
        return this.digestType;
    }

    @Override
    public long getLastEntryId() {
        return this.lastEntryId;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public boolean isClosed() {
        return this.state == LedgerMetadata.State.CLOSED;
    }

    @Override
    public LedgerMetadata.State getState() {
        return this.state;
    }

    @Override
    public List<BookieSocketAddress> getEnsembleAt(long entryId) {
        return (List)this.ensembles.get(this.ensembles.headMap(entryId + 1L).lastKey());
    }

    @Override
    public Map<String, byte[]> getCustomMetadata() {
        return this.customMetadata;
    }

    public String toString() {
        return this.toStringRepresentation(true);
    }

    @Override
    public String toSafeString() {
        return this.toStringRepresentation(false);
    }

    private String toStringRepresentation(boolean withPassword) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"LedgerMetadata");
        helper.add("formatVersion", this.metadataFormatVersion).add("ensembleSize", this.ensembleSize).add("writeQuorumSize", this.writeQuorumSize).add("ackQuorumSize", this.ackQuorumSize).add("state", (Object)this.state);
        if (this.state == LedgerMetadata.State.CLOSED) {
            helper.add("length", this.length).add("lastEntryId", this.lastEntryId);
        }
        if (this.hasPassword()) {
            helper.add("digestType", (Object)this.digestType);
            if (withPassword) {
                helper.add("password", (Object)("base64:" + Base64.getEncoder().encodeToString(this.password)));
            } else {
                helper.add("password", (Object)"OMITTED");
            }
        }
        helper.add("ensembles", (Object)this.ensembles.toString());
        helper.add("customMetadata", this.customMetadata.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> "base64:" + Base64.getEncoder().encodeToString((byte[])e.getValue()))));
        return helper.toString();
    }

    @Override
    public int getMetadataFormatVersion() {
        return this.metadataFormatVersion;
    }

    boolean shouldStoreCtime() {
        return this.storeCtime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerMetadataImpl)) {
            return false;
        }
        LedgerMetadataImpl other = (LedgerMetadataImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMetadataFormatVersion() != other.getMetadataFormatVersion()) {
            return false;
        }
        if (this.getEnsembleSize() != other.getEnsembleSize()) {
            return false;
        }
        if (this.getWriteQuorumSize() != other.getWriteQuorumSize()) {
            return false;
        }
        if (this.getAckQuorumSize() != other.getAckQuorumSize()) {
            return false;
        }
        LedgerMetadata.State this$state = this.getState();
        LedgerMetadata.State other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getLastEntryId() != other.getLastEntryId()) {
            return false;
        }
        if (this.getCtime() != other.getCtime()) {
            return false;
        }
        if (this.storeCtime != other.storeCtime) {
            return false;
        }
        NavigableMap<Long, ImmutableList<BookieSocketAddress>> this$ensembles = this.ensembles;
        NavigableMap<Long, ImmutableList<BookieSocketAddress>> other$ensembles = other.ensembles;
        if (this$ensembles == null ? other$ensembles != null : !this$ensembles.equals(other$ensembles)) {
            return false;
        }
        ImmutableList<BookieSocketAddress> this$currentEnsemble = this.currentEnsemble;
        ImmutableList<BookieSocketAddress> other$currentEnsemble = other.currentEnsemble;
        if (this$currentEnsemble == null ? other$currentEnsemble != null : !this$currentEnsemble.equals(other$currentEnsemble)) {
            return false;
        }
        if (this.hasPassword != other.hasPassword) {
            return false;
        }
        DigestType this$digestType = this.getDigestType();
        DigestType other$digestType = other.getDigestType();
        if (this$digestType == null ? other$digestType != null : !((Object)((Object)this$digestType)).equals((Object)other$digestType)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        Map<String, byte[]> this$customMetadata = this.getCustomMetadata();
        Map<String, byte[]> other$customMetadata = other.getCustomMetadata();
        return !(this$customMetadata == null ? other$customMetadata != null : !((Object)this$customMetadata).equals(other$customMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LedgerMetadataImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMetadataFormatVersion();
        result = result * 59 + this.getEnsembleSize();
        result = result * 59 + this.getWriteQuorumSize();
        result = result * 59 + this.getAckQuorumSize();
        LedgerMetadata.State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        long $lastEntryId = this.getLastEntryId();
        result = result * 59 + (int)($lastEntryId >>> 32 ^ $lastEntryId);
        long $ctime = this.getCtime();
        result = result * 59 + (int)($ctime >>> 32 ^ $ctime);
        result = result * 59 + (this.storeCtime ? 79 : 97);
        NavigableMap<Long, ImmutableList<BookieSocketAddress>> $ensembles = this.ensembles;
        result = result * 59 + ($ensembles == null ? 43 : $ensembles.hashCode());
        ImmutableList<BookieSocketAddress> $currentEnsemble = this.currentEnsemble;
        result = result * 59 + ($currentEnsemble == null ? 43 : $currentEnsemble.hashCode());
        result = result * 59 + (this.hasPassword ? 79 : 97);
        DigestType $digestType = this.getDigestType();
        result = result * 59 + ($digestType == null ? 43 : ((Object)((Object)$digestType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        Map<String, byte[]> $customMetadata = this.getCustomMetadata();
        result = result * 59 + ($customMetadata == null ? 43 : ((Object)$customMetadata).hashCode());
        return result;
    }
}

