/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.RateLimiter;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.MetadataUpdateLoop;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLedgerOp {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLedgerOp.class);
    private final LedgerManager lm;
    private final BookKeeperAdmin admin;

    public UpdateLedgerOp(BookKeeper bkc, BookKeeperAdmin admin) {
        this.lm = bkc.getLedgerManager();
        this.admin = admin;
    }

    public void updateBookieIdInLedgers(BookieSocketAddress oldBookieId, BookieSocketAddress newBookieId, int rate, int limit, BookieShell.UpdateLedgerNotifier progressable) throws IOException, InterruptedException {
        AtomicInteger issuedLedgerCnt = new AtomicInteger();
        AtomicInteger updatedLedgerCnt = new AtomicInteger();
        CompletableFuture finalPromise = new CompletableFuture();
        Set outstanding = Collections.newSetFromMap(new ConcurrentHashMap());
        RateLimiter throttler = RateLimiter.create((double)rate);
        Iterator<Long> ledgerItr = this.admin.listLedgers().iterator();
        while (ledgerItr.hasNext() && !finalPromise.isDone() && (limit == Integer.MIN_VALUE || issuedLedgerCnt.get() < limit)) {
            throttler.acquire();
            long ledgerId = ledgerItr.next();
            issuedLedgerCnt.incrementAndGet();
            CompletionStage writePromise = this.lm.readLedgerMetadata(ledgerId).thenCompose(readMetadata -> {
                AtomicReference<Versioned> ref = new AtomicReference<Versioned>((Versioned)readMetadata);
                return new MetadataUpdateLoop(this.lm, ledgerId, ref::get, metadata -> metadata.getAllEnsembles().values().stream().flatMap(Collection::stream).filter(b -> b.equals(oldBookieId)).count() > 0L, metadata -> UpdateLedgerOp.replaceBookieInEnsembles(metadata, oldBookieId, newBookieId), ref::compareAndSet).run();
            });
            outstanding.add(writePromise);
            ((CompletableFuture)writePromise).whenComplete((arg_0, arg_1) -> UpdateLedgerOp.lambda$updateBookieIdInLedgers$4(ledgerId, oldBookieId, newBookieId, finalPromise, updatedLedgerCnt, progressable, issuedLedgerCnt, outstanding, (CompletableFuture)writePromise, arg_0, arg_1));
        }
        CompletableFuture.allOf((CompletableFuture[])outstanding.stream().toArray(CompletableFuture[]::new)).whenComplete((res, ex) -> {
            if (ex != null) {
                finalPromise.completeExceptionally((Throwable)ex);
            } else {
                finalPromise.complete(null);
            }
        });
        try {
            finalPromise.get();
            LOG.info("Total number of ledgers issued={} updated={}", (Object)issuedLedgerCnt.get(), (Object)updatedLedgerCnt.get());
        }
        catch (ExecutionException e) {
            String error = String.format("Error waiting for ledger metadata updates to complete (replacing %s with %s)", oldBookieId, newBookieId);
            LOG.info(error, (Throwable)e);
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(error, e);
        }
    }

    private static LedgerMetadata replaceBookieInEnsembles(LedgerMetadata metadata, BookieSocketAddress oldBookieId, BookieSocketAddress newBookieId) {
        LedgerMetadataBuilder builder = LedgerMetadataBuilder.from(metadata);
        for (Map.Entry e : metadata.getAllEnsembles().entrySet()) {
            List<BookieSocketAddress> newEnsemble = ((List)e.getValue()).stream().map(b -> b.equals(oldBookieId) ? newBookieId : b).collect(Collectors.toList());
            builder.replaceEnsembleEntry((Long)e.getKey(), newEnsemble);
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$updateBookieIdInLedgers$4(long ledgerId, BookieSocketAddress oldBookieId, BookieSocketAddress newBookieId, CompletableFuture finalPromise, AtomicInteger updatedLedgerCnt, BookieShell.UpdateLedgerNotifier progressable, AtomicInteger issuedLedgerCnt, Set outstanding, CompletableFuture writePromise, Versioned metadata, Throwable ex) {
        if (ex != null && !(ex instanceof BKException.BKNoSuchLedgerExistsException)) {
            String error = String.format("Failed to update ledger metadata %s, replacing %s with %s", ledgerId, oldBookieId, newBookieId);
            LOG.error(error, ex);
            finalPromise.completeExceptionally(new IOException(error, ex));
        } else {
            LOG.info("Updated ledger {} metadata, replacing {} with {}", new Object[]{ledgerId, oldBookieId, newBookieId});
            updatedLedgerCnt.incrementAndGet();
            progressable.progress(updatedLedgerCnt.get(), issuedLedgerCnt.get());
        }
        outstanding.remove(writePromise);
    }
}

