/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.net;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.net.InetAddresses;
import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Optional;

public class BookieSocketAddress {
    private final String hostname;
    private final int port;
    private final Optional<InetSocketAddress> socketAddress;

    public BookieSocketAddress(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
        this.socketAddress = InetAddresses.isInetAddress((String)hostname) ? Optional.of(new InetSocketAddress(hostname, port)) : Optional.empty();
    }

    public BookieSocketAddress(String addr) throws UnknownHostException {
        String[] parts = addr.split(":");
        if (parts.length < 2) {
            throw new UnknownHostException(addr);
        }
        this.hostname = parts[0];
        try {
            this.port = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException nfe) {
            throw new UnknownHostException(addr);
        }
        this.socketAddress = InetAddresses.isInetAddress((String)this.hostname) ? Optional.of(new InetSocketAddress(this.hostname, this.port)) : Optional.empty();
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    @JsonIgnore
    public InetSocketAddress getSocketAddress() {
        return this.socketAddress.orElseGet(() -> new InetSocketAddress(this.hostname, this.port));
    }

    @JsonIgnore
    public LocalAddress getLocalAddress() {
        return new LocalAddress("" + this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.hostname).append(":").append(this.port);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BookieSocketAddress)) {
            return false;
        }
        BookieSocketAddress that = (BookieSocketAddress)obj;
        return this.hostname.equals(that.hostname) && this.port == that.port;
    }

    public int hashCode() {
        return this.hostname.hashCode() + 13 * this.port;
    }
}

