/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.proto.PerChannelBookieClientFactory;
import org.apache.bookkeeper.proto.PerChannelBookieClientPool;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.tls.SecurityProviderFactoryFactory;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultPerChannelBookieClientPool
implements PerChannelBookieClientPool,
BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> {
    static final Logger LOG = LoggerFactory.getLogger(DefaultPerChannelBookieClientPool.class);
    final PerChannelBookieClientFactory factory;
    final BookieSocketAddress address;
    final PerChannelBookieClient[] clients;
    final ClientConfiguration conf;
    SecurityHandlerFactory shFactory;
    final AtomicInteger counter = new AtomicInteger(0);
    final AtomicLong errorCounter = new AtomicLong(0L);

    DefaultPerChannelBookieClientPool(ClientConfiguration conf, PerChannelBookieClientFactory factory, BookieSocketAddress address, int coreSize) throws SecurityException {
        Preconditions.checkArgument((coreSize > 0 ? 1 : 0) != 0);
        this.factory = factory;
        this.address = address;
        this.conf = conf;
        this.shFactory = SecurityProviderFactoryFactory.getSecurityProviderFactory(conf.getTLSProviderFactoryClass());
        this.clients = new PerChannelBookieClient[coreSize];
        for (int i = 0; i < coreSize; ++i) {
            this.clients[i] = factory.create(address, this, this.shFactory);
        }
    }

    @Override
    public void operationComplete(int rc, PerChannelBookieClient pcbc) {
    }

    @Override
    public void intialize() {
        for (PerChannelBookieClient pcbc : this.clients) {
            pcbc.connectIfNeededAndDoOp(this);
        }
    }

    private PerChannelBookieClient getClient(long key) {
        if (1 == this.clients.length) {
            return this.clients[0];
        }
        int idx = MathUtils.signSafeMod((long)key, (int)this.clients.length);
        return this.clients[idx];
    }

    @Override
    public void obtain(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> callback, long key) {
        this.getClient(key).connectIfNeededAndDoOp(callback);
    }

    @Override
    public boolean isWritable(long key) {
        return this.getClient(key).isWritable();
    }

    @Override
    public void checkTimeoutOnPendingOperations() {
        for (int i = 0; i < this.clients.length; ++i) {
            this.clients[i].checkTimeoutOnPendingOperations();
        }
    }

    @Override
    public void recordError() {
        this.errorCounter.incrementAndGet();
    }

    @Override
    public void disconnect(boolean wait) {
        for (PerChannelBookieClient pcbc : this.clients) {
            pcbc.disconnect(wait);
        }
    }

    @Override
    public void close(boolean wait) {
        for (PerChannelBookieClient pcbc : this.clients) {
            pcbc.close(wait);
        }
    }

    @Override
    public long getNumPendingCompletionRequests() {
        long numPending = 0L;
        for (PerChannelBookieClient pcbc : this.clients) {
            numPending += pcbc.getNumPendingCompletionRequests();
        }
        return numPending;
    }
}

