/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.common.util.JsonUtil;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListDiskFilesService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListDiskFilesService.class);
    protected ServerConfiguration conf;

    public ListDiskFilesService(ServerConfiguration conf) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod()) {
            StringBuffer files;
            HashMap output = Maps.newHashMap();
            boolean journal = params != null && params.containsKey("file_type") && ((String)params.get("file_type")).equals("journal");
            boolean entrylog = params != null && params.containsKey("file_type") && ((String)params.get("file_type")).equals("entrylog");
            boolean index = params != null && params.containsKey("file_type") && ((String)params.get("file_type")).equals("index");
            boolean all = false;
            if (!(journal || entrylog || index || all)) {
                all = true;
            }
            if (all || journal) {
                File[] journalDirs = this.conf.getJournalDirs();
                List<File> journalFiles = BookieShell.listFilesAndSort(journalDirs, "txn");
                files = new StringBuffer();
                for (File journalFile : journalFiles) {
                    files.append(journalFile.getName() + "\t");
                }
                output.put("journal files", files.toString());
            }
            if (all || entrylog) {
                File[] ledgerDirs = this.conf.getLedgerDirs();
                List<File> ledgerFiles = BookieShell.listFilesAndSort(ledgerDirs, "log");
                files = new StringBuffer();
                for (File ledgerFile : ledgerFiles) {
                    files.append(ledgerFile.getName() + "\t");
                }
                output.put("entrylog files", files.toString());
            }
            if (all || index) {
                File[] indexDirs = this.conf.getIndexDirs() == null ? this.conf.getLedgerDirs() : this.conf.getIndexDirs();
                List<File> indexFiles = BookieShell.listFilesAndSort(indexDirs, "idx");
                files = new StringBuffer();
                for (File indexFile : indexFiles) {
                    files.append(indexFile.getName() + "\t");
                }
                output.put("index files", files.toString());
            }
            String jsonResponse = JsonUtil.toJson((Object)output);
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

