/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.bookie;

import java.io.File;
import org.apache.bookkeeper.bookie.Journal;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.tools.cli.helpers.BookieCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.util.DiskChecker;

public class LastMarkCommand
extends BookieCommand<CliFlags> {
    private static final String NAME = "lastmark";
    private static final String DESC = "Print last log marker";

    public LastMarkCommand() {
        super(CliSpec.newBuilder().withName(NAME).withFlags(new CliFlags()).withDescription(DESC).build());
    }

    @Override
    public boolean apply(ServerConfiguration conf, CliFlags flags) {
        LedgerDirsManager dirsManager = new LedgerDirsManager(conf, conf.getJournalDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        File[] journalDirs = conf.getJournalDirs();
        for (int idx = 0; idx < journalDirs.length; ++idx) {
            Journal journal = new Journal(idx, journalDirs[idx], conf, dirsManager);
            LogMark lastLogMark = journal.getLastLogMark().getCurMark();
            System.out.println("LastLogMark : Journal Id - " + lastLogMark.getLogFileId() + "(" + Long.toHexString(lastLogMark.getLogFileId()) + ".txn), Pos - " + lastLogMark.getLogFileOffset());
        }
        return true;
    }
}

