/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieStatus {
    private static final Logger LOG = LoggerFactory.getLogger(BookieStatus.class);
    static final int CURRENT_STATUS_LAYOUT_VERSION = 1;
    private static final long INVALID_UPDATE_TIME = -1L;
    private int layoutVersion = 1;
    private long lastUpdateTime = -1L;
    private volatile BookieMode bookieMode = BookieMode.READ_WRITE;

    BookieStatus() {
    }

    private BookieMode getBookieMode() {
        return this.bookieMode;
    }

    public boolean isInWritable() {
        return this.bookieMode.equals((Object)BookieMode.READ_WRITE);
    }

    synchronized boolean setToWritableMode() {
        if (!this.bookieMode.equals((Object)BookieMode.READ_WRITE)) {
            this.bookieMode = BookieMode.READ_WRITE;
            this.lastUpdateTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    boolean isInReadOnlyMode() {
        return this.bookieMode.equals((Object)BookieMode.READ_ONLY);
    }

    synchronized boolean setToReadOnlyMode() {
        if (!this.bookieMode.equals((Object)BookieMode.READ_ONLY)) {
            this.bookieMode = BookieMode.READ_ONLY;
            this.lastUpdateTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    synchronized void writeToDirectories(List<File> directories) {
        boolean success = false;
        for (File dir : directories) {
            try {
                File statusFile = new File(dir, "BOOKIE_STATUS");
                BookieStatus.writeToFile(statusFile, this.toString());
                success = true;
            }
            catch (IOException e) {
                LOG.warn("IOException while trying to write bookie status to directory {}. This is fine if not all directories are failed.", (Object)dir);
            }
        }
        if (success) {
            LOG.info("Successfully persist bookie status {}", (Object)this.bookieMode);
        } else {
            LOG.warn("Failed to persist bookie status {}", (Object)this.bookieMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(File file, String body) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, Charsets.UTF_8));
            bw.write(body);
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readFromDirectories(List<File> directories) {
        boolean success = false;
        for (File dir : directories) {
            File statusFile = new File(dir, "BOOKIE_STATUS");
            try {
                BookieStatus status = this.readFromFile(statusFile);
                if (null == status) continue;
                BookieStatus bookieStatus = status;
                synchronized (bookieStatus) {
                    if (status.lastUpdateTime > this.lastUpdateTime) {
                        this.lastUpdateTime = status.lastUpdateTime;
                        this.layoutVersion = status.layoutVersion;
                        this.bookieMode = status.bookieMode;
                        success = true;
                    }
                }
            }
            catch (IOException e) {
                LOG.warn("IOException while trying to read bookie status from directory {}. This is fine if not all directories failed.", (Object)dir);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("IllegalArgumentException while trying to read bookie status from directory {}. This is fine if not all directories failed.", (Object)dir);
            }
        }
        if (success) {
            LOG.info("Successfully retrieve bookie status {} from disks.", (Object)this.getBookieMode());
        } else {
            LOG.warn("Failed to retrieve bookie status from disks. Fall back to current or default bookie status: {}", (Object)this.getBookieMode());
        }
    }

    private BookieStatus readFromFile(File file) throws IOException, IllegalArgumentException {
        if (!file.exists()) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));){
            BookieStatus bookieStatus = this.parse(reader);
            return bookieStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BookieStatus parse(BufferedReader reader) throws IOException, IllegalArgumentException {
        BookieStatus status = new BookieStatus();
        String line = reader.readLine();
        if (line == null || line.trim().isEmpty()) {
            LOG.debug("Empty line when parsing bookie status");
            return null;
        }
        String[] parts = line.split(",");
        if (parts.length == 0) {
            LOG.debug("Error in parsing bookie status: {}", (Object)line);
            return null;
        }
        BookieStatus bookieStatus = status;
        synchronized (bookieStatus) {
            status.layoutVersion = Integer.parseInt(parts[0].trim());
            if (status.layoutVersion == 1 && parts.length == 3) {
                status.bookieMode = BookieMode.valueOf(parts[1]);
                status.lastUpdateTime = Long.parseLong(parts[2].trim());
                return status;
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(1);
        builder.append(",");
        builder.append((Object)this.getBookieMode());
        builder.append(",");
        builder.append(System.currentTimeMillis());
        builder.append("\n");
        return builder.toString();
    }

    static enum BookieMode {
        READ_ONLY,
        READ_WRITE;

    }
}

