/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.ShortReadException;
import org.apache.bookkeeper.common.util.Watchable;
import org.apache.bookkeeper.common.util.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileInfo
extends Watchable<LastAddConfirmedUpdateNotification> {
    private static final Logger LOG = LoggerFactory.getLogger(FileInfo.class);
    static final int NO_MASTER_KEY = -1;
    static final int STATE_FENCED_BIT = 1;
    private FileChannel fc;
    private File lf;
    private ByteBuffer explicitLac = null;
    byte[] masterKey;
    public static final int SIGNATURE = ByteBuffer.wrap("BKLE".getBytes(Charsets.UTF_8)).getInt();
    static final int V0 = 0;
    static final int V1 = 1;
    public static final int CURRENT_HEADER_VERSION = 1;
    static final long START_OF_DATA = 1024L;
    private long size;
    private boolean isClosed;
    private long sizeSinceLastwrite;
    private int stateBits;
    private boolean needFlushHeader = false;
    private Long lac = null;
    protected String mode;
    int headerVersion;
    private boolean deleted;

    public FileInfo(File lf, byte[] masterKey, int fileInfoVersionToWrite) throws IOException {
        super(LastAddConfirmedUpdateNotification.WATCHER_RECYCLER);
        this.lf = lf;
        this.masterKey = masterKey;
        this.mode = "rw";
        this.headerVersion = fileInfoVersionToWrite;
        this.deleted = false;
    }

    synchronized Long getLastAddConfirmed() {
        return this.lac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long setLastAddConfirmed(long lac) {
        long lacToReturn;
        boolean changed = false;
        FileInfo fileInfo = this;
        synchronized (fileInfo) {
            if (null == this.lac || this.lac < lac) {
                this.lac = lac;
                changed = true;
            }
            lacToReturn = this.lac;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Updating LAC {} , {}", (Object)lacToReturn, (Object)lac);
        }
        if (changed) {
            this.notifyWatchers(LastAddConfirmedUpdateNotification.FUNC, lacToReturn);
        }
        return lacToReturn;
    }

    synchronized boolean waitForLastAddConfirmedUpdate(long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) {
        if (null != this.lac && this.lac > previousLAC || this.isClosed || (this.stateBits & 1) == 1) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Wait For LAC {} , {}", (Object)this.lac, (Object)previousLAC);
            }
            return false;
        }
        this.addWatcher(watcher);
        return true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized File getLf() {
        return this.lf;
    }

    public long getSizeSinceLastwrite() {
        return this.sizeSinceLastwrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf getExplicitLac() {
        ByteBuf retLac = null;
        FileInfo fileInfo = this;
        synchronized (fileInfo) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("fileInfo:GetLac: {}", (Object)this.explicitLac);
            }
            if (this.explicitLac != null) {
                retLac = Unpooled.buffer((int)this.explicitLac.capacity());
                this.explicitLac.rewind();
                retLac.writeBytes(this.explicitLac);
                this.explicitLac.rewind();
                return retLac;
            }
        }
        return retLac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExplicitLac(ByteBuf lac) {
        long explicitLacValue;
        FileInfo fileInfo = this;
        synchronized (fileInfo) {
            if (this.explicitLac == null) {
                this.explicitLac = ByteBuffer.allocate(lac.capacity());
            }
            lac.readBytes(this.explicitLac);
            this.explicitLac.rewind();
            this.explicitLac.getLong();
            explicitLacValue = this.explicitLac.getLong();
            this.explicitLac.rewind();
            if (LOG.isDebugEnabled()) {
                LOG.debug("fileInfo:SetLac: {}", (Object)this.explicitLac);
            }
            this.needFlushHeader = true;
        }
        this.setLastAddConfirmed(explicitLacValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void readHeader() throws IOException {
        if (!this.lf.exists()) throw new IOException("Ledger index file " + this.lf + " does not exist");
        if (this.fc != null) {
            return;
        }
        this.fc = new RandomAccessFile(this.lf, this.mode).getChannel();
        this.sizeSinceLastwrite = this.size = this.fc.size();
        ByteBuffer bb = ByteBuffer.allocate((int)Math.min(this.size, 1024L));
        while (bb.hasRemaining()) {
            this.fc.read(bb);
        }
        bb.flip();
        if (bb.getInt() != SIGNATURE) {
            throw new IOException("Missing ledger signature while reading header for " + this.lf);
        }
        int version = bb.getInt();
        if (version > 1) {
            throw new IOException("Incompatible ledger version " + version + " while reading header for " + this.lf);
        }
        this.headerVersion = version;
        int length = bb.getInt();
        if (length < 0) {
            throw new IOException("Length " + length + " is invalid while reading header for " + this.lf);
        }
        if (length > bb.remaining()) {
            throw new BufferUnderflowException();
        }
        this.masterKey = new byte[length];
        bb.get(this.masterKey);
        this.stateBits = bb.getInt();
        if (this.headerVersion >= 1) {
            int explicitLacBufLength = bb.getInt();
            if (explicitLacBufLength == 0) {
                this.explicitLac = null;
            } else {
                if (explicitLacBufLength < 16) throw new IOException("ExplicitLacBufLength " + explicitLacBufLength + " is invalid while reading header for " + this.lf);
                if (this.explicitLac == null) {
                    this.explicitLac = ByteBuffer.allocate(explicitLacBufLength);
                }
                byte[] explicitLacBufArray = new byte[explicitLacBufLength];
                bb.get(explicitLacBufArray);
                this.explicitLac.put(explicitLacBufArray);
                this.explicitLac.rewind();
            }
        }
        this.needFlushHeader = false;
    }

    public synchronized boolean isDeleted() {
        return this.deleted;
    }

    @VisibleForTesting
    void checkOpen(boolean create) throws IOException {
        this.checkOpen(create, false);
    }

    private synchronized void checkOpen(boolean create, boolean openBeforeClose) throws IOException {
        if (this.deleted) {
            throw new FileInfoDeletedException();
        }
        if (this.fc != null) {
            return;
        }
        boolean exists = this.lf.exists();
        if (this.masterKey == null && !exists) {
            throw new IOException(this.lf + " not found");
        }
        if (!exists) {
            if (create) {
                FileInfo.checkParents(this.lf);
                this.fc = new RandomAccessFile(this.lf, this.mode).getChannel();
                this.size = this.fc.size();
                if (this.size == 0L) {
                    this.writeHeader();
                }
            }
        } else {
            if (openBeforeClose) {
                return;
            }
            try {
                this.readHeader();
            }
            catch (BufferUnderflowException buf) {
                LOG.warn("Exception when reading header of {} : {}", (Object)this.lf, (Object)buf);
                if (null != this.masterKey) {
                    LOG.warn("Attempting to write header of {} again.", (Object)this.lf);
                    this.writeHeader();
                }
                throw new IOException("Error reading header " + this.lf);
            }
        }
    }

    private void writeHeader() throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(1024);
        bb.putInt(SIGNATURE);
        bb.putInt(this.headerVersion);
        bb.putInt(this.masterKey.length);
        bb.put(this.masterKey);
        bb.putInt(this.stateBits);
        if (this.headerVersion >= 1) {
            if (this.explicitLac != null) {
                this.explicitLac.rewind();
                bb.putInt(this.explicitLac.capacity());
                bb.put(this.explicitLac);
                this.explicitLac.rewind();
            } else {
                bb.putInt(0);
            }
        }
        bb.rewind();
        this.fc.position(0L);
        this.fc.write(bb);
    }

    public synchronized boolean isFenced() throws IOException {
        this.checkOpen(false);
        return (this.stateBits & 1) == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFenced() throws IOException {
        boolean returnVal = false;
        boolean changed = false;
        FileInfo fileInfo = this;
        synchronized (fileInfo) {
            this.checkOpen(false);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to set fenced state in file info {} : state bits {}.", (Object)this.lf, (Object)this.stateBits);
            }
            if ((this.stateBits & 1) != 1) {
                this.stateBits |= 1;
                this.needFlushHeader = true;
                FileInfo fileInfo2 = this;
                synchronized (fileInfo2) {
                    changed = true;
                }
                returnVal = true;
            }
        }
        if (changed) {
            this.notifyWatchers(LastAddConfirmedUpdateNotification.FUNC, Long.MAX_VALUE);
        }
        return returnVal;
    }

    public synchronized void flushHeader() throws IOException {
        if (this.needFlushHeader) {
            this.checkOpen(true);
            this.writeHeader();
            this.needFlushHeader = false;
        }
    }

    public synchronized long size() throws IOException {
        this.checkOpen(false);
        long rc = this.size - 1024L;
        if (rc < 0L) {
            rc = 0L;
        }
        return rc;
    }

    public int read(ByteBuffer bb, long position, boolean bestEffort) throws IOException {
        return this.readAbsolute(bb, position + 1024L, bestEffort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readAbsolute(ByteBuffer bb, long start, boolean bestEffort) throws IOException {
        this.checkOpen(false);
        FileInfo fileInfo = this;
        synchronized (fileInfo) {
            if (this.fc == null) {
                return 0;
            }
        }
        int total = 0;
        int rc = 0;
        while (bb.remaining() > 0) {
            FileInfo fileInfo2 = this;
            synchronized (fileInfo2) {
                rc = this.fc.read(bb, start);
            }
            if (rc <= 0) {
                if (bestEffort) {
                    return total;
                }
                throw new ShortReadException("Short read at " + this.getLf().getPath() + "@" + start);
            }
            total += rc;
            start += (long)rc;
        }
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean force) throws IOException {
        boolean changed = false;
        FileInfo fileInfo = this;
        synchronized (fileInfo) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.checkOpen(force, true);
            if (force) {
                this.flushHeader();
            }
            changed = true;
            if (this.fc != null) {
                this.fc.close();
            }
            this.fc = null;
        }
        if (changed) {
            this.notifyWatchers(LastAddConfirmedUpdateNotification.FUNC, Long.MAX_VALUE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long write(ByteBuffer[] buffs, long position) throws IOException {
        this.checkOpen(true);
        long total = 0L;
        try {
            this.fc.position(position + 1024L);
            while (buffs[buffs.length - 1].remaining() > 0) {
                long rc = this.fc.write(buffs);
                if (rc <= 0L) {
                    throw new IOException("Short write");
                }
                total += rc;
            }
        }
        finally {
            this.fc.force(true);
            long newsize = position + 1024L + total;
            if (newsize > this.size) {
                this.size = newsize;
            }
        }
        this.sizeSinceLastwrite = this.fc.size();
        return total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToNewLocation(File newFile, long size) throws IOException {
        File rlocFile;
        this.checkOpen(false);
        if (null == this.fc || this.isSameFile(newFile)) {
            return;
        }
        if (size > this.fc.size()) {
            size = this.fc.size();
        }
        if (!(rlocFile = new File(newFile.getParentFile(), newFile.getName() + ".rloc")).exists()) {
            FileInfo.checkParents(rlocFile);
            if (!rlocFile.createNewFile()) {
                throw new IOException("Creating new cache index file " + rlocFile + " failed ");
            }
        }
        FileChannel newFc = new RandomAccessFile(rlocFile, "rw").getChannel();
        try {
            long written;
            long count;
            for (written = 0L; written < size; written += count) {
                count = this.fc.transferTo(written, size, newFc);
                if (count > 0L) continue;
                throw new IOException("Copying to new location " + rlocFile + " failed");
            }
            if (written <= 0L && size > 0L) {
                throw new IOException("Copying to new location " + rlocFile + " failed");
            }
        }
        finally {
            newFc.force(true);
            newFc.close();
        }
        this.fc.close();
        if (!this.delete()) {
            LOG.error("Failed to delete the previous index file " + this.lf);
            throw new IOException("Failed to delete the previous index file " + this.lf);
        }
        if (!rlocFile.renameTo(newFile)) {
            LOG.error("Failed to rename " + rlocFile + " to " + newFile);
            throw new IOException("Failed to rename " + rlocFile + " to " + newFile);
        }
        this.fc = new RandomAccessFile(newFile, this.mode).getChannel();
        this.lf = newFile;
    }

    public synchronized byte[] getMasterKey() throws IOException {
        this.checkOpen(false);
        return this.masterKey;
    }

    public synchronized boolean delete() {
        this.deleted = true;
        return this.lf.delete();
    }

    private static void checkParents(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent.exists()) {
            return;
        }
        if (!parent.mkdirs()) {
            throw new IOException("Counldn't mkdirs for " + parent);
        }
    }

    public synchronized boolean isSameFile(File f) {
        return this.lf.equals(f);
    }

    public static class FileInfoDeletedException
    extends IOException {
        FileInfoDeletedException() {
            super("FileInfo already deleted");
        }
    }
}

