/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.IndexInMemPageMgr;
import org.apache.bookkeeper.bookie.IndexPersistenceMgr;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerCache;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.SnapshotMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerCacheImpl
implements LedgerCache {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerCacheImpl.class);
    private final IndexInMemPageMgr indexPageManager;
    private final IndexPersistenceMgr indexPersistenceManager;
    private final int pageSize;
    private final int entriesPerPage;

    public LedgerCacheImpl(ServerConfiguration conf, SnapshotMap<Long, Boolean> activeLedgers, LedgerDirsManager ledgerDirsManager) throws IOException {
        this(conf, activeLedgers, ledgerDirsManager, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public LedgerCacheImpl(ServerConfiguration conf, SnapshotMap<Long, Boolean> activeLedgers, LedgerDirsManager ledgerDirsManager, StatsLogger statsLogger) throws IOException {
        this.pageSize = conf.getPageSize();
        this.entriesPerPage = this.pageSize / 8;
        this.indexPersistenceManager = new IndexPersistenceMgr(this.pageSize, this.entriesPerPage, conf, activeLedgers, ledgerDirsManager, statsLogger);
        this.indexPageManager = new IndexInMemPageMgr(this.pageSize, this.entriesPerPage, conf, this.indexPersistenceManager, statsLogger);
    }

    IndexPersistenceMgr getIndexPersistenceManager() {
        return this.indexPersistenceManager;
    }

    IndexInMemPageMgr getIndexPageManager() {
        return this.indexPageManager;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public Long getLastAddConfirmed(long ledgerId) throws IOException {
        return this.indexPersistenceManager.getLastAddConfirmed(ledgerId);
    }

    @Override
    public long updateLastAddConfirmed(long ledgerId, long lac) throws IOException {
        return this.indexPersistenceManager.updateLastAddConfirmed(ledgerId, lac);
    }

    @Override
    public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
        return this.indexPersistenceManager.waitForLastAddConfirmedUpdate(ledgerId, previousLAC, watcher);
    }

    @Override
    public void putEntryOffset(long ledger, long entry, long offset) throws IOException {
        this.indexPageManager.putEntryOffset(ledger, entry, offset);
    }

    @Override
    public long getEntryOffset(long ledger, long entry) throws IOException {
        return this.indexPageManager.getEntryOffset(ledger, entry);
    }

    @Override
    public void flushLedger(boolean doAll) throws IOException {
        this.indexPageManager.flushOneOrMoreLedgers(doAll);
    }

    @Override
    public long getLastEntry(long ledgerId) throws IOException {
        long lastEntryInMem = this.indexPageManager.getLastEntryInMem(ledgerId);
        long lastEntry = this.indexPersistenceManager.getPersistEntryBeyondInMem(ledgerId, lastEntryInMem);
        return lastEntry;
    }

    @Override
    public void deleteLedger(long ledgerId) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Deleting ledgerId: {}", (Object)ledgerId);
        }
        this.indexPageManager.removePagesForLedger(ledgerId);
        this.indexPersistenceManager.removeLedger(ledgerId);
    }

    @Override
    public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
        return this.indexPersistenceManager.readMasterKey(ledgerId);
    }

    @Override
    public boolean setFenced(long ledgerId) throws IOException {
        return this.indexPersistenceManager.setFenced(ledgerId);
    }

    @Override
    public boolean isFenced(long ledgerId) throws IOException {
        return this.indexPersistenceManager.isFenced(ledgerId);
    }

    @Override
    public void setExplicitLac(long ledgerId, ByteBuf lac) throws IOException {
        this.indexPersistenceManager.setExplicitLac(ledgerId, lac);
    }

    @Override
    public ByteBuf getExplicitLac(long ledgerId) {
        return this.indexPersistenceManager.getExplicitLac(ledgerId);
    }

    @Override
    public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        this.indexPersistenceManager.setMasterKey(ledgerId, masterKey);
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        return this.indexPersistenceManager.ledgerExists(ledgerId);
    }

    @Override
    public void close() throws IOException {
        this.indexPersistenceManager.close();
    }

    @Override
    public LedgerCache.PageEntriesIterable listEntries(long ledgerId) throws IOException {
        return this.indexPageManager.listEntries(ledgerId);
    }

    @Override
    public LedgerCache.LedgerIndexMetadata readLedgerIndexMetadata(long ledgerId) throws IOException {
        return this.indexPersistenceManager.readLedgerIndexMetadata(ledgerId);
    }
}

