/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.HashedWheelTimer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.stats.StatsLogger;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface EnsemblePlacementPolicy {
    public EnsemblePlacementPolicy initialize(ClientConfiguration var1, Optional<DNSToSwitchMapping> var2, HashedWheelTimer var3, FeatureProvider var4, StatsLogger var5);

    public void uninitalize();

    public Set<BookieSocketAddress> onClusterChanged(Set<BookieSocketAddress> var1, Set<BookieSocketAddress> var2);

    public PlacementResult<List<BookieSocketAddress>> newEnsemble(int var1, int var2, int var3, Map<String, byte[]> var4, Set<BookieSocketAddress> var5) throws BKException.BKNotEnoughBookiesException;

    public PlacementResult<BookieSocketAddress> replaceBookie(int var1, int var2, int var3, Map<String, byte[]> var4, List<BookieSocketAddress> var5, BookieSocketAddress var6, Set<BookieSocketAddress> var7) throws BKException.BKNotEnoughBookiesException;

    public void registerSlowBookie(BookieSocketAddress var1, long var2);

    public DistributionSchedule.WriteSet reorderReadSequence(List<BookieSocketAddress> var1, BookiesHealthInfo var2, DistributionSchedule.WriteSet var3);

    public DistributionSchedule.WriteSet reorderReadLACSequence(List<BookieSocketAddress> var1, BookiesHealthInfo var2, DistributionSchedule.WriteSet var3);

    default public void updateBookieInfo(Map<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap) {
    }

    default public int getStickyReadBookieIndex(LedgerMetadata metadata, Optional<Integer> currentStickyBookieIndex) {
        if (!currentStickyBookieIndex.isPresent()) {
            return ThreadLocalRandom.current().nextInt() % metadata.getEnsembleSize();
        }
        return (currentStickyBookieIndex.get() + 1) % metadata.getEnsembleSize();
    }

    default public boolean isEnsembleAdheringToPlacementPolicy(List<BookieSocketAddress> ensembleList, int writeQuorumSize, int ackQuorumSize) {
        return false;
    }

    public static final class PlacementResult<T> {
        private final T result;
        private final boolean adhering;

        public static <T> PlacementResult<T> of(T result, boolean adhering) {
            return new PlacementResult<T>(result, adhering);
        }

        private PlacementResult(T result, boolean adhering) {
            this.result = result;
            this.adhering = adhering;
        }

        public T getResult() {
            return this.result;
        }

        public boolean isStrictlyAdheringToPolicy() {
            return this.adhering;
        }
    }
}

