/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.HashSet;
import java.util.List;
import java.util.NavigableMap;
import java.util.Set;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;

public class LedgerFragment {
    private final Set<Integer> bookieIndexes;
    private final List<BookieSocketAddress> ensemble;
    private final long firstEntryId;
    private final long lastKnownEntryId;
    private final long ledgerId;
    private final DistributionSchedule schedule;
    private final boolean isLedgerClosed;

    LedgerFragment(LedgerHandle lh, long firstEntryId, long lastKnownEntryId, Set<Integer> bookieIndexes) {
        this.ledgerId = lh.getId();
        this.firstEntryId = firstEntryId;
        this.lastKnownEntryId = lastKnownEntryId;
        this.bookieIndexes = bookieIndexes;
        this.ensemble = lh.getLedgerMetadata().getEnsembleAt(firstEntryId);
        this.schedule = lh.getDistributionSchedule();
        NavigableMap<Long, ? extends List<BookieSocketAddress>> ensembles = lh.getLedgerMetadata().getAllEnsembles();
        this.isLedgerClosed = lh.getLedgerMetadata().isClosed() || !this.ensemble.equals(ensembles.get(ensembles.lastKey()));
    }

    LedgerFragment(LedgerFragment lf, Set<Integer> subset) {
        this.ledgerId = lf.ledgerId;
        this.firstEntryId = lf.firstEntryId;
        this.lastKnownEntryId = lf.lastKnownEntryId;
        this.bookieIndexes = subset;
        this.ensemble = lf.ensemble;
        this.schedule = lf.schedule;
        this.isLedgerClosed = lf.isLedgerClosed;
    }

    public LedgerFragment subset(Set<Integer> subset) {
        return new LedgerFragment(this, subset);
    }

    public boolean isClosed() {
        return this.isLedgerClosed;
    }

    long getLedgerId() {
        return this.ledgerId;
    }

    long getFirstEntryId() {
        return this.firstEntryId;
    }

    long getLastKnownEntryId() {
        return this.lastKnownEntryId;
    }

    public BookieSocketAddress getAddress(int bookieIndex) {
        return this.ensemble.get(bookieIndex);
    }

    public Set<BookieSocketAddress> getAddresses() {
        HashSet<BookieSocketAddress> addresses = new HashSet<BookieSocketAddress>();
        for (int bookieIndex : this.bookieIndexes) {
            addresses.add(this.ensemble.get(bookieIndex));
        }
        return addresses;
    }

    public Set<Integer> getBookiesIndexes() {
        return this.bookieIndexes;
    }

    public long getFirstStoredEntryId() {
        Long firstEntry = null;
        for (int bookieIndex : this.bookieIndexes) {
            Long firstStoredEntryForBookie = this.getFirstStoredEntryId(bookieIndex);
            if (null == firstEntry) {
                firstEntry = firstStoredEntryForBookie;
                continue;
            }
            if (null == firstStoredEntryForBookie) continue;
            firstEntry = Math.min(firstEntry, firstStoredEntryForBookie);
        }
        return null == firstEntry ? -1L : firstEntry;
    }

    public Long getFirstStoredEntryId(int bookieIndex) {
        long firstEntry = this.firstEntryId;
        for (int i = 0; i < this.ensemble.size() && firstEntry <= this.lastKnownEntryId; ++firstEntry, ++i) {
            if (!this.schedule.hasEntry(firstEntry, bookieIndex)) continue;
            return firstEntry;
        }
        return -1L;
    }

    public long getLastStoredEntryId() {
        Long lastEntry = null;
        for (int bookieIndex : this.bookieIndexes) {
            Long lastStoredEntryIdForBookie = this.getLastStoredEntryId(bookieIndex);
            if (null == lastEntry) {
                lastEntry = lastStoredEntryIdForBookie;
                continue;
            }
            if (null == lastStoredEntryIdForBookie) continue;
            lastEntry = Math.max(lastEntry, lastStoredEntryIdForBookie);
        }
        return null == lastEntry ? -1L : lastEntry;
    }

    public Long getLastStoredEntryId(int bookieIndex) {
        long lastEntry = this.lastKnownEntryId;
        for (int i = 0; i < this.ensemble.size() && lastEntry >= this.firstEntryId; --lastEntry, ++i) {
            if (!this.schedule.hasEntry(lastEntry, bookieIndex)) continue;
            return lastEntry;
        }
        return -1L;
    }

    public boolean isStoredEntryId(long entryId, int bookieIndex) {
        return this.schedule.hasEntry(entryId, bookieIndex);
    }

    public List<BookieSocketAddress> getEnsemble() {
        return this.ensemble;
    }

    public String toString() {
        return String.format("Fragment(LedgerID: %d, FirstEntryID: %d[%d], LastKnownEntryID: %d[%d], Host: %s, Closed: %s)", this.ledgerId, this.firstEntryId, this.getFirstStoredEntryId(), this.lastKnownEntryId, this.getLastStoredEntryId(), this.getAddresses(), this.isLedgerClosed);
    }
}

