/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import com.google.common.base.Charsets;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.common.util.ReflectionUtils;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;

public class ClientConfiguration
extends AbstractConfiguration<ClientConfiguration> {
    protected static final String THROTTLE = "throttle";
    protected static final String DIGEST_TYPE = "digestType";
    protected static final String ENABLE_DIGEST_TYPE_AUTODETECTION = "enableDigestTypeAutodetection";
    protected static final String PASSWD = "passwd";
    @Deprecated
    protected static final String CLIENT_TLS_KEYSTORE_TYPE = "clientKeyStoreType";
    @Deprecated
    protected static final String CLIENT_TLS_KEYSTORE = "clientKeyStore";
    @Deprecated
    protected static final String CLIENT_TLS_KEYSTORE_PASSWORD_PATH = "clientKeyStorePasswordPath";
    @Deprecated
    protected static final String CLIENT_TLS_TRUSTSTORE_TYPE = "clientTrustStoreType";
    @Deprecated
    protected static final String CLIENT_TLS_TRUSTSTORE = "clientTrustStore";
    @Deprecated
    protected static final String CLIENT_TLS_TRUSTSTORE_PASSWORD_PATH = "clientTrustStorePasswordPath";
    protected static final String CLIENT_TCP_NODELAY = "clientTcpNoDelay";
    protected static final String CLIENT_SOCK_KEEPALIVE = "clientSockKeepalive";
    protected static final String CLIENT_SENDBUFFER_SIZE = "clientSendBufferSize";
    protected static final String CLIENT_RECEIVEBUFFER_SIZE = "clientReceiveBufferSize";
    protected static final String CLIENT_WRITEBUFFER_LOW_WATER_MARK = "clientWriteBufferLowWaterMark";
    protected static final String CLIENT_WRITEBUFFER_HIGH_WATER_MARK = "clientWriteBufferHighWaterMark";
    protected static final String CLIENT_CONNECT_TIMEOUT_MILLIS = "clientConnectTimeoutMillis";
    protected static final String NUM_CHANNELS_PER_BOOKIE = "numChannelsPerBookie";
    protected static final String USE_V2_WIRE_PROTOCOL = "useV2WireProtocol";
    protected static final String NETTY_USE_POOLED_BUFFERS = "nettyUsePooledBuffers";
    protected static final String READ_TIMEOUT = "readTimeout";
    protected static final String SPECULATIVE_READ_TIMEOUT = "speculativeReadTimeout";
    protected static final String FIRST_SPECULATIVE_READ_TIMEOUT = "firstSpeculativeReadTimeout";
    protected static final String MAX_SPECULATIVE_READ_TIMEOUT = "maxSpeculativeReadTimeout";
    protected static final String SPECULATIVE_READ_TIMEOUT_BACKOFF_MULTIPLIER = "speculativeReadTimeoutBackoffMultiplier";
    protected static final String FIRST_SPECULATIVE_READ_LAC_TIMEOUT = "firstSpeculativeReadLACTimeout";
    protected static final String MAX_SPECULATIVE_READ_LAC_TIMEOUT = "maxSpeculativeReadLACTimeout";
    protected static final String SPECULATIVE_READ_LAC_TIMEOUT_BACKOFF_MULTIPLIER = "speculativeReadLACTimeoutBackoffMultiplier";
    protected static final String ENABLE_PARALLEL_RECOVERY_READ = "enableParallelRecoveryRead";
    protected static final String RECOVERY_READ_BATCH_SIZE = "recoveryReadBatchSize";
    protected static final String REORDER_READ_SEQUENCE_ENABLED = "reorderReadSequenceEnabled";
    protected static final String STICKY_READS_ENABLED = "stickyReadSEnabled";
    protected static final String DELAY_ENSEMBLE_CHANGE = "delayEnsembleChange";
    protected static final String MAX_ALLOWED_ENSEMBLE_CHANGES = "maxNumEnsembleChanges";
    protected static final String ADD_ENTRY_TIMEOUT_SEC = "addEntryTimeoutSec";
    protected static final String ADD_ENTRY_QUORUM_TIMEOUT_SEC = "addEntryQuorumTimeoutSec";
    protected static final String READ_ENTRY_TIMEOUT_SEC = "readEntryTimeoutSec";
    protected static final String TIMEOUT_MONITOR_INTERVAL_SEC = "timeoutMonitorIntervalSec";
    protected static final String TIMEOUT_TASK_INTERVAL_MILLIS = "timeoutTaskIntervalMillis";
    protected static final String EXPLICIT_LAC_INTERVAL = "explicitLacInterval";
    protected static final String PCBC_TIMEOUT_TIMER_TICK_DURATION_MS = "pcbcTimeoutTimerTickDurationMs";
    protected static final String PCBC_TIMEOUT_TIMER_NUM_TICKS = "pcbcTimeoutTimerNumTicks";
    protected static final String TIMEOUT_TIMER_TICK_DURATION_MS = "timeoutTimerTickDurationMs";
    protected static final String TIMEOUT_TIMER_NUM_TICKS = "timeoutTimerNumTicks";
    protected static final String WAIT_TIMEOUT_ON_BACKPRESSURE = "waitTimeoutOnBackpressureMs";
    protected static final String BOOKIE_HEALTH_CHECK_ENABLED = "bookieHealthCheckEnabled";
    protected static final String BOOKIE_HEALTH_CHECK_INTERVAL_SECONDS = "bookieHealthCheckIntervalSeconds";
    protected static final String BOOKIE_ERROR_THRESHOLD_PER_INTERVAL = "bookieErrorThresholdPerInterval";
    protected static final String BOOKIE_QUARANTINE_TIME_SECONDS = "bookieQuarantineTimeSeconds";
    protected static final String DISK_WEIGHT_BASED_PLACEMENT_ENABLED = "diskWeightBasedPlacementEnabled";
    protected static final String GET_BOOKIE_INFO_INTERVAL_SECONDS = "getBookieInfoIntervalSeconds";
    protected static final String GET_BOOKIE_INFO_RETRY_INTERVAL_SECONDS = "getBookieInfoRetryIntervalSeconds";
    protected static final String BOOKIE_MAX_MULTIPLE_FOR_WEIGHTED_PLACEMENT = "bookieMaxMultipleForWeightBasedPlacement";
    protected static final String GET_BOOKIE_INFO_TIMEOUT_SECS = "getBookieInfoTimeoutSecs";
    protected static final String START_TLS_TIMEOUT_SECS = "startTLSTimeoutSecs";
    protected static final String NUM_WORKER_THREADS = "numWorkerThreads";
    protected static final String NUM_IO_THREADS = "numIOThreads";
    protected static final String ENSEMBLE_PLACEMENT_POLICY = "ensemblePlacementPolicy";
    protected static final String NETWORK_TOPOLOGY_STABILIZE_PERIOD_SECONDS = "networkTopologyStabilizePeriodSeconds";
    protected static final String READ_REORDER_THRESHOLD_PENDING_REQUESTS = "readReorderThresholdPendingRequests";
    protected static final String ENSEMBLE_PLACEMENT_POLICY_ORDER_SLOW_BOOKIES = "ensemblePlacementPolicyOrderSlowBookies";
    protected static final String ENABLE_TASK_EXECUTION_STATS = "enableTaskExecutionStats";
    protected static final String TASK_EXECUTION_WARN_TIME_MICROS = "taskExecutionWarnTimeMicros";
    protected static final String ENABLE_BOOKIE_FAILURE_TRACKING = "enableBookieFailureTracking";
    protected static final String BOOKIE_FAILURE_HISTORY_EXPIRATION_MS = "bookieFailureHistoryExpirationMSec";
    protected static final String DISABLE_ENSEMBLE_CHANGE_FEATURE_NAME = "disableEnsembleChangeFeatureName";
    protected static final String CLIENT_ROLE = "clientRole";
    public static final String CLIENT_ROLE_STANDARD = "standard";
    public static final String CLIENT_ROLE_SYSTEM = "system";
    protected static final String CLIENT_AUTH_PROVIDER_FACTORY_CLASS = "clientAuthProviderFactoryClass";
    protected static final String REGISTRATION_CLIENT_CLASS = "registrationClientClass";

    public ClientConfiguration() {
    }

    public ClientConfiguration(AbstractConfiguration conf) {
        this.loadConf(conf);
    }

    public int getThrottleValue() {
        return this.getInt(THROTTLE, 5000);
    }

    public ClientConfiguration setThrottleValue(int throttle) {
        this.setProperty(THROTTLE, Integer.toString(throttle));
        return this;
    }

    public boolean getEnableDigestTypeAutodetection() {
        return this.getBoolean(ENABLE_DIGEST_TYPE_AUTODETECTION, true);
    }

    public ClientConfiguration setEnableDigestTypeAutodetection(boolean enable) {
        this.setProperty(ENABLE_DIGEST_TYPE_AUTODETECTION, enable);
        return this;
    }

    public BookKeeper.DigestType getBookieRecoveryDigestType() {
        return BookKeeper.DigestType.valueOf(this.getString(DIGEST_TYPE, BookKeeper.DigestType.CRC32.toString()));
    }

    public ClientConfiguration setBookieRecoveryDigestType(BookKeeper.DigestType digestType) {
        this.setProperty(DIGEST_TYPE, digestType.toString());
        return this;
    }

    public byte[] getBookieRecoveryPasswd() {
        return this.getString(PASSWD, "").getBytes(Charsets.UTF_8);
    }

    public ClientConfiguration setBookieRecoveryPasswd(byte[] passwd) {
        this.setProperty(PASSWD, new String(passwd, Charsets.UTF_8));
        return this;
    }

    public boolean getClientTcpNoDelay() {
        return this.getBoolean(CLIENT_TCP_NODELAY, true);
    }

    public ClientConfiguration setClientTcpNoDelay(boolean noDelay) {
        this.setProperty(CLIENT_TCP_NODELAY, Boolean.toString(noDelay));
        return this;
    }

    public boolean getClientSockKeepalive() {
        return this.getBoolean(CLIENT_SOCK_KEEPALIVE, true);
    }

    public ClientConfiguration setClientSockKeepalive(boolean keepalive) {
        this.setProperty(CLIENT_SOCK_KEEPALIVE, Boolean.toString(keepalive));
        return this;
    }

    public int getClientSendBufferSize() {
        return this.getInt(CLIENT_SENDBUFFER_SIZE, 0x100000);
    }

    public ClientConfiguration setClientSendBufferSize(int bufferSize) {
        this.setProperty(CLIENT_SENDBUFFER_SIZE, bufferSize);
        return this;
    }

    public int getClientReceiveBufferSize() {
        return this.getInt(CLIENT_RECEIVEBUFFER_SIZE, 0x100000);
    }

    public ClientConfiguration setClientReceiveBufferSize(int bufferSize) {
        this.setProperty(CLIENT_RECEIVEBUFFER_SIZE, bufferSize);
        return this;
    }

    public int getClientWriteBufferLowWaterMark() {
        return this.getInt(CLIENT_WRITEBUFFER_LOW_WATER_MARK, 393216);
    }

    public ClientConfiguration setClientWriteBufferLowWaterMark(int waterMark) {
        this.setProperty(CLIENT_WRITEBUFFER_LOW_WATER_MARK, waterMark);
        return this;
    }

    public int getClientWriteBufferHighWaterMark() {
        return this.getInt(CLIENT_WRITEBUFFER_HIGH_WATER_MARK, 524288);
    }

    public ClientConfiguration setClientWriteBufferHighWaterMark(int waterMark) {
        this.setProperty(CLIENT_WRITEBUFFER_HIGH_WATER_MARK, waterMark);
        return this;
    }

    public long getTimeoutTimerTickDurationMs() {
        return this.getLong(TIMEOUT_TIMER_TICK_DURATION_MS, 100L);
    }

    public ClientConfiguration setTimeoutTimerTickDurationMs(long tickDuration) {
        this.setProperty(TIMEOUT_TIMER_TICK_DURATION_MS, tickDuration);
        return this;
    }

    public int getTimeoutTimerNumTicks() {
        return this.getInt(TIMEOUT_TIMER_NUM_TICKS, 1024);
    }

    public ClientConfiguration setTimeoutTimerNumTicks(int numTicks) {
        this.setProperty(TIMEOUT_TIMER_NUM_TICKS, numTicks);
        return this;
    }

    public int getClientConnectTimeoutMillis() {
        return this.getInt(CLIENT_CONNECT_TIMEOUT_MILLIS, 10000);
    }

    public ClientConfiguration setClientConnectTimeoutMillis(int connectTimeoutMillis) {
        this.setProperty(CLIENT_CONNECT_TIMEOUT_MILLIS, connectTimeoutMillis);
        return this;
    }

    public int getNumChannelsPerBookie() {
        return this.getInt(NUM_CHANNELS_PER_BOOKIE, 1);
    }

    public ClientConfiguration setNumChannelsPerBookie(int numChannelsPerBookie) {
        this.setProperty(NUM_CHANNELS_PER_BOOKIE, numChannelsPerBookie);
        return this;
    }

    public boolean getUseV2WireProtocol() {
        return this.getBoolean(USE_V2_WIRE_PROTOCOL, false);
    }

    public ClientConfiguration setUseV2WireProtocol(boolean useV2WireProtocol) {
        this.setProperty(USE_V2_WIRE_PROTOCOL, useV2WireProtocol);
        return this;
    }

    @Deprecated
    public int getReadTimeout() {
        return this.getInt(READ_TIMEOUT, 5);
    }

    @Deprecated
    public ClientConfiguration setReadTimeout(int timeout) {
        this.setProperty(READ_TIMEOUT, Integer.toString(timeout));
        return this;
    }

    public int getAddEntryTimeout() {
        return this.getInt(ADD_ENTRY_TIMEOUT_SEC, this.getReadTimeout());
    }

    public ClientConfiguration setAddEntryTimeout(int timeout) {
        this.setProperty(ADD_ENTRY_TIMEOUT_SEC, timeout);
        return this;
    }

    public int getAddEntryQuorumTimeout() {
        return this.getInt(ADD_ENTRY_QUORUM_TIMEOUT_SEC, -1);
    }

    public ClientConfiguration setAddEntryQuorumTimeout(int timeout) {
        this.setProperty(ADD_ENTRY_QUORUM_TIMEOUT_SEC, timeout);
        return this;
    }

    public int getReadEntryTimeout() {
        return this.getInt(READ_ENTRY_TIMEOUT_SEC, this.getReadTimeout());
    }

    public ClientConfiguration setReadEntryTimeout(int timeout) {
        this.setProperty(READ_ENTRY_TIMEOUT_SEC, timeout);
        return this;
    }

    public long getTimeoutMonitorIntervalSec() {
        int minTimeout = Math.min(Math.min(this.getAddEntryQuorumTimeout(), this.getAddEntryTimeout()), this.getReadEntryTimeout());
        return this.getLong(TIMEOUT_MONITOR_INTERVAL_SEC, Math.max(minTimeout / 2, 1));
    }

    public ClientConfiguration setTimeoutMonitorIntervalSec(long timeoutInterval) {
        this.setProperty(TIMEOUT_MONITOR_INTERVAL_SEC, Long.toString(timeoutInterval));
        return this;
    }

    @Deprecated
    public long getTimeoutTaskIntervalMillis() {
        return this.getLong(TIMEOUT_TASK_INTERVAL_MILLIS, TimeUnit.SECONDS.toMillis(Math.min(this.getAddEntryTimeout(), this.getReadEntryTimeout())) / 2L);
    }

    @Deprecated
    public ClientConfiguration setTimeoutTaskIntervalMillis(long timeoutMillis) {
        this.setProperty(TIMEOUT_TASK_INTERVAL_MILLIS, Long.toString(timeoutMillis));
        return this;
    }

    public int getExplictLacInterval() {
        return this.getInt(EXPLICIT_LAC_INTERVAL, 0);
    }

    public ClientConfiguration setExplictLacInterval(int interval) {
        this.setProperty(EXPLICIT_LAC_INTERVAL, interval);
        return this;
    }

    @Deprecated
    public long getPCBCTimeoutTimerTickDurationMs() {
        return this.getLong(PCBC_TIMEOUT_TIMER_TICK_DURATION_MS, 100L);
    }

    @Deprecated
    public ClientConfiguration setPCBCTimeoutTimerTickDurationMs(long tickDuration) {
        this.setProperty(PCBC_TIMEOUT_TIMER_TICK_DURATION_MS, tickDuration);
        return this;
    }

    @Deprecated
    public int getPCBCTimeoutTimerNumTicks() {
        return this.getInt(PCBC_TIMEOUT_TIMER_NUM_TICKS, 1024);
    }

    @Deprecated
    public ClientConfiguration setPCBCTimeoutTimerNumTicks(int numTicks) {
        this.setProperty(PCBC_TIMEOUT_TIMER_NUM_TICKS, numTicks);
        return this;
    }

    public long getWaitTimeoutOnBackpressureMillis() {
        return this.getLong(WAIT_TIMEOUT_ON_BACKPRESSURE, -1L);
    }

    public ClientConfiguration setWaitTimeoutOnBackpressureMillis(long value) {
        this.setProperty(WAIT_TIMEOUT_ON_BACKPRESSURE, value);
        return this;
    }

    public int getNumWorkerThreads() {
        return this.getInt(NUM_WORKER_THREADS, Runtime.getRuntime().availableProcessors());
    }

    public ClientConfiguration setNumWorkerThreads(int numThreads) {
        this.setProperty(NUM_WORKER_THREADS, numThreads);
        return this;
    }

    public int getNumIOThreads() {
        return this.getInt(NUM_IO_THREADS, 2 * Runtime.getRuntime().availableProcessors());
    }

    public ClientConfiguration setNumIOThreads(int numThreads) {
        this.setProperty(NUM_IO_THREADS, numThreads);
        return this;
    }

    public int getSpeculativeReadTimeout() {
        return this.getInt(SPECULATIVE_READ_TIMEOUT, 2000);
    }

    public ClientConfiguration setSpeculativeReadTimeout(int timeout) {
        this.setProperty(SPECULATIVE_READ_TIMEOUT, timeout);
        return this;
    }

    public int getFirstSpeculativeReadTimeout() {
        return this.getInt(FIRST_SPECULATIVE_READ_TIMEOUT, this.getSpeculativeReadTimeout());
    }

    public ClientConfiguration setFirstSpeculativeReadTimeout(int timeout) {
        this.setProperty(FIRST_SPECULATIVE_READ_TIMEOUT, timeout);
        return this;
    }

    public float getSpeculativeReadTimeoutBackoffMultiplier() {
        return this.getFloat(SPECULATIVE_READ_TIMEOUT_BACKOFF_MULTIPLIER, 2.0f);
    }

    public ClientConfiguration setSpeculativeReadTimeoutBackoffMultiplier(float speculativeReadTimeoutBackoffMultiplier) {
        this.setProperty(SPECULATIVE_READ_TIMEOUT_BACKOFF_MULTIPLIER, Float.valueOf(speculativeReadTimeoutBackoffMultiplier));
        return this;
    }

    public float getSpeculativeReadLACTimeoutBackoffMultiplier() {
        return this.getFloat(SPECULATIVE_READ_LAC_TIMEOUT_BACKOFF_MULTIPLIER, 2.0f);
    }

    public ClientConfiguration setSpeculativeReadLACTimeoutBackoffMultiplier(float speculativeReadLACTimeoutBackoffMultiplier) {
        this.setProperty(SPECULATIVE_READ_LAC_TIMEOUT_BACKOFF_MULTIPLIER, Float.valueOf(speculativeReadLACTimeoutBackoffMultiplier));
        return this;
    }

    public int getMaxSpeculativeReadTimeout() {
        return this.getInt(MAX_SPECULATIVE_READ_TIMEOUT, this.getSpeculativeReadTimeout());
    }

    public ClientConfiguration setMaxSpeculativeReadTimeout(int timeout) {
        this.setProperty(MAX_SPECULATIVE_READ_TIMEOUT, timeout);
        return this;
    }

    public int getFirstSpeculativeReadLACTimeout() {
        return this.getInt(FIRST_SPECULATIVE_READ_LAC_TIMEOUT, 1500);
    }

    public int getMaxSpeculativeReadLACTimeout() {
        return this.getInt(MAX_SPECULATIVE_READ_LAC_TIMEOUT, 5000);
    }

    public ClientConfiguration setFirstSpeculativeReadLACTimeout(int timeout) {
        this.setProperty(FIRST_SPECULATIVE_READ_LAC_TIMEOUT, timeout);
        return this;
    }

    public ClientConfiguration setMaxSpeculativeReadLACTimeout(int timeout) {
        this.setProperty(MAX_SPECULATIVE_READ_LAC_TIMEOUT, timeout);
        return this;
    }

    public boolean getEnableParallelRecoveryRead() {
        return this.getBoolean(ENABLE_PARALLEL_RECOVERY_READ, false);
    }

    public ClientConfiguration setEnableParallelRecoveryRead(boolean enabled) {
        this.setProperty(ENABLE_PARALLEL_RECOVERY_READ, enabled);
        return this;
    }

    public int getRecoveryReadBatchSize() {
        return this.getInt(RECOVERY_READ_BATCH_SIZE, 1);
    }

    public ClientConfiguration setRecoveryReadBatchSize(int batchSize) {
        this.setProperty(RECOVERY_READ_BATCH_SIZE, batchSize);
        return this;
    }

    public boolean isReorderReadSequenceEnabled() {
        return this.getBoolean(REORDER_READ_SEQUENCE_ENABLED, false);
    }

    public ClientConfiguration setReorderReadSequenceEnabled(boolean enabled) {
        this.setProperty(REORDER_READ_SEQUENCE_ENABLED, enabled);
        return this;
    }

    public boolean isStickyReadsEnabled() {
        return this.getBoolean(STICKY_READS_ENABLED, false);
    }

    public ClientConfiguration setStickyReadsEnabled(boolean enabled) {
        this.setProperty(STICKY_READS_ENABLED, enabled);
        return this;
    }

    public Class<? extends EnsemblePlacementPolicy> getEnsemblePlacementPolicy() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, (String)ENSEMBLE_PLACEMENT_POLICY, RackawareEnsemblePlacementPolicy.class, EnsemblePlacementPolicy.class, (ClassLoader)DEFAULT_LOADER);
    }

    public ClientConfiguration setEnsemblePlacementPolicy(Class<? extends EnsemblePlacementPolicy> policyClass) {
        this.setProperty(ENSEMBLE_PLACEMENT_POLICY, policyClass.getName());
        return this;
    }

    public int getReorderThresholdPendingRequests() {
        return this.getInt(READ_REORDER_THRESHOLD_PENDING_REQUESTS, 0);
    }

    public ClientConfiguration setReorderThresholdPendingRequests(int threshold) {
        this.setProperty(READ_REORDER_THRESHOLD_PENDING_REQUESTS, threshold);
        return this;
    }

    public int getNetworkTopologyStabilizePeriodSeconds() {
        return this.getInt(NETWORK_TOPOLOGY_STABILIZE_PERIOD_SECONDS, 0);
    }

    public ClientConfiguration setNetworkTopologyStabilizePeriodSeconds(int seconds) {
        this.setProperty(NETWORK_TOPOLOGY_STABILIZE_PERIOD_SECONDS, seconds);
        return this;
    }

    public boolean getEnsemblePlacementPolicySlowBookies() {
        return this.getBoolean(ENSEMBLE_PLACEMENT_POLICY_ORDER_SLOW_BOOKIES, false);
    }

    public ClientConfiguration setEnsemblePlacementPolicySlowBookies(boolean enabled) {
        this.setProperty(ENSEMBLE_PLACEMENT_POLICY_ORDER_SLOW_BOOKIES, enabled);
        return this;
    }

    public boolean getEnableTaskExecutionStats() {
        return this.getBoolean(ENABLE_TASK_EXECUTION_STATS, false);
    }

    public ClientConfiguration setEnableTaskExecutionStats(boolean enabled) {
        this.setProperty(ENABLE_TASK_EXECUTION_STATS, enabled);
        return this;
    }

    public long getTaskExecutionWarnTimeMicros() {
        return this.getLong(TASK_EXECUTION_WARN_TIME_MICROS, TimeUnit.SECONDS.toMicros(1L));
    }

    public ClientConfiguration setTaskExecutionWarnTimeMicros(long warnTime) {
        this.setProperty(TASK_EXECUTION_WARN_TIME_MICROS, warnTime);
        return this;
    }

    public boolean isBookieHealthCheckEnabled() {
        return this.getBoolean(BOOKIE_HEALTH_CHECK_ENABLED, false);
    }

    public ClientConfiguration enableBookieHealthCheck() {
        this.setProperty(BOOKIE_HEALTH_CHECK_ENABLED, true);
        return this;
    }

    public int getBookieHealthCheckIntervalSeconds() {
        return this.getInt(BOOKIE_HEALTH_CHECK_INTERVAL_SECONDS, 60);
    }

    public ClientConfiguration setBookieHealthCheckInterval(int interval, TimeUnit unit) {
        this.setProperty(BOOKIE_HEALTH_CHECK_INTERVAL_SECONDS, unit.toSeconds(interval));
        return this;
    }

    public long getBookieErrorThresholdPerInterval() {
        return this.getLong(BOOKIE_ERROR_THRESHOLD_PER_INTERVAL, 100L);
    }

    public ClientConfiguration setBookieErrorThresholdPerInterval(long thresholdPerInterval) {
        this.setProperty(BOOKIE_ERROR_THRESHOLD_PER_INTERVAL, thresholdPerInterval);
        return this;
    }

    public int getBookieQuarantineTimeSeconds() {
        return this.getInt(BOOKIE_QUARANTINE_TIME_SECONDS, 1800);
    }

    public ClientConfiguration setBookieQuarantineTime(int quarantineTime, TimeUnit unit) {
        this.setProperty(BOOKIE_QUARANTINE_TIME_SECONDS, unit.toSeconds(quarantineTime));
        return this;
    }

    @Override
    public ClientConfiguration setNettyMaxFrameSizeBytes(int maxSize) {
        super.setNettyMaxFrameSizeBytes(maxSize);
        return this;
    }

    public int getGetBookieInfoIntervalSeconds() {
        return this.getInt(GET_BOOKIE_INFO_INTERVAL_SECONDS, 86400);
    }

    public int getGetBookieInfoRetryIntervalSeconds() {
        return this.getInt(GET_BOOKIE_INFO_RETRY_INTERVAL_SECONDS, 60);
    }

    public boolean getDiskWeightBasedPlacementEnabled() {
        return this.getBoolean(DISK_WEIGHT_BASED_PLACEMENT_ENABLED, false);
    }

    public int getBookieMaxWeightMultipleForWeightBasedPlacement() {
        return this.getInt(BOOKIE_MAX_MULTIPLE_FOR_WEIGHTED_PLACEMENT, 3);
    }

    public int getBookieInfoTimeout() {
        return this.getInteger(GET_BOOKIE_INFO_TIMEOUT_SECS, 5);
    }

    public int getStartTLSTimeout() {
        return this.getInteger(START_TLS_TIMEOUT_SECS, 10);
    }

    public ClientConfiguration setDiskWeightBasedPlacementEnabled(boolean isEnabled) {
        this.setProperty(DISK_WEIGHT_BASED_PLACEMENT_ENABLED, isEnabled);
        return this;
    }

    public ClientConfiguration setGetBookieInfoIntervalSeconds(int pollInterval, TimeUnit unit) {
        this.setProperty(GET_BOOKIE_INFO_INTERVAL_SECONDS, unit.toSeconds(pollInterval));
        return this;
    }

    public ClientConfiguration setGetBookieInfoRetryIntervalSeconds(int interval, TimeUnit unit) {
        this.setProperty(GET_BOOKIE_INFO_RETRY_INTERVAL_SECONDS, unit.toSeconds(interval));
        return this;
    }

    public ClientConfiguration setBookieMaxWeightMultipleForWeightBasedPlacement(int multiple) {
        this.setProperty(BOOKIE_MAX_MULTIPLE_FOR_WEIGHTED_PLACEMENT, multiple);
        return this;
    }

    public ClientConfiguration setGetBookieInfoTimeout(int timeoutSecs) {
        this.setProperty(GET_BOOKIE_INFO_TIMEOUT_SECS, timeoutSecs);
        return this;
    }

    public ClientConfiguration setStartTLSTimeout(int timeoutSecs) {
        this.setProperty(START_TLS_TIMEOUT_SECS, timeoutSecs);
        return this;
    }

    public ClientConfiguration setClientRole(String role) {
        if (role == null) {
            throw new NullPointerException();
        }
        switch (role) {
            case "standard": 
            case "system": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid role " + role);
            }
        }
        this.setProperty(CLIENT_ROLE, role);
        return this;
    }

    public String getClientRole() {
        return this.getString(CLIENT_ROLE, CLIENT_ROLE_STANDARD);
    }

    public String getTLSKeyStoreType() {
        return this.getString(CLIENT_TLS_KEYSTORE_TYPE, this.getString("tlsKeyStoreType", "JKS"));
    }

    public ClientConfiguration setTLSKeyStoreType(String arg) {
        this.setProperty("tlsKeyStoreType", arg);
        return this;
    }

    public String getTLSKeyStore() {
        return this.getString(CLIENT_TLS_KEYSTORE, this.getString("tlsKeyStore", null));
    }

    public ClientConfiguration setTLSKeyStore(String arg) {
        this.setProperty("tlsKeyStore", arg);
        return this;
    }

    public String getTLSKeyStorePasswordPath() {
        return this.getString(CLIENT_TLS_KEYSTORE_PASSWORD_PATH, this.getString("tlsKeyStorePasswordPath", null));
    }

    public ClientConfiguration setTLSKeyStorePasswordPath(String arg) {
        this.setProperty("tlsKeyStorePasswordPath", arg);
        return this;
    }

    public String getTLSTrustStoreType() {
        return this.getString(CLIENT_TLS_TRUSTSTORE_TYPE, this.getString("tlsTrustStoreType", "JKS"));
    }

    public ClientConfiguration setTLSTrustStoreType(String arg) {
        this.setProperty("tlsTrustStoreType", arg);
        return this;
    }

    public String getTLSTrustStore() {
        return this.getString(CLIENT_TLS_TRUSTSTORE, this.getString("tlsTrustStore", null));
    }

    public ClientConfiguration setTLSTrustStore(String arg) {
        this.setProperty("tlsTrustStore", arg);
        return this;
    }

    public String getTLSTrustStorePasswordPath() {
        return this.getString(CLIENT_TLS_TRUSTSTORE_PASSWORD_PATH, this.getString("tlsTrustStorePasswordPath", null));
    }

    public ClientConfiguration setTLSTrustStorePasswordPath(String arg) {
        this.setProperty("tlsTrustStorePasswordPath", arg);
        return this;
    }

    public String getTLSCertificatePath() {
        return this.getString("tlsCertificatePath", null);
    }

    public ClientConfiguration setTLSCertificatePath(String arg) {
        this.setProperty("tlsCertificatePath", arg);
        return this;
    }

    public boolean getDelayEnsembleChange() {
        return this.getBoolean(DELAY_ENSEMBLE_CHANGE, false);
    }

    public ClientConfiguration setDelayEnsembleChange(boolean enabled) {
        this.setProperty(DELAY_ENSEMBLE_CHANGE, enabled);
        return this;
    }

    public boolean getEnableBookieFailureTracking() {
        return this.getBoolean(ENABLE_BOOKIE_FAILURE_TRACKING, true);
    }

    public ClientConfiguration setEnableBookieFailureTracking(boolean enabled) {
        this.setProperty(ENABLE_BOOKIE_FAILURE_TRACKING, enabled);
        return this;
    }

    public int getBookieFailureHistoryExpirationMSec() {
        return this.getInt(BOOKIE_FAILURE_HISTORY_EXPIRATION_MS, 60000);
    }

    public ClientConfiguration setBookieFailureHistoryExpirationMSec(int expirationMSec) {
        this.setProperty(BOOKIE_FAILURE_HISTORY_EXPIRATION_MS, expirationMSec);
        return this;
    }

    public String getDisableEnsembleChangeFeatureName() {
        return this.getString(DISABLE_ENSEMBLE_CHANGE_FEATURE_NAME, "disable_ensemble_change");
    }

    public ClientConfiguration setDisableEnsembleChangeFeatureName(String disableEnsembleChangeFeatureName) {
        this.setProperty(DISABLE_ENSEMBLE_CHANGE_FEATURE_NAME, disableEnsembleChangeFeatureName);
        return this;
    }

    public int getMaxAllowedEnsembleChanges() {
        return this.getInt(MAX_ALLOWED_ENSEMBLE_CHANGES, Integer.MAX_VALUE);
    }

    public ClientConfiguration setMaxAllowedEnsembleChanges(int num) {
        this.setProperty(MAX_ALLOWED_ENSEMBLE_CHANGES, num);
        return this;
    }

    @Deprecated
    public boolean isNettyUsePooledBuffers() {
        return this.getBoolean(NETTY_USE_POOLED_BUFFERS, true);
    }

    public ClientConfiguration setNettyUsePooledBuffers(boolean enabled) {
        this.setProperty(NETTY_USE_POOLED_BUFFERS, enabled);
        return this;
    }

    @Deprecated
    public ClientConfiguration setRegistrationClientClass(Class<? extends RegistrationClient> regClientClass) {
        this.setProperty(REGISTRATION_CLIENT_CLASS, regClientClass);
        return this;
    }

    @Deprecated
    public Class<? extends RegistrationClient> getRegistrationClientClass() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, (String)REGISTRATION_CLIENT_CLASS, ZKRegistrationClient.class, RegistrationClient.class, (ClassLoader)DEFAULT_LOADER);
    }

    public ClientConfiguration setStoreSystemtimeAsLedgerCreationTime(boolean enabled) {
        this.setProperty("storeSystemTimeAsLedgerCreationTime", enabled);
        return this;
    }

    public boolean getStoreSystemtimeAsLedgerCreationTime() {
        return this.getBoolean("storeSystemTimeAsLedgerCreationTime", false);
    }

    @Override
    protected ClientConfiguration getThis() {
        return this;
    }
}

