/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.tools.cli.commands.bookie.LastMarkCommand;
import org.apache.bookkeeper.tools.cli.commands.bookies.ListBookiesCommand;
import org.apache.bookkeeper.tools.cli.commands.client.SimpleTestCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.util.EntryFormatter;
import org.apache.bookkeeper.util.LedgerIdFormatter;
import org.apache.bookkeeper.versioning.LongVersion;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.ParseException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BookieShell.class, MetadataDrivers.class})
public class BookieShellTest {
    private ClientConfiguration clientConf;
    private BookieShell shell;
    private BookKeeperAdmin admin;
    private RegistrationManager rm;
    private MetadataBookieDriver driver;
    private Cookie cookie;
    private Version version;
    private LastMarkCommand mockLastMarkCommand;
    private SimpleTestCommand.Flags mockSimpleTestFlags;
    private SimpleTestCommand mockSimpleTestCommand;
    private ListBookiesCommand.Flags mockListBookiesFlags;
    private ListBookiesCommand mockListBookiesCommand;

    @Before
    public void setup() throws Exception {
        this.mockLastMarkCommand = (LastMarkCommand)Mockito.mock(LastMarkCommand.class);
        PowerMockito.whenNew(LastMarkCommand.class).withNoArguments().thenReturn((Object)this.mockLastMarkCommand);
        this.mockSimpleTestFlags = (SimpleTestCommand.Flags)PowerMockito.spy((Object)new SimpleTestCommand.Flags());
        PowerMockito.whenNew(SimpleTestCommand.Flags.class).withNoArguments().thenReturn((Object)this.mockSimpleTestFlags);
        this.mockSimpleTestCommand = (SimpleTestCommand)PowerMockito.spy((Object)new SimpleTestCommand());
        ((SimpleTestCommand)Mockito.doReturn((Object)true).when((Object)this.mockSimpleTestCommand)).apply((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class), (CliFlags)ArgumentMatchers.any(SimpleTestCommand.Flags.class));
        PowerMockito.whenNew(SimpleTestCommand.class).withParameterTypes(SimpleTestCommand.Flags.class, new Class[0]).withArguments((Object)this.mockSimpleTestFlags, new Object[0]).thenReturn((Object)this.mockSimpleTestCommand);
        this.mockListBookiesFlags = (ListBookiesCommand.Flags)PowerMockito.spy((Object)new ListBookiesCommand.Flags());
        PowerMockito.whenNew(ListBookiesCommand.Flags.class).withNoArguments().thenReturn((Object)this.mockListBookiesFlags);
        this.mockListBookiesCommand = (ListBookiesCommand)PowerMockito.spy((Object)new ListBookiesCommand());
        ((ListBookiesCommand)Mockito.doReturn((Object)true).when((Object)this.mockListBookiesCommand)).apply((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class), (CliFlags)ArgumentMatchers.any(ListBookiesCommand.Flags.class));
        PowerMockito.whenNew(ListBookiesCommand.class).withParameterTypes(ListBookiesCommand.Flags.class, new Class[0]).withArguments((Object)this.mockListBookiesFlags, new Object[0]).thenReturn((Object)this.mockListBookiesCommand);
        this.shell = new BookieShell(LedgerIdFormatter.LONG_LEDGERID_FORMATTER, EntryFormatter.STRING_FORMATTER);
        this.admin = (BookKeeperAdmin)PowerMockito.mock(BookKeeperAdmin.class);
        PowerMockito.whenNew(BookKeeperAdmin.class).withParameterTypes(ClientConfiguration.class, new Class[0]).withArguments(ArgumentMatchers.any(ClientConfiguration.class), new Object[0]).thenReturn((Object)this.admin);
        this.clientConf = new ClientConfiguration();
        this.clientConf.setMetadataServiceUri("zk://127.0.0.1/path/to/ledgers");
        Mockito.when((Object)this.admin.getConf()).thenReturn((Object)this.clientConf);
        this.rm = (RegistrationManager)PowerMockito.mock(RegistrationManager.class);
        this.cookie = Cookie.newBuilder().setBookieHost("127.0.0.1:3181").setInstanceId("xyz").setJournalDirs("/path/to/journal/dir").setLedgerDirs("/path/to/journal/dir").setLayoutVersion(4).build();
        this.version = new LongVersion(1L);
        Mockito.when((Object)this.rm.readCookie(ArgumentMatchers.anyString())).thenReturn((Object)new Versioned((Object)this.cookie.toString().getBytes(Charsets.UTF_8), this.version));
        this.driver = (MetadataBookieDriver)Mockito.mock(MetadataBookieDriver.class);
        Mockito.when((Object)this.driver.getRegistrationManager()).thenReturn((Object)this.rm);
        PowerMockito.mockStatic(MetadataDrivers.class, (Class[])new Class[0]);
        PowerMockito.doAnswer(invocationOnMock -> {
            Function function = (Function)invocationOnMock.getArgument(1);
            function.apply(this.rm);
            return null;
        }).when(MetadataDrivers.class, "runFunctionWithRegistrationManager", new Object[]{ArgumentMatchers.any(ServerConfiguration.class), ArgumentMatchers.any(Function.class)});
    }

    private static CommandLine parseCommandLine(BookieShell.MyCommand cmd, String ... args) throws ParseException {
        BasicParser parser = new BasicParser();
        return parser.parse(cmd.getOptions(), args);
    }

    @Test
    public void testRecoverCmdMissingArgument() throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, new String[0]);
        try {
            cmd.runCmd(cmdLine);
            Assert.fail((String)"should fail running command when the arguments are missing");
        }
        catch (MissingArgumentException missingArgumentException) {
            // empty catch block
        }
        PowerMockito.verifyNew(BookKeeperAdmin.class, (VerificationMode)Mockito.never()).withArguments(ArgumentMatchers.any(ClientConfiguration.class), new Object[0]);
    }

    @Test
    public void testRecoverCmdInvalidBookieAddress() throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, "127.0.0.1");
        Assert.assertEquals((long)-1L, (long)cmd.runCmd(cmdLine));
        PowerMockito.verifyNew(BookKeeperAdmin.class, (VerificationMode)Mockito.never()).withArguments(ArgumentMatchers.any(ClientConfiguration.class), new Object[0]);
    }

    @Test
    public void testRecoverCmdQuery() throws Exception {
        TreeMap ledgersContainBookies = Maps.newTreeMap();
        Mockito.when((Object)this.admin.getLedgersContainBookies((Set)ArgumentMatchers.any(Set.class))).thenReturn((Object)ledgersContainBookies);
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, "-force", "-q", "127.0.0.1:3181");
        Assert.assertEquals((long)0L, (long)cmd.runCmd(cmdLine));
        PowerMockito.verifyNew(BookKeeperAdmin.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.any(ClientConfiguration.class), new Object[0]);
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).getLedgersContainBookies((Set)ArgumentMatchers.any(Set.class));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testRecoverCmdRecoverLedgerDefault() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, false, false, false, "-force", "-l", "12345", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerDeleteCookie() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, false, false, true, "-force", "-l", "12345", "-deleteCookie", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerSkipOpenLedgersDeleteCookie() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, false, true, true, "-force", "-l", "12345", "-deleteCookie", "-skipOpenLedgers", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerDryrun() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, true, false, false, "-force", "-l", "12345", "-dryrun", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverLedgerDryrunDeleteCookie() throws Exception {
        this.testRecoverCmdRecoverLedger(12345L, true, false, false, "-force", "-l", "12345", "-dryrun", "-deleteCookie", "127.0.0.1:3181");
    }

    void testRecoverCmdRecoverLedger(long ledgerId, boolean dryrun, boolean skipOpenLedgers, boolean removeCookies, String ... args) throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, args);
        Assert.assertEquals((long)0L, (long)cmd.runCmd(cmdLine));
        PowerMockito.verifyNew(BookKeeperAdmin.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.any(ClientConfiguration.class), new Object[0]);
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).recoverBookieData(ArgumentMatchers.eq((long)ledgerId), (Set)ArgumentMatchers.any(Set.class), ArgumentMatchers.eq((boolean)dryrun), ArgumentMatchers.eq((boolean)skipOpenLedgers));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).close();
        if (removeCookies) {
            PowerMockito.verifyStatic(MetadataDrivers.class);
            MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class)), (Function)((Function)ArgumentMatchers.any(Function.class)));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).readCookie(ArgumentMatchers.anyString());
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).removeCookie(ArgumentMatchers.anyString(), (Version)ArgumentMatchers.eq((Object)this.version));
        } else {
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).readCookie(ArgumentMatchers.anyString());
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).removeCookie(ArgumentMatchers.anyString(), (Version)ArgumentMatchers.eq((Object)this.version));
        }
    }

    @Test
    public void testRecoverCmdRecoverDefault() throws Exception {
        this.testRecoverCmdRecover(false, false, false, "-force", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverDeleteCookie() throws Exception {
        this.testRecoverCmdRecover(false, false, true, "-force", "-deleteCookie", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverSkipOpenLedgersDeleteCookie() throws Exception {
        this.testRecoverCmdRecover(false, true, true, "-force", "-deleteCookie", "-skipOpenLedgers", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverDryrun() throws Exception {
        this.testRecoverCmdRecover(true, false, false, "-force", "-dryrun", "127.0.0.1:3181");
    }

    @Test
    public void testRecoverCmdRecoverDryrunDeleteCookie() throws Exception {
        this.testRecoverCmdRecover(true, false, false, "-force", "-dryrun", "-deleteCookie", "127.0.0.1:3181");
    }

    void testRecoverCmdRecover(boolean dryrun, boolean skipOpenLedgers, boolean removeCookies, String ... args) throws Exception {
        BookieShell.RecoverCmd cmd = (BookieShell.RecoverCmd)this.shell.commands.get("recover");
        CommandLine cmdLine = BookieShellTest.parseCommandLine((BookieShell.MyCommand)cmd, args);
        Assert.assertEquals((long)0L, (long)cmd.runCmd(cmdLine));
        PowerMockito.verifyNew(BookKeeperAdmin.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.any(ClientConfiguration.class), new Object[0]);
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).recoverBookieData((Set)ArgumentMatchers.any(Set.class), ArgumentMatchers.eq((boolean)dryrun), ArgumentMatchers.eq((boolean)skipOpenLedgers));
        ((BookKeeperAdmin)Mockito.verify((Object)this.admin, (VerificationMode)Mockito.times((int)1))).close();
        if (removeCookies) {
            PowerMockito.verifyStatic(MetadataDrivers.class);
            MetadataDrivers.runFunctionWithRegistrationManager((ServerConfiguration)((ServerConfiguration)ArgumentMatchers.any(ServerConfiguration.class)), (Function)((Function)ArgumentMatchers.any(Function.class)));
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).readCookie(ArgumentMatchers.anyString());
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)1))).removeCookie(ArgumentMatchers.anyString(), (Version)ArgumentMatchers.eq((Object)this.version));
        } else {
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).readCookie(ArgumentMatchers.anyString());
            ((RegistrationManager)Mockito.verify((Object)this.rm, (VerificationMode)Mockito.times((int)0))).removeCookie(ArgumentMatchers.anyString(), (Version)ArgumentMatchers.eq((Object)this.version));
        }
    }

    @Test
    public void testLastMarkCmd() throws Exception {
        this.shell.run(new String[]{"lastmark"});
        PowerMockito.verifyNew(LastMarkCommand.class, (VerificationMode)Mockito.times((int)1)).withNoArguments();
        ((LastMarkCommand)Mockito.verify((Object)this.mockLastMarkCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.any(CliFlags.class));
    }

    @Test
    public void testSimpleTestCmd() throws Exception {
        this.shell.run(new String[]{"simpletest", "-e", "10", "-w", "5", "-a", "3", "-n", "200"});
        PowerMockito.verifyNew(SimpleTestCommand.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.same((Object)this.mockSimpleTestFlags), new Object[0]);
        ((SimpleTestCommand)Mockito.verify((Object)this.mockSimpleTestCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)this.mockSimpleTestFlags));
        ((SimpleTestCommand.Flags)Mockito.verify((Object)this.mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).ensembleSize(ArgumentMatchers.eq((int)10));
        ((SimpleTestCommand.Flags)Mockito.verify((Object)this.mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).writeQuorumSize(ArgumentMatchers.eq((int)5));
        ((SimpleTestCommand.Flags)Mockito.verify((Object)this.mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).ackQuorumSize(ArgumentMatchers.eq((int)3));
        ((SimpleTestCommand.Flags)Mockito.verify((Object)this.mockSimpleTestFlags, (VerificationMode)Mockito.times((int)1))).numEntries(ArgumentMatchers.eq((int)200));
    }

    @Test
    public void testListBookiesCmdNoArgs() throws Exception {
        Assert.assertEquals((long)1L, (long)this.shell.run(new String[]{"listbookies"}));
        PowerMockito.verifyNew(ListBookiesCommand.class, (VerificationMode)Mockito.times((int)0)).withNoArguments();
    }

    @Test
    public void testListBookiesCmdConflictArgs() throws Exception {
        Assert.assertEquals((long)1L, (long)this.shell.run(new String[]{"listbookies", "-rw", "-ro"}));
        PowerMockito.verifyNew(ListBookiesCommand.class, (VerificationMode)Mockito.times((int)0)).withNoArguments();
    }

    @Test
    public void testListBookiesCmdReadOnly() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"listbookies", "-ro"}));
        PowerMockito.verifyNew(ListBookiesCommand.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.same((Object)this.mockListBookiesFlags), new Object[0]);
        ((ListBookiesCommand)Mockito.verify((Object)this.mockListBookiesCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)this.mockListBookiesFlags));
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readonly(true);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readwrite(false);
    }

    @Test
    public void testListBookiesCmdReadWrite() throws Exception {
        Assert.assertEquals((long)0L, (long)this.shell.run(new String[]{"listbookies", "-rw"}));
        PowerMockito.verifyNew(ListBookiesCommand.class, (VerificationMode)Mockito.times((int)1)).withArguments(ArgumentMatchers.same((Object)this.mockListBookiesFlags), new Object[0]);
        ((ListBookiesCommand)Mockito.verify((Object)this.mockListBookiesCommand, (VerificationMode)Mockito.times((int)1))).apply((ServerConfiguration)ArgumentMatchers.same((Object)this.shell.bkConf), (CliFlags)ArgumentMatchers.same((Object)this.mockListBookiesFlags));
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readonly(false);
        ((ListBookiesCommand.Flags)Mockito.verify((Object)this.mockListBookiesFlags, (VerificationMode)Mockito.times((int)1))).readwrite(true);
    }
}

