/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.CompactableLedgerStorage;
import org.apache.bookkeeper.bookie.GarbageCollector;
import org.apache.bookkeeper.bookie.ScanAndCompareGarbageCollector;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.HierarchicalLedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerManagerTestCase;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.SnapshotMap;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGcOverreplicatedLedger
extends LedgerManagerTestCase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ledgerManager = this.ledgerManagerFactory.newLedgerManager();
        this.activeLedgers = new SnapshotMap();
    }

    public TestGcOverreplicatedLedger(Class<? extends LedgerManagerFactory> lmFactoryCls) {
        super(lmFactoryCls, 3);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList(new Object[][]{{HierarchicalLedgerManagerFactory.class}});
    }

    @Test
    public void testGcOverreplicatedLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        this.activeLedgers.put((Object)lh.getId(), (Object)true);
        LedgerMetadata newLedgerMetadata = (LedgerMetadata)((Versioned)this.ledgerManager.readLedgerMetadata(lh.getId()).get()).getValue();
        BookieSocketAddress bookieNotInEnsemble = this.getBookieNotInEnsemble(newLedgerMetadata);
        ServerConfiguration bkConf = this.getBkConf(bookieNotInEnsemble);
        bkConf.setGcOverreplicatedLedgerWaitTime(10L, TimeUnit.MILLISECONDS);
        lh.close();
        final LedgerManagerTestCase.MockLedgerStorage mockLedgerStorage = new LedgerManagerTestCase.MockLedgerStorage();
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.ledgerManager, (CompactableLedgerStorage)mockLedgerStorage, bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        Thread.sleep(bkConf.getGcOverreplicatedLedgerWaitTimeMillis() + 1L);
        garbageCollector.gc(new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                try {
                    mockLedgerStorage.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        Assert.assertFalse((boolean)this.activeLedgers.containsKey((Object)lh.getId()));
    }

    @Test
    public void testNoGcOfLedger() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        this.activeLedgers.put((Object)lh.getId(), (Object)true);
        LedgerMetadata newLedgerMetadata = (LedgerMetadata)((Versioned)this.ledgerManager.readLedgerMetadata(lh.getId()).get()).getValue();
        BookieSocketAddress address = null;
        NavigableMap ensembleMap = newLedgerMetadata.getAllEnsembles();
        for (List ensemble : ensembleMap.values()) {
            address = (BookieSocketAddress)ensemble.get(0);
        }
        ServerConfiguration bkConf = this.getBkConf(address);
        bkConf.setGcOverreplicatedLedgerWaitTime(10L, TimeUnit.MILLISECONDS);
        lh.close();
        final LedgerManagerTestCase.MockLedgerStorage mockLedgerStorage = new LedgerManagerTestCase.MockLedgerStorage();
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.ledgerManager, (CompactableLedgerStorage)mockLedgerStorage, bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        Thread.sleep(bkConf.getGcOverreplicatedLedgerWaitTimeMillis() + 1L);
        garbageCollector.gc(new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                try {
                    mockLedgerStorage.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        Assert.assertTrue((boolean)this.activeLedgers.containsKey((Object)lh.getId()));
    }

    @Test
    public void testNoGcIfLedgerBeingReplicated() throws Exception {
        LedgerHandle lh = this.bkc.createLedger(2, 2, BookKeeper.DigestType.MAC, "".getBytes());
        this.activeLedgers.put((Object)lh.getId(), (Object)true);
        LedgerMetadata newLedgerMetadata = (LedgerMetadata)((Versioned)this.ledgerManager.readLedgerMetadata(lh.getId()).get()).getValue();
        BookieSocketAddress bookieNotInEnsemble = this.getBookieNotInEnsemble(newLedgerMetadata);
        ServerConfiguration bkConf = this.getBkConf(bookieNotInEnsemble);
        bkConf.setGcOverreplicatedLedgerWaitTime(10L, TimeUnit.MILLISECONDS);
        lh.close();
        ZkLedgerUnderreplicationManager.acquireUnderreplicatedLedgerLock((ZooKeeper)this.zkc, (String)ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)this.baseConf), (long)lh.getId(), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        final LedgerManagerTestCase.MockLedgerStorage mockLedgerStorage = new LedgerManagerTestCase.MockLedgerStorage();
        ScanAndCompareGarbageCollector garbageCollector = new ScanAndCompareGarbageCollector(this.ledgerManager, (CompactableLedgerStorage)mockLedgerStorage, bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        Thread.sleep(bkConf.getGcOverreplicatedLedgerWaitTimeMillis() + 1L);
        garbageCollector.gc(new GarbageCollector.GarbageCleaner(){

            public void clean(long ledgerId) {
                try {
                    mockLedgerStorage.deleteLedger(ledgerId);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
            }
        });
        Assert.assertTrue((boolean)this.activeLedgers.containsKey((Object)lh.getId()));
    }

    private BookieSocketAddress getBookieNotInEnsemble(LedgerMetadata ledgerMetadata) throws UnknownHostException {
        ArrayList allAddresses = Lists.newArrayList();
        for (BookieServer bk : this.bs) {
            allAddresses.add(bk.getLocalAddress());
        }
        NavigableMap ensembles = ledgerMetadata.getAllEnsembles();
        for (List fragmentEnsembles : ensembles.values()) {
            allAddresses.removeAll(fragmentEnsembles);
        }
        Assert.assertEquals((long)allAddresses.size(), (long)1L);
        return (BookieSocketAddress)allAddresses.get(0);
    }
}

