/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.nio.charset.Charset;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.bookie.storage.ldb.WriteCache;
import org.junit.Assert;
import org.junit.Test;

public class WriteCacheTest {
    private static final ByteBufAllocator allocator = UnpooledByteBufAllocator.DEFAULT;

    @Test
    public void simple() throws Exception {
        WriteCache cache = new WriteCache(allocator, 10240L);
        ByteBuf entry1 = allocator.buffer(1024);
        ByteBufUtil.writeUtf8((ByteBuf)entry1, (CharSequence)"entry-1");
        entry1.writerIndex(entry1.capacity());
        Assert.assertTrue((boolean)cache.isEmpty());
        Assert.assertEquals((long)0L, (long)cache.count());
        Assert.assertEquals((long)0L, (long)cache.size());
        cache.put(1L, 1L, entry1);
        Assert.assertFalse((boolean)cache.isEmpty());
        Assert.assertEquals((long)1L, (long)cache.count());
        Assert.assertEquals((long)entry1.readableBytes(), (long)cache.size());
        Assert.assertEquals((Object)entry1, (Object)cache.get(1L, 1L));
        Assert.assertNull((Object)cache.get(1L, 2L));
        Assert.assertNull((Object)cache.get(2L, 1L));
        Assert.assertEquals((Object)entry1, (Object)cache.getLastEntry(1L));
        Assert.assertEquals(null, (Object)cache.getLastEntry(2L));
        cache.clear();
        Assert.assertTrue((boolean)cache.isEmpty());
        Assert.assertEquals((long)0L, (long)cache.count());
        Assert.assertEquals((long)0L, (long)cache.size());
        entry1.release();
        cache.close();
    }

    @Test
    public void cacheFull() throws Exception {
        int cacheSize = 10240;
        int entrySize = 1024;
        int entriesCount = cacheSize / entrySize;
        WriteCache cache = new WriteCache(allocator, (long)cacheSize);
        ByteBuf entry = allocator.buffer(entrySize);
        entry.writerIndex(entry.capacity());
        for (int i = 0; i < entriesCount; ++i) {
            Assert.assertTrue((boolean)cache.put(1L, (long)i, entry));
        }
        Assert.assertFalse((boolean)cache.put(1L, 11L, entry));
        Assert.assertFalse((boolean)cache.isEmpty());
        Assert.assertEquals((long)entriesCount, (long)cache.count());
        Assert.assertEquals((long)cacheSize, (long)cache.size());
        AtomicInteger findCount = new AtomicInteger(0);
        cache.forEach((ledgerId, entryId, data) -> findCount.incrementAndGet());
        Assert.assertEquals((long)entriesCount, (long)findCount.get());
        cache.deleteLedger(1L);
        findCount.set(0);
        cache.forEach((ledgerId, entryId, data) -> findCount.incrementAndGet());
        Assert.assertEquals((long)0L, (long)findCount.get());
        entry.release();
        cache.close();
    }

    @Test
    public void testMultipleSegments() {
        WriteCache cache = new WriteCache(allocator, 0x100000L, 16384);
        ByteBuf entry = Unpooled.buffer((int)1024);
        entry.writerIndex(entry.capacity());
        for (int i = 0; i < 48; ++i) {
            cache.put(1L, (long)i, entry);
        }
        Assert.assertEquals((long)48L, (long)cache.count());
        Assert.assertEquals((long)49152L, (long)cache.size());
        cache.close();
    }

    @Test
    public void testEmptyCache() {
        WriteCache cache = new WriteCache(allocator, 0x100000L, 16384);
        Assert.assertEquals((long)0L, (long)cache.count());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertTrue((boolean)cache.isEmpty());
        AtomicLong foundEntries = new AtomicLong();
        cache.forEach((ledgerId, entryId, entry) -> foundEntries.incrementAndGet());
        Assert.assertEquals((long)0L, (long)foundEntries.get());
        cache.close();
    }

    @Test
    public void testMultipleWriters() throws Exception {
        WriteCache cache = new WriteCache(allocator, 0xA00000L, 16384);
        ExecutorService executor = Executors.newCachedThreadPool();
        int numThreads = 10;
        int entriesPerThread = 10240 / numThreads;
        CyclicBarrier barrier = new CyclicBarrier(numThreads);
        CountDownLatch latch = new CountDownLatch(numThreads);
        int i = 0;
        while (i < numThreads) {
            int ledgerId2 = i++;
            executor.submit(() -> {
                try {
                    barrier.await();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(ie);
                }
                catch (BrokenBarrierException e) {
                    throw new RuntimeException(e);
                }
                ByteBuf entry = Unpooled.buffer((int)1024);
                entry.writerIndex(entry.capacity());
                for (int entryId = 0; entryId < entriesPerThread; ++entryId) {
                    Assert.assertTrue((boolean)cache.put((long)ledgerId2, (long)entryId, entry));
                }
                latch.countDown();
            });
        }
        latch.await();
        Assert.assertEquals((long)(cache.count() * 1024L), (long)cache.size());
        AtomicLong currentLedgerId = new AtomicLong(0L);
        AtomicLong currentEntryId = new AtomicLong(0L);
        cache.forEach((ledgerId, entryId, entry) -> {
            Assert.assertEquals((long)currentLedgerId.get(), (long)ledgerId);
            Assert.assertEquals((long)currentEntryId.get(), (long)entryId);
            if (currentEntryId.incrementAndGet() == (long)entriesPerThread) {
                currentLedgerId.incrementAndGet();
                currentEntryId.set(0L);
            }
        });
        cache.close();
        executor.shutdown();
    }

    @Test
    public void testLedgerDeletion() {
        WriteCache cache = new WriteCache(allocator, 0x100000L, 16384);
        ByteBuf entry = Unpooled.buffer((int)1024);
        entry.writerIndex(entry.capacity());
        for (long ledgerId2 = 0L; ledgerId2 < 10L; ++ledgerId2) {
            for (int entryId2 = 0; entryId2 < 10; ++entryId2) {
                cache.put(ledgerId2, (long)entryId2, entry);
            }
        }
        Assert.assertEquals((long)100L, (long)cache.count());
        Assert.assertEquals((long)102400L, (long)cache.size());
        cache.deleteLedger(5L);
        Assert.assertEquals((long)100L, (long)cache.count());
        Assert.assertEquals((long)102400L, (long)cache.size());
        AtomicLong currentLedgerId = new AtomicLong(0L);
        AtomicLong currentEntryId = new AtomicLong(0L);
        cache.forEach((ledgerId, entryId, e) -> {
            Assert.assertEquals((long)currentLedgerId.get(), (long)ledgerId);
            Assert.assertEquals((long)currentEntryId.get(), (long)entryId);
            if (currentEntryId.incrementAndGet() == 10L) {
                currentLedgerId.incrementAndGet();
                currentEntryId.set(0L);
                if (currentLedgerId.get() == 5L) {
                    currentLedgerId.incrementAndGet();
                }
            }
        });
        cache.close();
    }

    @Test
    public void testWriteReadsInMultipleSegments() {
        int i;
        WriteCache cache = new WriteCache(allocator, 4096L, 128);
        for (i = 0; i < 48; ++i) {
            boolean inserted = cache.put(1L, (long)i, Unpooled.wrappedBuffer((byte[])("test-" + i).getBytes()));
            Assert.assertTrue((boolean)inserted);
        }
        Assert.assertEquals((long)48L, (long)cache.count());
        for (i = 0; i < 48; ++i) {
            ByteBuf b = cache.get(1L, (long)i);
            Assert.assertEquals((Object)("test-" + i), (Object)b.toString(Charset.forName("UTF-8")));
        }
        cache.close();
    }
}

