/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Charsets;
import com.google.common.net.InetAddresses;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.UnderreplicatedLedger;
import org.apache.bookkeeper.meta.ZkLedgerUnderreplicationManager;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.commons.io.FileUtils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperAdminTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperAdminTest.class);
    private BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static final String PASSWORD = "testPasswd";
    private static final int numOfBookies = 2;
    private final int lostBookieRecoveryDelayInitValue = 1800;

    public BookKeeperAdminTest() {
        super(2, 480);
        this.baseConf.setLostBookieRecoveryDelay(1800);
        this.baseConf.setOpenLedgerRereplicationGracePeriod(String.valueOf(30000));
        this.setAutoRecoveryEnabled(true);
    }

    @Test
    public void testLostBookieRecoveryDelayValue() throws Exception {
        try (BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());){
            Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)1800L, (long)bkAdmin.getLostBookieRecoveryDelay());
            int newLostBookieRecoveryDelayValue = 2400;
            bkAdmin.setLostBookieRecoveryDelay(newLostBookieRecoveryDelayValue);
            Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)newLostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
            newLostBookieRecoveryDelayValue = 3000;
            bkAdmin.setLostBookieRecoveryDelay(newLostBookieRecoveryDelayValue);
            Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)newLostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
            LOG.info("Test Done");
        }
    }

    @Test
    public void testTriggerAuditWithStoreSystemTimeAsLedgerUnderreplicatedMarkTime() throws Exception {
        this.testTriggerAudit(true);
    }

    @Test
    public void testTriggerAuditWithoutStoreSystemTimeAsLedgerUnderreplicatedMarkTime() throws Exception {
        this.testTriggerAudit(false);
    }

    public void testTriggerAudit(boolean storeSystemTimeAsLedgerUnderreplicatedMarkTime) throws Exception {
        ServerConfiguration thisServerConf = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        thisServerConf.setStoreSystemTimeAsLedgerUnderreplicatedMarkTime(storeSystemTimeAsLedgerUnderreplicatedMarkTime);
        this.restartBookies(thisServerConf);
        ClientConfiguration thisClientConf = new ClientConfiguration((AbstractConfiguration)this.baseClientConf);
        thisClientConf.setStoreSystemTimeAsLedgerUnderreplicatedMarkTime(storeSystemTimeAsLedgerUnderreplicatedMarkTime);
        long testStartSystime = System.currentTimeMillis();
        ZkLedgerUnderreplicationManager urLedgerMgr = new ZkLedgerUnderreplicationManager((AbstractConfiguration)thisClientConf, this.zkc);
        BookKeeperAdmin bkAdmin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        int lostBookieRecoveryDelayValue = bkAdmin.getLostBookieRecoveryDelay();
        urLedgerMgr.disableLedgerReplication();
        try {
            bkAdmin.triggerAudit();
            Assert.fail((String)"Trigger Audit should have failed because LedgerReplication is disabled");
        }
        catch (ReplicationException.UnavailableException unavailableException) {
            // empty catch block
        }
        Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)lostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
        urLedgerMgr.enableLedgerReplication();
        bkAdmin.triggerAudit();
        Assert.assertEquals((String)"LostBookieRecoveryDelay", (long)lostBookieRecoveryDelayValue, (long)bkAdmin.getLostBookieRecoveryDelay());
        long ledgerId = 1L;
        LedgerHandle ledgerHandle = this.bkc.createLedgerAdv(ledgerId, this.numBookies, this.numBookies, this.numBookies, this.digestType, PASSWORD.getBytes(), null);
        ledgerHandle.addEntry(0L, "data".getBytes());
        ledgerHandle.close();
        BookieServer bookieToKill = (BookieServer)this.bs.get(1);
        this.killBookie(1);
        bkAdmin.triggerAudit();
        Thread.sleep(500L);
        Iterator underreplicatedLedgerItr = urLedgerMgr.listLedgersToRereplicate(null);
        Assert.assertTrue((String)"There are supposed to be underreplicatedledgers", (boolean)underreplicatedLedgerItr.hasNext());
        UnderreplicatedLedger underreplicatedLedger = (UnderreplicatedLedger)underreplicatedLedgerItr.next();
        Assert.assertEquals((String)"Underreplicated ledgerId", (long)ledgerId, (long)underreplicatedLedger.getLedgerId());
        Assert.assertTrue((String)("Missingreplica of Underreplicated ledgerId should contain " + bookieToKill.getLocalAddress()), (boolean)underreplicatedLedger.getReplicaList().contains(bookieToKill.getLocalAddress().toString()));
        if (storeSystemTimeAsLedgerUnderreplicatedMarkTime) {
            long ctimeOfURL = underreplicatedLedger.getCtime();
            Assert.assertTrue((String)"ctime of underreplicated ledger should be greater than test starttime", (ctimeOfURL > testStartSystime && ctimeOfURL < System.currentTimeMillis() ? 1 : 0) != 0);
        } else {
            Assert.assertEquals((String)"ctime of underreplicated ledger should not be set", (long)-1L, (long)underreplicatedLedger.getCtime());
        }
        bkAdmin.close();
    }

    @Test
    public void testBookieInit() throws Exception {
        File[] ledgerDirs;
        File[] journalDirs;
        int bookieindex = 0;
        ServerConfiguration confOfExistingBookie = (ServerConfiguration)this.bsConfs.get(bookieindex);
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since bookie is still running with that configuration", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        this.killBookie(bookieindex);
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since previous bookie is not formatted yet", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        for (File journalDir : journalDirs = confOfExistingBookie.getJournalDirs()) {
            FileUtils.deleteDirectory((File)journalDir);
        }
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since previous bookie is not formatted yet completely", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        for (File ledgerDir : ledgerDirs = confOfExistingBookie.getLedgerDirs()) {
            FileUtils.deleteDirectory((File)ledgerDir);
        }
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since previous bookie is not formatted yet completely", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        File[] indexDirs = confOfExistingBookie.getIndexDirs();
        if (indexDirs != null) {
            for (File indexDir : indexDirs) {
                FileUtils.deleteDirectory((File)indexDir);
            }
        }
        Assert.assertFalse((String)"initBookie shouldn't have succeeded, since cookie in ZK is not deleted yet", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
        String bookieId = Bookie.getBookieAddress((ServerConfiguration)confOfExistingBookie).toString();
        String bookieCookiePath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)confOfExistingBookie) + "/" + "cookies" + "/" + bookieId;
        this.zkc.delete(bookieCookiePath, -1);
        Assert.assertTrue((String)"initBookie shouldn't succeeded", (boolean)BookKeeperAdmin.initBookie((ServerConfiguration)confOfExistingBookie));
    }

    @Test
    public void testInitNewCluster() throws Exception {
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        String ledgersRootPath = "/testledgers";
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        Assert.assertTrue((String)"New cluster should be initialized successfully", (boolean)BookKeeperAdmin.initNewCluster((ServerConfiguration)newConfig));
        Assert.assertTrue((String)("Cluster rootpath should have been created successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) != null ? 1 : 0) != 0);
        String availableBookiesPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available";
        Assert.assertTrue((String)("AvailableBookiesPath should have been created successfully " + availableBookiesPath), (this.zkc.exists(availableBookiesPath, false) != null ? 1 : 0) != 0);
        String readonlyBookiesPath = availableBookiesPath + "/" + "readonly";
        Assert.assertTrue((String)("ReadonlyBookiesPath should have been created successfully " + readonlyBookiesPath), (this.zkc.exists(readonlyBookiesPath, false) != null ? 1 : 0) != 0);
        String instanceIdPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID";
        Assert.assertTrue((String)("InstanceId node should have been created successfully" + instanceIdPath), (this.zkc.exists(instanceIdPath, false) != null ? 1 : 0) != 0);
        String ledgersLayout = ledgersRootPath + "/" + "LAYOUT";
        Assert.assertTrue((String)("Layout node should have been created successfully" + ledgersLayout), (this.zkc.exists(ledgersLayout, false) != null ? 1 : 0) != 0);
        int numOfBookies = 3;
        Random rand = new Random();
        for (int i = 0; i < numOfBookies; ++i) {
            String ipString = InetAddresses.fromInteger((int)rand.nextInt()).getHostAddress();
            String regPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available" + "/" + ipString + ":3181";
            this.zkc.create(regPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        BookKeeper bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)newConfig));
        LedgerHandle lh = bk.createLedger(numOfBookies, numOfBookies, numOfBookies, BookKeeper.DigestType.MAC, new byte[0]);
        bk.deleteLedger(lh.ledgerId);
        bk.close();
    }

    @Test
    public void testNukeExistingClusterWithForceOption() throws Exception {
        String ledgersRootPath = "/testledgers";
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        ArrayList<String> bookiesRegPaths = new ArrayList<String>();
        this.initiateNewClusterAndCreateLedgers(newConfig, bookiesRegPaths);
        for (int i = 0; i < bookiesRegPaths.size(); ++i) {
            this.zkc.delete((String)bookiesRegPaths.get(i), -1);
        }
        Assert.assertTrue((String)"New cluster should be nuked successfully", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, null, (boolean)true));
        Assert.assertTrue((String)("Cluster rootpath should have been deleted successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) == null ? 1 : 0) != 0);
    }

    @Test
    public void testNukeExistingClusterWithInstanceId() throws Exception {
        String ledgersRootPath = "/testledgers";
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        ArrayList<String> bookiesRegPaths = new ArrayList<String>();
        this.initiateNewClusterAndCreateLedgers(newConfig, bookiesRegPaths);
        for (int i = 0; i < bookiesRegPaths.size(); ++i) {
            this.zkc.delete((String)bookiesRegPaths.get(i), -1);
        }
        byte[] data = this.zkc.getData(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID", false, null);
        String readInstanceId = new String(data, Charsets.UTF_8);
        Assert.assertTrue((String)"New cluster should be nuked successfully", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        Assert.assertTrue((String)("Cluster rootpath should have been deleted successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) == null ? 1 : 0) != 0);
    }

    @Test
    public void tryNukingExistingClustersWithInvalidParams() throws Exception {
        String ledgersRootPath = "/testledgers";
        ServerConfiguration newConfig = new ServerConfiguration((AbstractConfiguration)this.baseConf);
        newConfig.setMetadataServiceUri(this.newMetadataServiceUri(ledgersRootPath));
        ArrayList<String> bookiesRegPaths = new ArrayList<String>();
        this.initiateNewClusterAndCreateLedgers(newConfig, bookiesRegPaths);
        BookKeeper bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)newConfig));
        long ledgerId = 23456789L;
        LedgerHandle lh = bk.createLedgerAdv(ledgerId, 1, 1, 1, BookKeeper.DigestType.MAC, new byte[0], null);
        lh.close();
        byte[] data = this.zkc.getData(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID", false, null);
        String readInstanceId = new String(data, Charsets.UTF_8);
        String ipString = InetAddresses.fromInteger((int)new Random().nextInt()).getHostAddress();
        String roBookieRegPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available" + "/" + "readonly" + "/" + ipString + ":3181";
        this.zkc.create(roBookieRegPath, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        Assert.assertFalse((String)"Cluster should'nt be nuked since instanceid is not provided and force option is not set", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, null, (boolean)false));
        Assert.assertFalse((String)"Cluster should'nt be nuked since incorrect instanceid is provided", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)"incorrectinstanceid", (boolean)false));
        Assert.assertFalse((String)"Cluster should'nt be nuked since bookies are still registered", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        for (int i = 0; i < bookiesRegPaths.size(); ++i) {
            this.zkc.delete((String)bookiesRegPaths.get(i), -1);
        }
        Assert.assertFalse((String)"Cluster should'nt be nuked since ro bookie is still registered", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        Assert.assertTrue((String)("Cluster rootpath should be existing " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) != null ? 1 : 0) != 0);
        String availableBookiesPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available";
        Assert.assertTrue((String)("AvailableBookiesPath should be existing " + availableBookiesPath), (this.zkc.exists(availableBookiesPath, false) != null ? 1 : 0) != 0);
        String instanceIdPath = ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "INSTANCEID";
        Assert.assertTrue((String)("InstanceId node should be existing" + instanceIdPath), (this.zkc.exists(instanceIdPath, false) != null ? 1 : 0) != 0);
        String ledgersLayout = ledgersRootPath + "/" + "LAYOUT";
        Assert.assertTrue((String)("Layout node should be existing" + ledgersLayout), (this.zkc.exists(ledgersLayout, false) != null ? 1 : 0) != 0);
        lh = bk.openLedgerNoRecovery(ledgerId, BookKeeper.DigestType.MAC, new byte[0]);
        lh.close();
        bk.close();
        this.zkc.delete(roBookieRegPath, -1);
        Assert.assertTrue((String)"Cluster should be nuked since no bookie is registered", (boolean)BookKeeperAdmin.nukeExistingCluster((ServerConfiguration)newConfig, (String)ledgersRootPath, (String)readInstanceId, (boolean)false));
        Assert.assertTrue((String)("Cluster rootpath should have been deleted successfully " + ledgersRootPath), (this.zkc.exists(ledgersRootPath, false) == null ? 1 : 0) != 0);
    }

    void initiateNewClusterAndCreateLedgers(ServerConfiguration newConfig, List<String> bookiesRegPaths) throws Exception {
        Assert.assertTrue((String)"New cluster should be initialized successfully", (boolean)BookKeeperAdmin.initNewCluster((ServerConfiguration)newConfig));
        int numberOfBookies = 3;
        Random rand = new Random();
        for (int i = 0; i < numberOfBookies; ++i) {
            String ipString = InetAddresses.fromInteger((int)rand.nextInt()).getHostAddress();
            bookiesRegPaths.add(ZKMetadataDriverBase.resolveZkLedgersRootPath((AbstractConfiguration)newConfig) + "/" + "available" + "/" + ipString + ":3181");
            this.zkc.create(bookiesRegPaths.get(i), new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
        }
        BookKeeper bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)newConfig));
        int numOfLedgers = 5;
        for (int i = 0; i < numOfLedgers; ++i) {
            LedgerHandle lh = bk.createLedger(numberOfBookies, numberOfBookies, numberOfBookies, BookKeeper.DigestType.MAC, new byte[0]);
            lh.close();
        }
        bk.close();
    }
}

