/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestCallbacks;
import org.apache.bookkeeper.zookeeper.ZooKeeperWatcherBase;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperClientZKSessionExpiry
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperClientZKSessionExpiry.class);

    public BookKeeperClientZKSessionExpiry() {
        super(4);
    }

    @Test
    public void testSessionLossWhileWriting() throws Exception {
        Thread expiryThread = new Thread(){

            @Override
            public void run() {
                block4: while (true) {
                    try {
                        while (true) {
                            Thread.sleep(5000L);
                            long sessionId = BookKeeperClientZKSessionExpiry.this.bkc.getZkHandle().getSessionId();
                            byte[] sessionPasswd = BookKeeperClientZKSessionExpiry.this.bkc.getZkHandle().getSessionPasswd();
                            try {
                                ZooKeeperWatcherBase watcher = new ZooKeeperWatcherBase(10000);
                                ZooKeeper zk = new ZooKeeper(BookKeeperClientZKSessionExpiry.this.zkUtil.getZooKeeperConnectString(), 10000, (Watcher)watcher, sessionId, sessionPasswd);
                                zk.close();
                                continue block4;
                            }
                            catch (Exception e) {
                                LOG.info("Error killing session", (Throwable)e);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        };
        expiryThread.start();
        for (int i = 0; i < 3; ++i) {
            LedgerHandle lh = this.bkc.createLedger(3, 3, 2, BookKeeper.DigestType.MAC, "foobar".getBytes());
            for (int j = 0; j < 100; ++j) {
                lh.asyncAddEntry("foobar".getBytes(), (AsyncCallback.AddCallback)new TestCallbacks.AddCallbackFuture(j), null);
            }
            this.startNewBookie();
            this.killBookie(0);
            lh.addEntry("lastEntry".getBytes());
            lh.close();
        }
    }
}

