/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.SortedLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.TestUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExplicitLacTest
extends BookKeeperClusterTestCase {
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public ExplicitLacTest(Class<? extends LedgerStorage> storageClass) {
        super(1);
        this.baseConf.setLedgerStorageClass(storageClass.getName());
        this.baseConf.setJournalFormatVersionToWrite(6);
        this.baseConf.setFileInfoFormatVersionToWrite(1);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({InterleavedLedgerStorage.class}, {SortedLedgerStorage.class}, {DbLedgerStorage.class});
    }

    @Test
    public void testReadHandleWithNoExplicitLAC() throws Exception {
        ClientConfiguration confWithNoExplicitLAC = new ClientConfiguration();
        confWithNoExplicitLAC.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        confWithNoExplicitLAC.setExplictLacInterval(0);
        BookKeeper bkcWithNoExplicitLAC = new BookKeeper(confWithNoExplicitLAC);
        LedgerHandle wlh = bkcWithNoExplicitLAC.createLedger(1, 1, 1, this.digestType, "testPasswd".getBytes());
        long ledgerId = wlh.getId();
        int numOfEntries = 5;
        for (int i = 0; i < numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        LedgerHandle rlh = bkcWithNoExplicitLAC.openLedgerNoRecovery(ledgerId, this.digestType, "testPasswd".getBytes());
        Assert.assertTrue((String)("Expected LAC of rlh: " + (numOfEntries - 2) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(numOfEntries - 2) ? 1 : 0) != 0);
        Enumeration entries = rlh.readEntries(0L, (long)(numOfEntries - 2));
        int entryId = 0;
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            String entryString = new String(entry.getEntry());
            Assert.assertTrue((String)("Expected entry String: " + "foobar" + entryId + " actual entry String: " + entryString), (boolean)entryString.equals("foobar" + entryId));
            ++entryId;
        }
        for (int i = numOfEntries; i < 2 * numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        TestUtils.waitUntilLacUpdated((ReadHandle)rlh, numOfEntries - 2);
        Assert.assertTrue((String)("Expected LAC of wlh: " + (2 * numOfEntries - 1) + " actual LAC of rlh: " + wlh.getLastAddConfirmed()), (wlh.getLastAddConfirmed() == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected LAC of rlh: " + (numOfEntries - 2) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(numOfEntries - 2) ? 1 : 0) != 0);
        long explicitlac = rlh.readExplicitLastConfirmed();
        Assert.assertTrue((String)("Expected Explicit LAC of rlh: " + (numOfEntries - 2) + " actual ExplicitLAC of rlh: " + explicitlac), (explicitlac == (long)(2 * numOfEntries - 2) ? 1 : 0) != 0);
        try {
            rlh.readEntries((long)(2 * numOfEntries - 1), (long)(2 * numOfEntries - 1));
            Assert.fail((String)("rlh readEntries beyond " + (2 * numOfEntries - 2) + " should fail with ReadException"));
        }
        catch (BKException.BKReadException bKReadException) {
            // empty catch block
        }
        rlh.close();
        wlh.close();
        bkcWithNoExplicitLAC.close();
    }

    @Test
    public void testExplicitLACIsPersisted() throws Exception {
        Assume.assumeTrue((!this.baseConf.getLedgerStorageClass().equals(DbLedgerStorage.class.getName()) ? 1 : 0) != 0);
        ClientConfiguration confWithNoExplicitLAC = new ClientConfiguration();
        confWithNoExplicitLAC.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        long explictLacInterval = 100L;
        confWithNoExplicitLAC.setExplictLacInterval(50);
        BookKeeper bkcWithExplicitLAC = new BookKeeper(confWithNoExplicitLAC);
        LedgerHandle wlh = bkcWithExplicitLAC.createLedger(1, 1, 1, this.digestType, "testPasswd".getBytes());
        long ledgerId = wlh.getId();
        int numOfEntries = 5;
        for (int i = 0; i < numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        LedgerHandle rlh = bkcWithExplicitLAC.openLedgerNoRecovery(ledgerId, this.digestType, "testPasswd".getBytes());
        Assert.assertEquals((String)"LAC of rlh", (long)((long)numOfEntries - 2L), (long)rlh.getLastAddConfirmed());
        for (int i = numOfEntries; i < 2 * numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        Assert.assertEquals((String)"LAC of wlh", (long)(2 * numOfEntries - 1), (long)wlh.getLastAddConfirmed());
        Assert.assertEquals((String)"LAC of rlh", (long)((long)numOfEntries - 2L), (long)rlh.getLastAddConfirmed());
        Assert.assertEquals((String)"Read LAC of rlh", (long)(2 * numOfEntries - 2), (long)rlh.readLastAddConfirmed());
        Assert.assertEquals((String)"Read explicit LAC of rlh", (long)(2 * numOfEntries - 2), (long)rlh.readExplicitLastConfirmed());
        long readExplicitLastConfirmed = TestUtils.waitUntilExplicitLacUpdated(rlh, 2 * numOfEntries - 1);
        Assert.assertEquals((String)"Read explicit LAC of rlh after wait for explicitlacflush", (long)(2 * numOfEntries - 1), (long)readExplicitLastConfirmed);
        this.restartBookies();
        LedgerHandle rlh2 = bkcWithExplicitLAC.openLedgerNoRecovery(ledgerId, this.digestType, "testPasswd".getBytes());
        Assert.assertEquals((String)"Read explicit LAC of rlh2 after bookies restart", (long)(2 * numOfEntries - 1), (long)rlh2.readExplicitLastConfirmed());
        bkcWithExplicitLAC.close();
    }

    @Test
    public void testReadHandleWithExplicitLAC() throws Exception {
        ClientConfiguration confWithExplicitLAC = new ClientConfiguration();
        confWithExplicitLAC.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int explicitLacIntervalMillis = 1000;
        confWithExplicitLAC.setExplictLacInterval(explicitLacIntervalMillis);
        BookKeeper bkcWithExplicitLAC = new BookKeeper(confWithExplicitLAC);
        LedgerHandle wlh = bkcWithExplicitLAC.createLedger(1, 1, 1, this.digestType, "testPasswd".getBytes());
        long ledgerId = wlh.getId();
        int numOfEntries = 5;
        for (int i = 0; i < numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        LedgerHandle rlh = bkcWithExplicitLAC.openLedgerNoRecovery(ledgerId, this.digestType, "testPasswd".getBytes());
        Assert.assertTrue((String)("Expected LAC of rlh: " + (numOfEntries - 2) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(numOfEntries - 2) ? 1 : 0) != 0);
        for (int i = numOfEntries; i < 2 * numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        TestUtils.waitUntilLacUpdated((ReadHandle)rlh, 2 * numOfEntries - 2);
        Assert.assertTrue((String)("Expected LAC of wlh: " + (2 * numOfEntries - 1) + " actual LAC of wlh: " + wlh.getLastAddConfirmed()), (wlh.getLastAddConfirmed() == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected LAC of rlh: " + (2 * numOfEntries - 2) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(2 * numOfEntries - 2) ? 1 : 0) != 0);
        long explicitlac = TestUtils.waitUntilExplicitLacUpdated(rlh, 2 * numOfEntries - 1);
        Assert.assertTrue((String)("Expected Explicit LAC of rlh: " + (2 * numOfEntries - 1) + " actual ExplicitLAC of rlh: " + explicitlac), (explicitlac == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected LAC of rlh: " + (2 * numOfEntries - 1) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        Enumeration entries = rlh.readEntries((long)numOfEntries, (long)(2 * numOfEntries - 1));
        int entryId = numOfEntries;
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            String entryString = new String(entry.getEntry());
            Assert.assertTrue((String)("Expected entry String: " + "foobar" + entryId + " actual entry String: " + entryString), (boolean)entryString.equals("foobar" + entryId));
            ++entryId;
        }
        rlh.close();
        wlh.close();
        bkcWithExplicitLAC.close();
    }

    @Test
    public void testReadHandleWithExplicitLACAndDeferredSync() throws Exception {
        ClientConfiguration confWithExplicitLAC = new ClientConfiguration();
        confWithExplicitLAC.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        int explicitLacIntervalMillis = 1000;
        confWithExplicitLAC.setExplictLacInterval(explicitLacIntervalMillis);
        BookKeeper bkcWithExplicitLAC = new BookKeeper(confWithExplicitLAC);
        LedgerHandle wlh = (LedgerHandle)bkcWithExplicitLAC.newCreateLedgerOp().withEnsembleSize(1).withWriteQuorumSize(1).withAckQuorumSize(1).withWriteFlags(new WriteFlag[]{WriteFlag.DEFERRED_SYNC}).withDigestType(this.digestType.toApiDigestType()).withPassword("testPasswd".getBytes()).execute().get();
        long ledgerId = wlh.getId();
        int numOfEntries = 5;
        for (int i = 0; i < numOfEntries; ++i) {
            wlh.force().get();
            wlh.addEntry(("foobar" + i).getBytes());
        }
        LedgerHandle rlh = bkcWithExplicitLAC.openLedgerNoRecovery(ledgerId, this.digestType, "testPasswd".getBytes());
        Assert.assertTrue((String)("Expected LAC of rlh: " + (numOfEntries - 2) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(numOfEntries - 2) ? 1 : 0) != 0);
        for (int i = numOfEntries; i < 2 * numOfEntries; ++i) {
            wlh.addEntry(("foobar" + i).getBytes());
        }
        wlh.force().get();
        TestUtils.waitUntilExplicitLacUpdated(rlh, 2 * numOfEntries - 2);
        TestUtils.waitUntilLacUpdated((ReadHandle)rlh, 2 * numOfEntries - 2);
        Assert.assertTrue((String)("Expected LAC of wlh: " + (2 * numOfEntries - 1) + " actual LAC of wlh: " + wlh.getLastAddConfirmed()), (wlh.getLastAddConfirmed() == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        long explicitlac = TestUtils.waitUntilExplicitLacUpdated(rlh, 2 * numOfEntries - 1);
        Assert.assertTrue((String)("Expected Explicit LAC of rlh: " + (2 * numOfEntries - 1) + " actual ExplicitLAC of rlh: " + explicitlac), (explicitlac == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        Assert.assertTrue((String)("Expected LAC of rlh: " + (2 * numOfEntries - 1) + " actual LAC of rlh: " + rlh.getLastAddConfirmed()), (rlh.getLastAddConfirmed() == (long)(2 * numOfEntries - 1) ? 1 : 0) != 0);
        Enumeration entries = rlh.readEntries((long)numOfEntries, (long)(2 * numOfEntries - 1));
        int entryId = numOfEntries;
        while (entries.hasMoreElements()) {
            LedgerEntry entry = (LedgerEntry)entries.nextElement();
            String entryString = new String(entry.getEntry());
            Assert.assertTrue((String)("Expected entry String: " + "foobar" + entryId + " actual entry String: " + entryString), (boolean)entryString.equals("foobar" + entryId));
            ++entryId;
        }
        rlh.close();
        wlh.close();
        bkcWithExplicitLAC.close();
    }
}

