/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.ClientContext;
import org.apache.bookkeeper.client.ClientUtil;
import org.apache.bookkeeper.client.LedgerMetadataBuilder;
import org.apache.bookkeeper.client.MockClientContext;
import org.apache.bookkeeper.client.ReadOnlyLedgerHandle;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.versioning.Versioned;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerRecovery2Test {
    private static final Logger log = LoggerFactory.getLogger(LedgerRecovery2Test.class);
    private static final byte[] PASSWD = "foobar".getBytes();
    private static final BookieSocketAddress b1 = new BookieSocketAddress("b1", 3181);
    private static final BookieSocketAddress b2 = new BookieSocketAddress("b2", 3181);
    private static final BookieSocketAddress b3 = new BookieSocketAddress("b3", 3181);
    private static final BookieSocketAddress b4 = new BookieSocketAddress("b4", 3181);
    private static final BookieSocketAddress b5 = new BookieSocketAddress("b5", 3181);

    private static Versioned<LedgerMetadata> setupLedger(ClientContext clientCtx, long ledgerId, List<BookieSocketAddress> bookies) throws Exception {
        LedgerMetadata md = LedgerMetadataBuilder.create().withPassword(PASSWD).withDigestType(DigestType.CRC32C).newEnsembleEntry(0L, bookies).build();
        return (Versioned)clientCtx.getLedgerManager().createLedgerMetadata(1L, md).get();
    }

    @Test
    public void testCantRecoverAllDown() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().errorBookies(b1, b2, b3);
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        try {
            BookkeeperInternalCallbacks.GenericCallbackFuture promise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
            lh.recover((BookkeeperInternalCallbacks.GenericCallback)promise, null, false);
            promise.get();
            Assert.fail((String)"Recovery shouldn't have been able to complete");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(BKException.BKReadException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testCanReadLacButCantWrite() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> FutureUtils.exception((Throwable)new BKException.BKWriteException()));
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        try {
            BookkeeperInternalCallbacks.GenericCallbackFuture promise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
            lh.recover((BookkeeperInternalCallbacks.GenericCallback)promise, null, false);
            promise.get();
            Assert.fail((String)"Recovery shouldn't have been able to complete");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(BKException.BKNotEnoughBookiesException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testMetadataClosedDuringRecovery() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        CompletableFuture writingBack = new CompletableFuture();
        CompletableFuture<Object> blocker = new CompletableFuture<Object>();
        clientCtx.getMockBookieClient().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            writingBack.complete(null);
            return blocker;
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        writingBack.get(10L, TimeUnit.SECONDS);
        ClientUtil.transformMetadata(clientCtx, 1L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).withClosedState().withLastEntryId(-1L).withLength(0L).build());
        blocker.complete(null);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)-1L);
        Assert.assertEquals((long)lh.getLength(), (long)0L);
    }

    @Test
    public void testNewEnsembleAddedDuringRecovery() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        CompletableFuture writingBack = new CompletableFuture();
        CompletableFuture<Object> blocker = new CompletableFuture<Object>();
        CompletableFuture failing = new CompletableFuture();
        clientCtx.getMockBookieClient().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            writingBack.complete(null);
            if (bookie.equals((Object)b3)) {
                return failing;
            }
            return blocker;
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        writingBack.get(10L, TimeUnit.SECONDS);
        ClientUtil.transformMetadata(clientCtx, 1L, metadata -> LedgerMetadataBuilder.from((LedgerMetadata)metadata).newEnsembleEntry(1L, (List)Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b4})).build());
        failing.completeExceptionally(new BKException.BKWriteException());
        blocker.complete(null);
        try {
            recoveryPromise.get();
            Assert.fail((String)"Should fail on the update");
        }
        catch (ExecutionException ee) {
            Assert.assertEquals(BKException.BKUnexpectedConditionException.class, ee.getCause().getClass());
        }
    }

    @Test
    public void testRecoveryBookieFailedAtStart() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        CompletableFuture writingBack = new CompletableFuture();
        CompletableFuture blocker = new CompletableFuture();
        CompletableFuture failing = new CompletableFuture();
        clientCtx.getMockBookieClient().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().errorBookies(b2);
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b4, b3}));
    }

    @Test
    public void testRecoveryOneBookieFailsDuring() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().seedEntries(b3, 1L, 1L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b2) && entryId == 1L) {
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            return FutureUtils.value(null);
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)2L);
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(0L), (Object)Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        Assert.assertEquals(lh.getLedgerMetadata().getAllEnsembles().get(1L), (Object)Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b4, b3}));
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)1L);
    }

    @Test
    public void testRecoveryTwoBookiesFailOnSameEntry() throws Exception {
        MockClientContext clientCtx = MockClientContext.create();
        clientCtx.getMockRegistrationClient().addBookies(b4, b5).get();
        Versioned<LedgerMetadata> md = LedgerRecovery2Test.setupLedger(clientCtx, 1L, Lists.newArrayList((Object[])new BookieSocketAddress[]{b1, b2, b3}));
        clientCtx.getMockBookieClient().seedEntries(b1, 1L, 0L, -1L);
        clientCtx.getMockBookieClient().setPreWriteHook((bookie, ledgerId, entryId) -> {
            if (bookie.equals((Object)b1) || bookie.equals((Object)b2)) {
                return FutureUtils.exception((Throwable)new BKException.BKWriteException());
            }
            return FutureUtils.value(null);
        });
        ReadOnlyLedgerHandle lh = new ReadOnlyLedgerHandle((ClientContext)clientCtx, 1L, md, BookKeeper.DigestType.CRC32C, PASSWD, false);
        BookkeeperInternalCallbacks.GenericCallbackFuture recoveryPromise = new BookkeeperInternalCallbacks.GenericCallbackFuture();
        lh.recover((BookkeeperInternalCallbacks.GenericCallback)recoveryPromise, null, false);
        recoveryPromise.get();
        Assert.assertEquals((long)lh.getLedgerMetadata().getAllEnsembles().size(), (long)1L);
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b3));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b4));
        Assert.assertTrue((boolean)((List)lh.getLedgerMetadata().getAllEnsembles().get(0L)).contains(b5));
        Assert.assertEquals((long)lh.getLastAddConfirmed(), (long)0L);
    }
}

