/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFencing
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(TestFencing.class);
    private final BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;
    private static int threadCount = 0;

    public TestFencing() {
        super(10);
    }

    @Test
    public void testBasicFencing() throws Exception {
        LedgerHandle writelh = null;
        writelh = this.bkc.createLedger(this.digestType, "password".getBytes());
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        LedgerHandle readlh = this.bkc.openLedger(writelh.getId(), this.digestType, "password".getBytes());
        try {
            writelh.addEntry(tmp.getBytes());
            LOG.error("Should have thrown an exception");
            Assert.fail((String)"Should have thrown an exception when trying to write");
        }
        catch (BKException.BKLedgerFencedException bKLedgerFencedException) {
            // empty catch block
        }
        Assert.assertTrue((String)("Has not recovered correctly: " + readlh.getLastAddConfirmed() + " original " + writelh.getLastAddConfirmed()), (readlh.getLastAddConfirmed() == writelh.getLastAddConfirmed() ? 1 : 0) != 0);
    }

    @Test
    public void testManyOpenParallel() throws Exception {
        final LedgerHandle writelh = this.bkc.createLedger(this.digestType, "".getBytes());
        int numRecovery = 10;
        String tmp = "BookKeeper is cool!";
        final CountDownLatch latch = new CountDownLatch(10);
        Thread writethread = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        writelh.addEntry("BookKeeper is cool!".getBytes());
                        latch.countDown();
                    }
                }
                catch (Exception e) {
                    LOG.info("Exception adding entry", (Throwable)e);
                    return;
                }
            }
        };
        writethread.start();
        CyclicBarrier barrier = new CyclicBarrier(11);
        LedgerOpenThread[] threads = new LedgerOpenThread[10];
        for (int i = 0; i < 10; ++i) {
            threads[i] = new LedgerOpenThread(i, this.digestType, writelh.getId(), barrier);
            threads[i].start();
        }
        latch.await();
        barrier.await();
        writethread.join();
        long lastConfirmed = writelh.getLastAddConfirmed();
        for (int i = 0; i < 10; ++i) {
            threads[i].join();
            Assert.assertTrue((String)"Added confirmed is incorrect", (lastConfirmed <= threads[i].getLastConfirmedEntry() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoRecoveryOpen() throws Exception {
        LedgerHandle writelh = null;
        writelh = this.bkc.createLedger(this.digestType, "".getBytes());
        String tmp = "BookKeeper is cool!";
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        LedgerHandle readlh = this.bkc.openLedgerNoRecovery(writelh.getId(), this.digestType, "".getBytes());
        long numReadable = readlh.getLastAddConfirmed();
        LOG.error("numRead " + numReadable);
        readlh.readEntries(1L, numReadable);
        writelh.addEntry(tmp.getBytes());
        try {
            readlh.readEntries(numReadable + 1L, numReadable + 1L);
            Assert.fail((String)"Shouldn't have been able to read this far");
        }
        catch (BKException.BKReadException bKReadException) {
            // empty catch block
        }
        writelh.addEntry(tmp.getBytes());
        long numReadable2 = readlh.getLastAddConfirmed();
        Assert.assertEquals((String)"Number of readable entries hasn't changed", (long)numReadable2, (long)numReadable);
        readlh.close();
        writelh.addEntry(tmp.getBytes());
        writelh.close();
    }

    @Test
    public void testFencingInteractionWithBookieRecovery() throws Exception {
        int i;
        System.setProperty("digestType", this.digestType.toString());
        System.setProperty("passwd", "testPasswd");
        BookKeeperAdmin admin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        LedgerHandle writelh = this.bkc.createLedger(this.digestType, "testPasswd".getBytes());
        String tmp = "Foobar";
        int numEntries = 10;
        for (int i2 = 0; i2 < 10; ++i2) {
            writelh.addEntry(tmp.getBytes());
        }
        BookieSocketAddress bookieToKill = (BookieSocketAddress)writelh.getLedgerMetadata().getEnsembleAt(10L).get(0);
        this.killBookie(bookieToKill);
        for (i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        admin.recoverBookieData(bookieToKill);
        for (i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        LedgerHandle readlh = this.bkc.openLedger(writelh.getId(), this.digestType, "testPasswd".getBytes());
        try {
            writelh.addEntry(tmp.getBytes());
            LOG.error("Should have thrown an exception");
            Assert.fail((String)"Should have thrown an exception when trying to write");
        }
        catch (BKException.BKLedgerFencedException bKLedgerFencedException) {
            // empty catch block
        }
        readlh.close();
        writelh.close();
    }

    @Test
    public void testFencingInteractionWithBookieRecovery2() throws Exception {
        System.setProperty("digestType", this.digestType.toString());
        System.setProperty("passwd", "testPasswd");
        BookKeeperAdmin admin = new BookKeeperAdmin(this.zkUtil.getZooKeeperConnectString());
        LedgerHandle writelh = this.bkc.createLedger(this.digestType, "testPasswd".getBytes());
        String tmp = "Foobar";
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        LedgerHandle readlh = this.bkc.openLedger(writelh.getId(), this.digestType, "testPasswd".getBytes());
        BookieSocketAddress bookieToKill = (BookieSocketAddress)writelh.getLedgerMetadata().getEnsembleAt(10L).get(0);
        this.killBookie(bookieToKill);
        admin.recoverBookieData(bookieToKill);
        try {
            writelh.addEntry(tmp.getBytes());
            LOG.error("Should have thrown an exception");
            Assert.fail((String)"Should have thrown an exception when trying to write");
        }
        catch (BKException.BKLedgerFencedException bKLedgerFencedException) {
            // empty catch block
        }
        readlh.close();
        writelh.close();
    }

    @Test
    public void testFencingWithHungBookie() throws Exception {
        LedgerHandle writelh = this.bkc.createLedger(this.digestType, "testPasswd".getBytes());
        String tmp = "Foobar";
        int numEntries = 10;
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        CountDownLatch sleepLatch = new CountDownLatch(1);
        this.sleepBookie((BookieSocketAddress)((List)writelh.getLedgerMetadata().getAllEnsembles().get(0L)).get(1), sleepLatch);
        LedgerHandle readlh = this.bkc.openLedger(writelh.getId(), this.digestType, "testPasswd".getBytes());
        try {
            writelh.addEntry(tmp.getBytes());
            LOG.error("Should have thrown an exception");
            Assert.fail((String)"Should have thrown an exception when trying to write");
        }
        catch (BKException.BKLedgerFencedException bKLedgerFencedException) {
            // empty catch block
        }
        sleepLatch.countDown();
        readlh.close();
        writelh.close();
    }

    @Test
    public void testFencingBadPassword() throws Exception {
        LedgerHandle writelh = null;
        writelh = this.bkc.createLedger(this.digestType, "password1".getBytes());
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        try {
            this.bkc.openLedger(writelh.getId(), this.digestType, "badPassword".getBytes());
            Assert.fail((String)"Should not have been able to open with a bad password");
        }
        catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            // empty catch block
        }
        writelh.addEntry(tmp.getBytes());
    }

    @Test
    public void testFencingAndRestartBookies() throws Exception {
        LedgerHandle writelh = null;
        writelh = this.bkc.createLedger(this.digestType, "password".getBytes());
        String tmp = "BookKeeper is cool!";
        for (int i = 0; i < 10; ++i) {
            writelh.addEntry(tmp.getBytes());
        }
        LedgerHandle readlh = this.bkc.openLedger(writelh.getId(), this.digestType, "password".getBytes());
        this.restartBookies();
        try {
            writelh.addEntry(tmp.getBytes());
            LOG.error("Should have thrown an exception");
            Assert.fail((String)"Should have thrown an exception when trying to write");
        }
        catch (BKException.BKLedgerFencedException bKLedgerFencedException) {
            // empty catch block
        }
        readlh.close();
    }

    class LedgerOpenThread
    extends Thread {
        private final long ledgerId;
        private long lastConfirmedEntry;
        private final int tid;
        private final BookKeeper.DigestType digestType;
        private final CyclicBarrier barrier;

        LedgerOpenThread(int tid, BookKeeper.DigestType digestType, long ledgerId, CyclicBarrier barrier) throws Exception {
            super("TestFencing-LedgerOpenThread-" + threadCount++);
            this.lastConfirmedEntry = 0L;
            this.tid = tid;
            this.ledgerId = ledgerId;
            this.digestType = digestType;
            this.barrier = barrier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Thread {} started.", (Object)this.tid);
            LedgerHandle lh = null;
            BookKeeper bk = null;
            try {
                this.barrier.await();
                while (true) {
                    try {
                        bk = new BookKeeper(new ClientConfiguration((AbstractConfiguration)TestFencing.this.baseClientConf), TestFencing.this.bkc.getZkHandle());
                        lh = bk.openLedger(this.ledgerId, this.digestType, "".getBytes());
                        this.lastConfirmedEntry = lh.getLastAddConfirmed();
                        lh.close();
                    }
                    catch (BKException.BKMetadataVersionException zke) {
                        LOG.info("Contention with someone else recovering");
                        continue;
                    }
                    catch (BKException.BKLedgerRecoveryException bkre) {
                        LOG.info("Contention with someone else recovering");
                        continue;
                    }
                    finally {
                        if (lh != null) {
                            lh.close();
                        }
                        if (bk == null) continue;
                        bk.close();
                        bk = null;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Exception occurred ", (Throwable)e);
            }
            LOG.info("Thread {} exiting, lastConfirmedEntry = {}", (Object)this.tid, (Object)this.lastConfirmedEntry);
        }

        long getLastConfirmedEntry() {
            return this.lastConfirmedEntry;
        }
    }
}

