/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import com.google.common.base.Charsets;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.MockBookKeeperTestCase;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.LastConfirmedAndEntry;
import org.apache.bookkeeper.client.api.LedgerEntries;
import org.apache.bookkeeper.client.api.LedgerEntry;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.util.LoggerOutput;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class BookKeeperApiTest
extends MockBookKeeperTestCase {
    private static final byte[] bigData = new byte[1024];
    private static final byte[] data = "foo".getBytes(Charsets.UTF_8);
    private static final byte[] password = "password".getBytes(Charsets.UTF_8);
    @Rule
    public LoggerOutput loggerOutput = new LoggerOutput();

    @Test
    public void testWriteHandle() throws Exception {
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).execute());){
            writer.append(ByteBuffer.wrap(data));
            Assert.assertEquals((long)0L, (long)writer.getLastAddPushed());
            writer.append(Unpooled.wrappedBuffer((byte[])data));
            Assert.assertEquals((long)1L, (long)writer.getLastAddPushed());
            long expectedEntryId = writer.append(ByteBuffer.wrap(data));
            Assert.assertEquals((long)expectedEntryId, (long)writer.getLastAddConfirmed());
            Assert.assertEquals((long)(3 * data.length), (long)writer.getLength());
        }
    }

    @Test
    public void testWriteAdvHandle() throws Exception {
        long ledgerId = 12345L;
        this.setNewGeneratedLedgerId(ledgerId);
        try (WriteAdvHandle writer = (WriteAdvHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).makeAdv().execute());){
            Assert.assertEquals((long)ledgerId, (long)writer.getId());
            long entryId = 0L;
            writer.write(entryId++, ByteBuffer.wrap(data));
            writer.write(entryId++, Unpooled.wrappedBuffer((byte[])data));
            long expectedEntryId = writer.write(entryId++, ByteBuffer.wrap(data));
            Assert.assertEquals((long)expectedEntryId, (long)writer.getLastAddConfirmed());
            Assert.assertEquals((long)(3 * data.length), (long)writer.getLength());
        }
    }

    @Test
    public void testWriteAdvHandleWithFixedLedgerId() throws Exception {
        this.setNewGeneratedLedgerId(12345L);
        try (WriteAdvHandle writer = (WriteAdvHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).makeAdv().withLedgerId(1234L).execute());){
            Assert.assertEquals((long)1234L, (long)writer.getId());
            long entryId = 0L;
            writer.write(entryId++, ByteBuffer.wrap(data));
            writer.write(entryId++, Unpooled.wrappedBuffer((byte[])data));
            long expectedEntryId = writer.write(entryId++, ByteBuffer.wrap(data));
            Assert.assertEquals((long)expectedEntryId, (long)writer.getLastAddConfirmed());
            Assert.assertEquals((long)(3 * data.length), (long)writer.getLength());
        }
    }

    @Test(expected=BKException.BKDuplicateEntryIdException.class)
    public void testWriteAdvHandleBKDuplicateEntryId() throws Exception {
        try (WriteAdvHandle writer = (WriteAdvHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).makeAdv().withLedgerId(1234L).execute());){
            Assert.assertEquals((long)1234L, (long)writer.getId());
            long entryId = 0L;
            writer.write(entryId++, ByteBuffer.wrap(data));
            Assert.assertEquals((long)data.length, (long)writer.getLength());
            writer.write(entryId - 1L, ByteBuffer.wrap(data));
        }
    }

    @Test(expected=BKException.BKUnauthorizedAccessException.class)
    public void testOpenLedgerUnauthorized() throws Exception {
        long lId;
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).execute());){
            lId = writer.getId();
            Assert.assertEquals((long)-1L, (long)writer.getLastAddPushed());
        }
        ReadHandle ignored = (ReadHandle)FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword("bad-password".getBytes(Charsets.UTF_8)).withLedgerId(lId).execute());
        var4_2 = null;
        if (ignored != null) {
            if (var4_2 != null) {
                try {
                    ignored.close();
                }
                catch (Throwable throwable) {
                    var4_2.addSuppressed(throwable);
                }
            } else {
                ignored.close();
            }
        }
    }

    @Test
    public void testLedgerDigests() throws Exception {
        for (DigestType type : DigestType.values()) {
            long lId;
            try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withDigestType(type).withPassword(password).execute());){
                lId = writer.getId();
                Assert.assertEquals((long)-1L, (long)writer.getLastAddPushed());
                writer.append(ByteBuffer.wrap(bigData));
                Assert.assertEquals((long)bigData.length, (long)writer.getLength());
            }
            var8_7 = null;
            try (ReadHandle reader = (ReadHandle)FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withDigestType(type).withPassword(password).withLedgerId(lId).execute());){
                LedgerEntries entries = reader.read(0L, 0L);
                BookKeeperApiTest.checkEntries(entries, bigData);
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
            FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(lId).execute());
        }
    }

    @Test
    public void testOpenLedgerDigestUnmatchedWhenAutoDetectionEnabled() throws Exception {
        this.testOpenLedgerDigestUnmatched(true);
    }

    @Test
    public void testOpenLedgerDigestUnmatchedWhenAutoDetectionDisabled() throws Exception {
        this.testOpenLedgerDigestUnmatched(false);
    }

    private void testOpenLedgerDigestUnmatched(boolean autodetection) throws Exception {
        block28: {
            long lId;
            ClientConfiguration conf = new ClientConfiguration();
            conf.setEnableDigestTypeAutodetection(autodetection);
            this.setBookKeeperConfig(conf);
            try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withDigestType(DigestType.MAC).withPassword(password).execute());){
                lId = writer.getId();
                Assert.assertEquals((long)-1L, (long)writer.getLastAddPushed());
            }
            try {
                var6_5 = null;
                try (ReadHandle ignored = (ReadHandle)FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withDigestType(DigestType.CRC32).withPassword(password).withLedgerId(lId).execute());){
                    if (!autodetection) {
                        Assert.fail((String)"Should fail to open read handle if digest type auto detection is disabled.");
                    }
                }
                catch (Throwable throwable) {
                    var6_5 = throwable;
                    throw throwable;
                }
            }
            catch (BKException.BKDigestMatchException bme) {
                if (!autodetection) break block28;
                Assert.fail((String)"Should not fail to open read handle if digest type auto detection is enabled.");
            }
        }
    }

    @Test
    public void testOpenLedgerNoSealed() throws Exception {
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withEnsembleSize(3).withWriteQuorumSize(3).withAckQuorumSize(2).withPassword(password).execute());){
            long lId = writer.getId();
            writer.append(ByteBuffer.wrap(data));
            writer.append(ByteBuffer.wrap(data));
            try (ReadHandle reader = (ReadHandle)FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(password).withRecovery(false).withLedgerId(lId).execute());){
                Assert.assertFalse((boolean)reader.isClosed());
            }
        }
    }

    @Test
    public void testOpenLedgerRead() throws Exception {
        long lId;
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).execute());){
            lId = writer.getId();
            writer.append(ByteBuffer.wrap(data));
            writer.append(ByteBuffer.wrap(data));
            writer.append(ByteBuffer.wrap(data));
        }
        var4_2 = null;
        try (ReadHandle reader = (ReadHandle)FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(password).withRecovery(false).withLedgerId(lId).execute());){
            Assert.assertTrue((boolean)reader.isClosed());
            Assert.assertEquals((long)2L, (long)reader.getLastAddConfirmed());
            Assert.assertEquals((long)(3 * data.length), (long)reader.getLength());
            Assert.assertEquals((long)2L, (long)reader.readLastAddConfirmed());
            Assert.assertEquals((long)2L, (long)reader.tryReadLastAddConfirmed());
            BookKeeperApiTest.checkEntries(reader.read(0L, reader.getLastAddConfirmed()), data);
            BookKeeperApiTest.checkEntries(reader.readUnconfirmed(0L, reader.getLastAddConfirmed()), data);
            LastConfirmedAndEntry lastConfirmedAndEntry = reader.readLastAddConfirmedAndEntry(0L, 999L, false);
            Assert.assertEquals((long)2L, (long)lastConfirmedAndEntry.getLastAddConfirmed());
            Assert.assertArrayEquals((byte[])data, (byte[])lastConfirmedAndEntry.getEntry().getEntryBytes());
            lastConfirmedAndEntry.close();
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test(expected=BKException.BKLedgerFencedException.class)
    public void testOpenLedgerWithRecovery() throws Exception {
        this.loggerOutput.expect(logEvents -> Assert.assertThat((Object)logEvents, (Matcher)Matchers.hasItem((Matcher)Matchers.hasProperty((String)"message", (Matcher)Matchers.containsString((String)"due to LedgerFencedException: Ledger has been fenced off. Some other client must have opened it to read")))));
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).execute());){
            long lId = writer.getId();
            writer.append(ByteBuffer.wrap(data));
            writer.append(ByteBuffer.wrap(data));
            Assert.assertEquals((long)1L, (long)writer.getLastAddPushed());
            try (ReadHandle reader = (ReadHandle)FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(password).withRecovery(true).withLedgerId(lId).execute());){
                Assert.assertTrue((boolean)reader.isClosed());
                Assert.assertEquals((long)1L, (long)reader.getLastAddConfirmed());
            }
            writer.append(ByteBuffer.wrap(data));
        }
    }

    @Test(expected=BKException.BKNoSuchLedgerExistsException.class)
    public void testDeleteLedger() throws Exception {
        long lId;
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withPassword(password).execute());){
            lId = writer.getId();
            Assert.assertEquals((long)-1L, (long)writer.getLastAddPushed());
        }
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(lId).execute());
        FutureUtils.result((CompletableFuture)this.newOpenLedgerOp().withPassword(password).withLedgerId(lId).execute());
    }

    @Test(expected=BKException.BKNoSuchLedgerExistsException.class)
    public void testCannotDeleteLedgerTwice() throws Exception {
        long lId;
        try (WriteHandle writer = (WriteHandle)FutureUtils.result((CompletableFuture)this.newCreateLedgerOp().withPassword(password).execute());){
            lId = writer.getId();
            Assert.assertEquals((long)-1L, (long)writer.getLastAddPushed());
        }
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(lId).execute());
        FutureUtils.result((CompletableFuture)this.newDeleteLedgerOp().withLedgerId(lId).execute());
    }

    @Test
    public void testLedgerEntriesIterable() throws Exception {
        long lId;
        try (WriteHandle writer = (WriteHandle)this.newCreateLedgerOp().withAckQuorumSize(1).withWriteQuorumSize(2).withEnsembleSize(3).withPassword(password).execute().get();){
            lId = writer.getId();
            writer.append(ByteBuffer.wrap(data));
            writer.append(ByteBuffer.wrap(data));
            writer.append(ByteBuffer.wrap(data));
        }
        var4_2 = null;
        try (ReadHandle reader = (ReadHandle)this.newOpenLedgerOp().withPassword(password).withRecovery(false).withLedgerId(lId).execute().get();){
            long lac = reader.getLastAddConfirmed();
            Assert.assertEquals((long)2L, (long)lac);
            try (LedgerEntries entries = reader.read(0L, lac);){
                AtomicLong i = new AtomicLong(0L);
                for (LedgerEntry e2 : entries) {
                    Assert.assertEquals((long)i.getAndIncrement(), (long)e2.getEntryId());
                    Assert.assertArrayEquals((byte[])data, (byte[])e2.getEntryBytes());
                }
                i.set(0L);
                entries.forEach(e -> {
                    Assert.assertEquals((long)i.getAndIncrement(), (long)e.getEntryId());
                    Assert.assertArrayEquals((byte[])data, (byte[])e.getEntryBytes());
                });
            }
        }
        catch (Throwable throwable) {
            var4_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testBKExceptionCodeLogger() {
        Assert.assertEquals((Object)"OK: No problem", (Object)BKException.codeLogger((int)0).toString());
        Assert.assertEquals((Object)"ReadException: Error while reading ledger", (Object)BKException.codeLogger((int)-1).toString());
        Assert.assertEquals((Object)"IncorrectParameterException: Incorrect parameter input", (Object)BKException.codeLogger((int)-14).toString());
        Assert.assertEquals((Object)"LedgerFencedException: Ledger has been fenced off. Some other client must have opened it to read", (Object)BKException.codeLogger((int)-101).toString());
        Assert.assertEquals((Object)"ReplicationException: Errors in replication pipeline", (Object)BKException.codeLogger((int)-200).toString());
        Assert.assertEquals((Object)"UnexpectedConditionException: Unexpected condition", (Object)BKException.codeLogger((int)-999).toString());
        Assert.assertEquals((Object)"1: Unexpected condition", (Object)BKException.codeLogger((int)1).toString());
        Assert.assertEquals((Object)"123: Unexpected condition", (Object)BKException.codeLogger((int)123).toString());
        Assert.assertEquals((Object)"-201: Unexpected condition", (Object)BKException.codeLogger((int)-201).toString());
    }

    private static void checkEntries(LedgerEntries entries, byte[] data) throws InterruptedException, BKException {
        for (LedgerEntry entry : entries) {
            Assert.assertArrayEquals((byte[])data, (byte[])entry.getEntryBytes());
        }
    }
}

