/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.metastore;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.metastore.MSException;
import org.apache.bookkeeper.metastore.MetastoreCallback;
import org.apache.bookkeeper.metastore.MetastoreCursor;
import org.apache.bookkeeper.metastore.MetastoreTable;
import org.apache.bookkeeper.metastore.Value;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;

public class MetastoreTableAsyncToSyncConverter {
    protected MetastoreTable table;

    public MetastoreTableAsyncToSyncConverter(MetastoreTable table) {
        this.table = table;
    }

    public Versioned<Value> get(String key) throws MSException {
        HeldValue retValue = new HeldValue();
        this.table.get(key, retValue, null);
        retValue.waitCallback();
        return (Versioned)retValue.getValue();
    }

    public Versioned<Value> get(String key, Set<String> fields) throws MSException {
        HeldValue retValue = new HeldValue();
        this.table.get(key, fields, retValue, null);
        retValue.waitCallback();
        return (Versioned)retValue.getValue();
    }

    public void remove(String key, Version version) throws MSException {
        HeldValue retValue = new HeldValue();
        this.table.remove(key, version, retValue, null);
        retValue.waitCallback();
    }

    public Version put(String key, Value value, Version version) throws MSException {
        HeldValue retValue = new HeldValue();
        this.table.put(key, value, version, retValue, null);
        retValue.waitCallback();
        return (Version)retValue.getValue();
    }

    public MetastoreCursor openCursor() throws MSException {
        HeldValue retValue = new HeldValue();
        this.table.openCursor(retValue, null);
        retValue.waitCallback();
        return (MetastoreCursor)retValue.getValue();
    }

    public MetastoreCursor openCursor(Set<String> fields) throws MSException {
        HeldValue retValue = new HeldValue();
        this.table.openCursor(fields, retValue, null);
        retValue.waitCallback();
        return (MetastoreCursor)retValue.getValue();
    }

    static class HeldValue<T>
    implements MetastoreCallback<T> {
        private CountDownLatch countDownLatch = new CountDownLatch(1);
        private int code;
        private T value = null;

        HeldValue() {
        }

        void waitCallback() throws MSException {
            try {
                this.countDownLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw MSException.create((MSException.Code)MSException.Code.InterruptedException);
            }
            if (MSException.Code.OK.getCode() != this.code) {
                throw MSException.create((MSException.Code)MSException.Code.get((int)this.code));
            }
        }

        public T getValue() {
            return this.value;
        }

        public void complete(int rc, T value, Object ctx) {
            this.code = rc;
            this.value = value;
            this.countDownLatch.countDown();
        }
    }
}

