/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server;

import java.io.IOException;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.server.service.BookieService;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BookieService.class})
public class TestMain {
    @Test
    public void testBuildBookieServer() throws Exception {
        ServerConfiguration serverConf = new ServerConfiguration().setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{TestComponent.class.getName()});
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        BookieServer mockServer = (BookieServer)PowerMockito.mock(BookieServer.class);
        PowerMockito.whenNew(BookieServer.class).withArguments(ArgumentMatchers.any(ServerConfiguration.class), new Object[]{ArgumentMatchers.any(StatsLogger.class)}).thenReturn((Object)mockServer);
        LifecycleComponentStack stack = Main.buildBookieServer((BookieConfiguration)conf);
        Assert.assertEquals((long)3L, (long)stack.getNumComponents());
        Assert.assertTrue((boolean)(stack.getComponent(2) instanceof TestComponent));
        stack.start();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
        stack.stop();
        stack.close();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testIgnoreExtraServerComponentsStartupFailures() throws Exception {
        ServerConfiguration serverConf = new ServerConfiguration().setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{"bad-server-component"}).setIgnoreExtraServerComponentsStartupFailures(true);
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        BookieServer mockServer = (BookieServer)PowerMockito.mock(BookieServer.class);
        PowerMockito.whenNew(BookieServer.class).withArguments(ArgumentMatchers.any(ServerConfiguration.class), new Object[]{ArgumentMatchers.any(StatsLogger.class)}).thenReturn((Object)mockServer);
        LifecycleComponentStack stack = Main.buildBookieServer((BookieConfiguration)conf);
        Assert.assertEquals((long)2L, (long)stack.getNumComponents());
        stack.start();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).start();
        stack.stop();
        stack.close();
        ((BookieServer)Mockito.verify((Object)mockServer, (VerificationMode)Mockito.times((int)1))).shutdown();
    }

    @Test
    public void testExtraServerComponentsStartupFailures() throws Exception {
        ServerConfiguration serverConf = new ServerConfiguration().setAutoRecoveryDaemonEnabled(false).setHttpServerEnabled(false).setExtraServerComponents(new String[]{"bad-server-component"}).setIgnoreExtraServerComponentsStartupFailures(false);
        BookieConfiguration conf = new BookieConfiguration(serverConf);
        BookieServer mockServer = (BookieServer)PowerMockito.mock(BookieServer.class);
        PowerMockito.whenNew(BookieServer.class).withArguments(ArgumentMatchers.any(ServerConfiguration.class), new Object[]{ArgumentMatchers.any(StatsLogger.class)}).thenReturn((Object)mockServer);
        try {
            Main.buildBookieServer((BookieConfiguration)conf);
            Assert.fail((String)"Should fail to start bookie server if `ignoreExtraServerComponentsStartupFailures` is set to false");
        }
        catch (RuntimeException re) {
            Assert.assertTrue((boolean)(re.getCause() instanceof ClassNotFoundException));
        }
    }

    static class TestComponent
    extends ServerLifecycleComponent {
        public TestComponent(BookieConfiguration conf, StatsLogger statsLogger) {
            super("test-component", conf, statsLogger);
        }

        protected void doStart() {
        }

        protected void doStop() {
        }

        protected void doClose() throws IOException {
        }
    }
}

