/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.io.File;
import java.util.HashSet;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.PortManager;
import org.junit.Assert;
import org.junit.Test;

public class BookieZKExpireTest
extends BookKeeperClusterTestCase {
    public BookieZKExpireTest() {
        super(0);
        this.baseConf.setZkTimeout(6000);
        this.baseClientConf.setZkTimeout(6000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBookieServerZKExpireBehaviour() throws Exception {
        BookieServer server = null;
        try {
            File f = this.createTempDir("bookieserver", "test");
            HashSet<Thread> threadset = new HashSet<Thread>();
            int threadCount = Thread.activeCount();
            Thread[] threads = new Thread[threadCount * 2];
            threadCount = Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i].getName().indexOf("SendThread") == -1) continue;
                threadset.add(threads[i]);
            }
            ServerConfiguration conf = this.newServerConfiguration(PortManager.nextFreePort(), f, new File[]{f});
            server = new BookieServer(conf);
            server.start();
            int secondsToWait = 5;
            while (!server.isRunning()) {
                Thread.sleep(1000L);
                if (secondsToWait-- > 0) continue;
                Assert.fail((String)"Bookie never started");
            }
            Thread sendthread = null;
            threadCount = Thread.activeCount();
            threads = new Thread[threadCount * 2];
            threadCount = Thread.enumerate(threads);
            for (int i = 0; i < threadCount; ++i) {
                if (threads[i].getName().indexOf("SendThread") == -1 || threadset.contains(threads[i])) continue;
                sendthread = threads[i];
                break;
            }
            Assert.assertNotNull((String)"Send thread not found", sendthread);
            sendthread.suspend();
            Thread.sleep(2 * conf.getZkTimeout());
            sendthread.resume();
            Thread.sleep(3000L);
            Assert.assertTrue((String)"Bookie should not shutdown on losing zk session", (boolean)server.isBookieRunning());
            Assert.assertTrue((String)"Bookie Server should not shutdown on losing zk session", (boolean)server.isRunning());
        }
        finally {
            server.shutdown();
        }
    }
}

