/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.test;

import java.util.function.BiConsumer;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.test.TestStatsProvider;
import org.apache.bookkeeper.util.MathUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OpStatTest
extends BookKeeperClusterTestCase {
    private LedgerHandle lh;

    public OpStatTest() {
        super(1);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.lh = this.bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, "".getBytes());
        this.resetBookieOpLoggers();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.lh.close();
        this.lh = null;
        super.tearDown();
    }

    private void validateOpStat(TestStatsProvider stats, String path, BiConsumer<Long, Double> f) {
        Assert.assertTrue((stats != null ? 1 : 0) != 0);
        TestStatsProvider.TestOpStatsLogger logger = stats.getOpStatsLogger(path);
        Assert.assertTrue((logger != null ? 1 : 0) != 0);
        f.accept(logger.getSuccessCount(), logger.getSuccessAverage());
    }

    private void validateOpStat(TestStatsProvider stats, String[] paths, BiConsumer<Long, Double> f) {
        for (String path : paths) {
            this.validateOpStat(stats, path, f);
        }
    }

    private void validateNonMonotonicCounterGauge(TestStatsProvider stats, String path, BiConsumer<Long, Long> f) {
        Assert.assertTrue((stats != null ? 1 : 0) != 0);
        TestStatsProvider.TestCounter counter = stats.getCounter(path);
        Assert.assertTrue((counter != null ? 1 : 0) != 0);
        f.accept(counter.get(), counter.getMax());
    }

    private void validateNonMonotonicCounterGauges(TestStatsProvider stats, String[] paths, BiConsumer<Long, Long> f) {
        for (String path : paths) {
            this.validateNonMonotonicCounterGauge(stats, path, f);
        }
    }

    @Test
    public void testTopLevelBookieWriteCounters() throws Exception {
        long startNanos = MathUtils.nowInNano();
        this.lh.addEntry("test".getBytes());
        long elapsed = MathUtils.elapsedNanos((long)startNanos);
        TestStatsProvider stats = this.getStatsProvider(0);
        this.validateOpStat(stats, new String[]{"bookkeeper_server.ADD_ENTRY", "bookkeeper_server.ADD_ENTRY_REQUEST", "bookkeeper_server.BookieWriteThreadPool.task_queued", "bookkeeper_server.BookieWriteThreadPool.task_execution", "bookkeeper_server.CHANNEL_WRITE"}, (Long count, Double average) -> {
            Assert.assertTrue((count == 1L ? 1 : 0) != 0);
            Assert.assertTrue((average > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((average <= (double)elapsed ? 1 : 0) != 0);
        });
        this.validateOpStat(stats, new String[]{"bookkeeper_server.CHANNEL_WRITE"}, (Long count, Double average) -> {
            Assert.assertTrue((count > 0L ? 1 : 0) != 0);
            Assert.assertTrue((average > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((average <= (double)elapsed ? 1 : 0) != 0);
        });
        this.validateNonMonotonicCounterGauges(stats, new String[]{"bookie.journal.JOURNAL_CB_QUEUE_SIZE", "bookie.journal.JOURNAL_FORCE_WRITE_QUEUE_SIZE", "bookie.journal.JOURNAL_QUEUE_SIZE"}, (value, max) -> Assert.assertTrue((max > 0L ? 1 : 0) != 0));
    }

    @Test
    public void testTopLevelBookieReadCounters() throws Exception {
        long startNanos = MathUtils.nowInNano();
        this.lh.addEntry("test".getBytes());
        this.lh.readEntries(0L, 0L);
        long elapsed = MathUtils.elapsedNanos((long)startNanos);
        TestStatsProvider stats = this.getStatsProvider(0);
        this.validateOpStat(stats, new String[]{"bookkeeper_server.READ_ENTRY", "bookkeeper_server.READ_ENTRY_REQUEST", "bookkeeper_server.BookieReadThreadPool.task_queued", "bookkeeper_server.BookieReadThreadPool.task_execution"}, (Long count, Double average) -> {
            Assert.assertTrue((count == 1L ? 1 : 0) != 0);
            Assert.assertTrue((average > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((average <= (double)elapsed ? 1 : 0) != 0);
        });
        this.validateOpStat(stats, new String[]{"bookkeeper_server.CHANNEL_WRITE"}, (Long count, Double average) -> {
            Assert.assertTrue((count > 0L ? 1 : 0) != 0);
            Assert.assertTrue((average > 0.0 ? 1 : 0) != 0);
            Assert.assertTrue((average <= (double)elapsed ? 1 : 0) != 0);
        });
    }
}

