/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Marker;
import org.slf4j.event.Level;

public class LoggerOutput
implements TestRule {
    private Appender logAppender;
    private ArgumentCaptor<LoggingEvent> logEventCaptor;
    private List<Consumer<List<org.slf4j.event.LoggingEvent>>> logEventExpectations = new ArrayList<Consumer<List<org.slf4j.event.LoggingEvent>>>();

    public void expect(Consumer<List<org.slf4j.event.LoggingEvent>> expectation) {
        if (this.logEventCaptor == null) {
            this.logEventCaptor = ArgumentCaptor.forClass(LoggingEvent.class);
        }
        this.logEventExpectations.add(expectation);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                LoggerOutput.this.logAppender = (Appender)Mockito.mock(Appender.class);
                Logger rootLogger = LogManager.getRootLogger();
                rootLogger.addAppender(LoggerOutput.this.logAppender);
                try {
                    base.evaluate();
                    if (!LoggerOutput.this.logEventExpectations.isEmpty()) {
                        ((Appender)Mockito.verify((Object)LoggerOutput.this.logAppender, (VerificationMode)Mockito.atLeastOnce())).doAppend((LoggingEvent)LoggerOutput.this.logEventCaptor.capture());
                        List logEvents = LoggerOutput.this.logEventCaptor.getAllValues().stream().map(x$0 -> LoggerOutput.toSlf4j(x$0)).collect(Collectors.toList());
                        for (Consumer expectation : LoggerOutput.this.logEventExpectations) {
                            expectation.accept(logEvents);
                        }
                    }
                }
                finally {
                    rootLogger.removeAppender(LoggerOutput.this.logAppender);
                    LoggerOutput.this.logEventExpectations.clear();
                    LoggerOutput.this.logEventCaptor = null;
                }
            }
        };
    }

    private static org.slf4j.event.LoggingEvent toSlf4j(final LoggingEvent log4jEvent) {
        return new org.slf4j.event.LoggingEvent(){

            public Level getLevel() {
                switch (log4jEvent.getLevel().toString()) {
                    case "FATAL": 
                    case "ERROR": {
                        return Level.ERROR;
                    }
                    case "WARN": {
                        return Level.WARN;
                    }
                    case "INFO": {
                        return Level.INFO;
                    }
                    case "DEBUG": {
                        return Level.DEBUG;
                    }
                }
                return Level.TRACE;
            }

            public Marker getMarker() {
                return null;
            }

            public String getLoggerName() {
                return log4jEvent.getLoggerName();
            }

            public String getMessage() {
                return log4jEvent.getRenderedMessage();
            }

            public String getThreadName() {
                return log4jEvent.getThreadName();
            }

            public Object[] getArgumentArray() {
                return new Object[0];
            }

            public long getTimeStamp() {
                return log4jEvent.getTimeStamp();
            }

            public Throwable getThrowable() {
                return null;
            }
        };
    }
}

