/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.storage.ldb.ArrayGroupSort;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=1)
@Warmup(iterations=1, time=10)
@Measurement(iterations=3, time=10)
public class GroupSortBenchmark {
    private static final int N = 10000;

    @Benchmark
    public void randomGroupSort(TestState s) {
        ArrayGroupSort.sort((long[])s.items);
    }

    @Benchmark
    public void randomArraySort(TestState s) {
        Arrays.sort(s.items);
    }

    @Benchmark
    public void preSortedGroupSort(TestState s) {
        ArrayGroupSort.sort((long[])s.groupSortedItems);
    }

    @Benchmark
    public void preSortedArraySort(TestState s) {
        Arrays.sort(s.sortedItems);
    }

    @Benchmark
    public void reverseSortedGroupSort(TestState s) {
        ArrayGroupSort.sort((long[])s.reverseGroupSortedItems);
    }

    @Benchmark
    public void reverseSortedArraySort(TestState s) {
        Arrays.sort(s.reverseSortedItems);
    }

    @State(value=Scope.Benchmark)
    public static class TestState {
        private final long[] randomItems = new long[40000];
        private final long[] sortedItems;
        private final long[] reverseSortedItems = new long[40000];
        private final long[] groupSortedItems;
        private final long[] reverseGroupSortedItems = new long[40000];
        private long[] items;

        public TestState() {
            int i;
            ThreadLocalRandom r = ThreadLocalRandom.current();
            for (i = 0; i < 40000; ++i) {
                this.randomItems[i] = ((Random)r).nextLong();
            }
            this.groupSortedItems = Arrays.copyOf(this.randomItems, this.randomItems.length);
            ArrayGroupSort.sort((long[])this.groupSortedItems);
            for (i = 0; i < 40000; i += 4) {
                this.reverseGroupSortedItems[i] = this.groupSortedItems[39996 - i];
                this.reverseGroupSortedItems[i + 1] = this.groupSortedItems[39996 - i + 1];
                this.reverseGroupSortedItems[i + 2] = this.groupSortedItems[39996 - i + 2];
                this.reverseGroupSortedItems[i + 3] = this.groupSortedItems[39996 - i + 3];
            }
            this.sortedItems = Arrays.copyOf(this.randomItems, this.randomItems.length);
            Arrays.sort(this.sortedItems);
            for (i = 0; i < 40000; ++i) {
                this.reverseSortedItems[i] = this.sortedItems[39999 - i];
            }
        }

        @Setup(value=Level.Invocation)
        public void setupInvocation() {
            this.items = Arrays.copyOf(this.randomItems, this.randomItems.length);
        }
    }
}

