/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.collections.BatchedArrayBlockingQueue;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@BenchmarkMode(value={Mode.Throughput})
@Threads(value=16)
@Fork(value=1)
@Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
public class MpScQueueBenchmark {
    private static final int QUEUE_SIZE = 100000;

    @Benchmark
    public void arrayBlockingQueue(TestState s) throws Exception {
        s.arrayBlockingQueue.put(1);
    }

    @Benchmark
    public void batchAwareArrayBlockingQueueSingleEnqueue(TestState s) throws Exception {
        s.batchedArrayBlockingQueue.put((Object)1);
    }

    @Benchmark
    @OperationsPerInvocation(value=1000)
    public void batchAwareArrayBlockingQueueBatch(TestState s) throws Exception {
        s.batchedArrayBlockingQueue.putAll((Object[])s.batchArray, 0, 1000);
    }

    @State(value=Scope.Benchmark)
    public static class TestState {
        private ArrayBlockingQueue arrayBlockingQueue = new ArrayBlockingQueue(100000);
        private BatchedArrayBlockingQueue batchedArrayBlockingQueue = new BatchedArrayBlockingQueue(100000);
        private final Integer[] batchArray = new Integer[1000];
        private final ExecutorService executor = Executors.newCachedThreadPool();

        @Setup(value=Level.Trial)
        public void setup() {
            for (int i = 0; i < 1000; ++i) {
                this.batchArray[i] = i;
            }
            this.executor.execute(this::consumeABQ);
            this.executor.execute(this::consumeBAABQ);
        }

        private void consumeABQ() {
            ArrayList localList = new ArrayList();
            try {
                while (true) {
                    this.arrayBlockingQueue.drainTo(localList);
                    if (localList.isEmpty()) {
                        this.arrayBlockingQueue.take();
                    }
                    localList.clear();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }

        private void consumeBAABQ() {
            Object[] localArray = new Integer[20000];
            try {
                while (true) {
                    this.batchedArrayBlockingQueue.takeAll(localArray);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }

        @TearDown(value=Level.Trial)
        public void teardown() {
            this.executor.shutdownNow();
        }

        @TearDown(value=Level.Iteration)
        public void cleanupQueue() throws InterruptedException {
            Thread.sleep(1000L);
        }
    }
}

