/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto.checksum;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

public class DigestManagerBenchmark {
    static byte[] randomBytes(int sz) {
        byte[] b = new byte[sz];
        ThreadLocalRandom.current().nextBytes(b);
        return b;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MICROSECONDS)
    @Warmup(iterations=2, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
    @Threads(value=2)
    @Fork(value=1)
    public void verifyDigest(MyState state) throws Exception {
        state.digestBuf.readerIndex(0);
        state.dm.verifyDigestAndReturnData(1234L, state.digestBuf);
    }

    @State(value=Scope.Thread)
    public static class MyState {
        @Param(value={"64", "1024", "4086", "8192"})
        public int entrySize;
        private DigestManager dm;
        public ByteBuf digestBuf;

        @Setup(value=Level.Trial)
        public void doSetup() throws Exception {
            byte[] password = "password".getBytes(StandardCharsets.UTF_8);
            this.dm = DigestManager.instantiate((long)ThreadLocalRandom.current().nextLong(0L, Long.MAX_VALUE), (byte[])password, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (boolean)true);
            ByteBuf data = ByteBufAllocator.DEFAULT.directBuffer(this.entrySize, this.entrySize);
            data.writeBytes(DigestManagerBenchmark.randomBytes(this.entrySize));
            this.digestBuf = ByteBufAllocator.DEFAULT.directBuffer();
            this.digestBuf.writeBytes((ByteBuf)this.dm.computeDigestAndPackageForSending(1234L, 1234L, (long)this.entrySize, data, new byte[0], 0));
        }
    }
}

