/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto.checksum;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

public class DigestTypeBenchmark {
    static byte[] randomBytes(int sz) {
        byte[] b = new byte[sz];
        ThreadLocalRandom.current().nextBytes(b);
        return b;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=2, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=2, time=10, timeUnit=TimeUnit.SECONDS)
    @Threads(value=2)
    @Fork(value=1, warmups=1)
    public void digestManager(MyState state) {
        ByteBuf buff = state.getByteBuff(state.bufferType);
        DigestManager dm = state.getDigestManager(state.digest);
        int digest = dm.update(0, buff, 0, buff.readableBytes());
        state.digestBuf.clear();
        dm.populateValueAndReset(digest, state.digestBuf);
    }

    @State(value=Scope.Thread)
    public static class MyState {
        @Param
        public BufferType bufferType;
        @Param
        public Digest digest;
        @Param(value={"64", "1024", "4086", "8192", "16384", "65536"})
        public int entrySize;
        private DigestManager crc32;
        private DigestManager crc32c;
        private DigestManager mac;
        private ByteBuf arrayBackedBuffer;
        private CompositeByteBuf notArrayBackedBuffer;
        private ByteBuf byteBufDefaultAlloc;
        public ByteBuf digestBuf;

        @Setup(value=Level.Trial)
        public void doSetup() throws Exception {
            byte[] password = "password".getBytes(StandardCharsets.UTF_8);
            this.crc32 = DigestManager.instantiate((long)ThreadLocalRandom.current().nextLong(0L, Long.MAX_VALUE), (byte[])password, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (boolean)true);
            this.crc32c = DigestManager.instantiate((long)ThreadLocalRandom.current().nextLong(0L, Long.MAX_VALUE), (byte[])password, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32C, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (boolean)true);
            this.mac = DigestManager.instantiate((long)ThreadLocalRandom.current().nextLong(0L, Long.MAX_VALUE), (byte[])password, (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.HMAC, (ByteBufAllocator)PooledByteBufAllocator.DEFAULT, (boolean)true);
            this.digestBuf = Unpooled.buffer((int)this.getDigestManager(this.digest).getMacCodeLength());
            this.arrayBackedBuffer = Unpooled.wrappedBuffer((byte[])DigestTypeBenchmark.randomBytes(this.entrySize));
            int headerSize = 32 + this.getDigestManager(this.digest).getMacCodeLength();
            this.notArrayBackedBuffer = new CompositeByteBuf(ByteBufAllocator.DEFAULT, true, 2);
            this.notArrayBackedBuffer.addComponent(Unpooled.wrappedBuffer((byte[])DigestTypeBenchmark.randomBytes(headerSize)));
            this.notArrayBackedBuffer.addComponent(Unpooled.wrappedBuffer((byte[])DigestTypeBenchmark.randomBytes(this.entrySize - headerSize)));
            this.byteBufDefaultAlloc = ByteBufAllocator.DEFAULT.buffer(this.entrySize, this.entrySize);
            this.byteBufDefaultAlloc.writeBytes(DigestTypeBenchmark.randomBytes(this.entrySize));
            if (!this.arrayBackedBuffer.hasArray() || this.notArrayBackedBuffer.hasArray()) {
                throw new IllegalStateException("buffers in invalid state");
            }
        }

        @TearDown(value=Level.Trial)
        public void doTearDown() {
        }

        public ByteBuf getByteBuff(BufferType bType) {
            switch (bType) {
                case ARRAY_BACKED: {
                    return this.arrayBackedBuffer;
                }
                case NOT_ARRAY_BACKED: {
                    return this.notArrayBackedBuffer;
                }
                case BYTE_BUF_DEFAULT_ALLOC: {
                    return this.byteBufDefaultAlloc;
                }
            }
            throw new IllegalArgumentException("unknown buffer type " + (Object)((Object)bType));
        }

        public DigestManager getDigestManager(Digest digest) {
            switch (digest) {
                case CRC32: {
                    return this.crc32;
                }
                case CRC32_C: {
                    return this.crc32c;
                }
                case MAC: {
                    return this.mac;
                }
            }
            throw new IllegalArgumentException("unknown digest " + (Object)((Object)digest));
        }
    }

    public static enum Digest {
        MAC,
        CRC32,
        CRC32_C;

    }

    public static enum BufferType {
        ARRAY_BACKED,
        NOT_ARRAY_BACKED,
        BYTE_BUF_DEFAULT_ALLOC;

    }
}

