/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.config;

import java.util.Optional;
import org.apache.bookkeeper.clients.config.StorageClientSettings_Builder;
import org.apache.bookkeeper.clients.resolver.EndpointResolver;
import org.apache.bookkeeper.clients.utils.ClientConstants;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.common.util.Backoff;

public interface StorageClientSettings {
    public int numWorkerThreads();

    public String serviceUri();

    public EndpointResolver endpointResolver();

    public boolean usePlaintext();

    public Optional<String> clientName();

    public Backoff.Policy backoffPolicy();

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    extends StorageClientSettings_Builder {
        Builder() {
            this.numWorkerThreads(Runtime.getRuntime().availableProcessors());
            this.usePlaintext(true);
            this.backoffPolicy(ClientConstants.DEFAULT_INFINIT_BACKOFF_POLICY);
            this.endpointResolver(EndpointResolver.identity());
        }

        @Override
        public StorageClientSettings build() {
            StorageClientSettings settings = super.build();
            ServiceURI.create((String)this.serviceUri());
            return settings;
        }
    }
}

