/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.container;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.apache.bookkeeper.common.grpc.netty.LongBinaryMarshaller;

public class StorageContainerClientInterceptor
implements ClientInterceptor {
    private final long scId;
    private final Metadata.Key<Long> scIdKey;

    public StorageContainerClientInterceptor(long scId) {
        this.scId = scId;
        this.scIdKey = Metadata.Key.of((String)"sc-id-bin", (Metadata.BinaryMarshaller)LongBinaryMarshaller.of());
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new ClientInterceptors.CheckedForwardingClientCall<ReqT, RespT>(next.newCall(method, callOptions)){

            protected void checkedStart(ClientCall.Listener<RespT> responseListener, Metadata headers) throws Exception {
                headers.put(StorageContainerClientInterceptor.this.scIdKey, (Object)StorageContainerClientInterceptor.this.scId);
                this.delegate().start(responseListener, headers);
            }
        };
    }
}

