/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.routing;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.bookkeeper.clients.impl.internal.api.HashStreamRanges;
import org.apache.bookkeeper.common.router.HashRouter;
import org.apache.bookkeeper.stream.proto.RangeProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RangeRouter<K> {
    private static final Logger log = LoggerFactory.getLogger(RangeRouter.class);
    private final HashRouter<K> keyRouter;
    private final StampedLock lock;
    private HashStreamRanges ranges;

    public RangeRouter(HashRouter<K> keyRouter) {
        this.keyRouter = keyRouter;
        this.lock = new StampedLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getRange(@Nullable K key) {
        long routingKey = null != key ? ((Long)this.keyRouter.getRoutingKey(key)).longValue() : ThreadLocalRandom.current().nextLong();
        long stamp = this.lock.tryOptimisticRead();
        HashStreamRanges rs = this.ranges;
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                rs = this.ranges;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        Preconditions.checkState((null != rs ? 1 : 0) != 0, (Object)"No range is available");
        Map.Entry<Long, RangeProperties> ceilingEntry = rs.getRanges().floorEntry(routingKey);
        return ceilingEntry.getValue().getRangeId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashStreamRanges getRanges() {
        long stamp = this.lock.tryOptimisticRead();
        HashStreamRanges rs = this.ranges;
        if (!this.lock.validate(stamp)) {
            stamp = this.lock.readLock();
            try {
                rs = this.ranges;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashStreamRanges setRanges(HashStreamRanges ranges) {
        long stamp = this.lock.writeLock();
        try {
            if (this.ranges == null || ranges.getMaxRangeId() > this.ranges.getMaxRangeId()) {
                HashStreamRanges oldRanges = this.ranges;
                this.ranges = ranges;
                HashStreamRanges hashStreamRanges = oldRanges;
                return hashStreamRanges;
            }
            HashStreamRanges hashStreamRanges = null;
            return hashStreamRanges;
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }
}

