/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.utils;

import io.grpc.ManagedChannelBuilder;
import io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.common.resolver.ServiceNameResolverProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcChannels {
    private static final Logger log = LoggerFactory.getLogger(GrpcChannels.class);
    private static final String BACKEND_INPROCESS = "inprocess";

    private GrpcChannels() {
    }

    public static ManagedChannelBuilder createChannelBuilder(String serviceUri, StorageClientSettings settings) {
        ManagedChannelBuilder builder;
        ServiceURI uri = ServiceURI.create((String)serviceUri);
        if (uri.getServiceInfos().length > 0 && uri.getServiceInfos()[0].equals(BACKEND_INPROCESS)) {
            String serviceName = uri.getServiceHosts()[0];
            builder = InProcessChannelBuilder.forName((String)serviceName).directExecutor();
        } else {
            builder = ManagedChannelBuilder.forTarget((String)serviceUri).nameResolverFactory(new ServiceNameResolverProvider().toFactory());
        }
        if (settings.usePlaintext()) {
            builder = builder.usePlaintext();
        }
        return builder;
    }
}

