/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.clients.StorageClientImpl;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.admin.StorageAdminClientImpl;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.bookkeeper.stream.protocol.util.ProtoUtils;

public class StorageClientBuilder
implements Supplier<StorageClient> {
    private StorageClientSettings settings = null;
    private String namespaceName = null;

    public static StorageClientBuilder newBuilder() {
        return new StorageClientBuilder();
    }

    private StorageClientBuilder() {
    }

    public StorageClientBuilder withSettings(StorageClientSettings settings) {
        this.settings = settings;
        return this;
    }

    public StorageClientBuilder withNamespace(String colName) {
        this.namespaceName = colName;
        return this;
    }

    public StorageClient build() {
        Preconditions.checkNotNull((Object)this.settings, (Object)"Stream settings is null");
        Preconditions.checkArgument((boolean)ProtoUtils.validateNamespaceName(this.namespaceName), (Object)("Namespace name '" + this.namespaceName + "'is invalid"));
        return new StorageClientImpl(this.namespaceName, this.settings, ClientResources.create());
    }

    public StorageAdminClient buildAdmin() {
        Preconditions.checkNotNull((Object)this.settings, (Object)"Storage client settings is null");
        return new StorageAdminClientImpl(this.settings);
    }

    @Override
    public StorageClient get() {
        return this.build();
    }
}

