/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients;

import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.api.kv.PTable;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.internal.StorageServerClientManagerImpl;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.clients.impl.kv.ByteBufTableImpl;
import org.apache.bookkeeper.clients.impl.kv.PByteBufTableImpl;
import org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.util.AbstractAutoAsyncCloseable;
import org.apache.bookkeeper.common.util.ExceptionUtils;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StorageClientImpl
extends AbstractAutoAsyncCloseable
implements StorageClient {
    private static final Logger log = LoggerFactory.getLogger(StorageClientImpl.class);
    private static final String COMPONENT_NAME = StorageClientImpl.class.getSimpleName();
    private final String namespaceName;
    private final StorageClientSettings settings;
    private final ClientResources resources;
    private final OrderedScheduler scheduler;
    private final StorageServerClientManager serverManager;

    public StorageClientImpl(String namespaceName, StorageClientSettings settings, ClientResources resources) {
        this.namespaceName = namespaceName;
        this.settings = settings;
        this.resources = resources;
        this.serverManager = new StorageServerClientManagerImpl(settings, resources.scheduler());
        this.scheduler = (OrderedScheduler)SharedResourceManager.shared().get(resources.scheduler());
    }

    private CompletableFuture<StreamProperties> getStreamProperties(String streamName) {
        return this.serverManager.getRootRangeClient().getStream(this.namespaceName, streamName);
    }

    @Override
    public CompletableFuture<PTable<ByteBuf, ByteBuf>> openPTable(String streamName) {
        return ExceptionUtils.callAndHandleClosedAsync(COMPONENT_NAME, this.isClosed(), future -> this.openStreamAsTableImpl(streamName, future));
    }

    @Override
    public CompletableFuture<Table<ByteBuf, ByteBuf>> openTable(String table) {
        return this.openPTable(table).thenApply(pTable -> new ByteBufTableImpl((PTable<ByteBuf, ByteBuf>)pTable));
    }

    private void openStreamAsTableImpl(String streamName, CompletableFuture<PTable<ByteBuf, ByteBuf>> future) {
        FutureUtils.proxyTo((CompletableFuture)this.getStreamProperties(streamName).thenComposeAsync(props -> {
            if (log.isInfoEnabled()) {
                log.info("Retrieved stream properties for stream {} : {}", (Object)streamName, props);
            }
            return new PByteBufTableImpl(streamName, (StreamProperties)props, this.serverManager, (ScheduledExecutorService)this.scheduler.chooseThread(props.getStreamId()), this.settings.backoffPolicy()).initialize();
        }), future);
    }

    @Override
    protected void closeAsyncOnce(CompletableFuture<Void> closeFuture) {
        this.scheduler.submit(() -> {
            this.serverManager.close();
            closeFuture.complete(null);
            SharedResourceManager.shared().release(this.resources.scheduler(), (Object)this.scheduler);
        });
    }

    @Override
    public void close() {
        super.close();
        this.scheduler.forceShutdown(100L, TimeUnit.MILLISECONDS);
    }
}

