/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.admin;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.bookkeeper.clients.admin.StorageAdminClient;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.internal.StorageServerClientManagerImpl;
import org.apache.bookkeeper.clients.impl.internal.api.RootRangeClient;
import org.apache.bookkeeper.clients.impl.internal.api.StorageServerClientManager;
import org.apache.bookkeeper.clients.utils.ClientResources;
import org.apache.bookkeeper.common.util.AbstractAutoAsyncCloseable;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.common.util.SharedResourceManager;
import org.apache.bookkeeper.stream.proto.NamespaceConfiguration;
import org.apache.bookkeeper.stream.proto.NamespaceProperties;
import org.apache.bookkeeper.stream.proto.StreamConfiguration;
import org.apache.bookkeeper.stream.proto.StreamProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageAdminClientImpl
extends AbstractAutoAsyncCloseable
implements StorageAdminClient {
    private static final Logger log = LoggerFactory.getLogger(StorageAdminClientImpl.class);
    private final StorageServerClientManager clientManager;
    private final RootRangeClient rootRangeClient;

    public StorageAdminClientImpl(StorageClientSettings settings) {
        this(settings, ClientResources.create().scheduler());
    }

    public StorageAdminClientImpl(StorageClientSettings settings, SharedResourceManager.Resource<OrderedScheduler> schedulerResource) {
        this(() -> new StorageServerClientManagerImpl(settings, schedulerResource));
    }

    @VisibleForTesting
    StorageAdminClientImpl(Supplier<StorageServerClientManager> factory) {
        this.clientManager = factory.get();
        this.rootRangeClient = this.clientManager.getRootRangeClient();
    }

    @Override
    public CompletableFuture<NamespaceProperties> createNamespace(String namespace, NamespaceConfiguration colConf) {
        return this.rootRangeClient.createNamespace(namespace, colConf);
    }

    @Override
    public CompletableFuture<Boolean> deleteNamespace(String namespace) {
        return this.rootRangeClient.deleteNamespace(namespace);
    }

    @Override
    public CompletableFuture<NamespaceProperties> getNamespace(String namespace) {
        return this.rootRangeClient.getNamespace(namespace);
    }

    @Override
    public CompletableFuture<StreamProperties> createStream(String namespace, String streamName, StreamConfiguration streamConf) {
        return this.rootRangeClient.createStream(namespace, streamName, streamConf);
    }

    @Override
    public CompletableFuture<Boolean> deleteStream(String namespace, String streamName) {
        return this.rootRangeClient.deleteStream(namespace, streamName);
    }

    @Override
    public CompletableFuture<StreamProperties> getStream(String namespace, String streamName) {
        return this.rootRangeClient.getStream(namespace, streamName);
    }

    @Override
    protected void closeAsyncOnce(CompletableFuture<Void> closeFuture) {
        this.clientManager.closeAsync().whenComplete((result, cause) -> closeFuture.complete(null));
    }

    @Override
    public void close() {
        try {
            this.closeAsync().get();
        }
        catch (InterruptedException e) {
            log.debug("Interrupted on closing stream admin client", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.debug("Failed to cloe stream admin client", (Throwable)e);
        }
    }
}

