/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.api.kv.impl.result;

import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import org.apache.bookkeeper.api.kv.result.KeyValue;

public class KeyValueImpl<K, V>
implements KeyValue<K, V> {
    private final Recycler.Handle<KeyValueImpl<K, V>> handle;
    private K key = null;
    private V value = null;
    private long createRevision = -1L;
    private long modifiedRevision = -1L;
    private long version = -1L;
    private boolean isNumber = false;
    private long numberValue = -1L;

    KeyValueImpl(Recycler.Handle<KeyValueImpl<K, V>> handle) {
        this.handle = handle;
    }

    public KeyValueImpl<K, V> key(K key) {
        ReferenceCountUtil.release(this.key);
        this.key = ReferenceCountUtil.retain(key);
        return this;
    }

    public KeyValueImpl<K, V> value(V value) {
        ReferenceCountUtil.release(this.value);
        this.value = ReferenceCountUtil.retain(value);
        return this;
    }

    private void reset() {
        ReferenceCountUtil.release(this.key);
        this.key = null;
        ReferenceCountUtil.release(this.value);
        this.value = null;
        this.createRevision = -1L;
        this.modifiedRevision = -1L;
        this.version = -1L;
        this.isNumber = false;
        this.numberValue = -1L;
    }

    @Override
    public void close() {
        this.reset();
        this.handle.recycle((Object)this);
    }

    public KeyValueImpl<K, V> createRevision(long createRevision) {
        this.createRevision = createRevision;
        return this;
    }

    public KeyValueImpl<K, V> modifiedRevision(long modifiedRevision) {
        this.modifiedRevision = modifiedRevision;
        return this;
    }

    public KeyValueImpl<K, V> version(long version) {
        this.version = version;
        return this;
    }

    public KeyValueImpl<K, V> isNumber(boolean isNumber) {
        this.isNumber = isNumber;
        return this;
    }

    public KeyValueImpl<K, V> numberValue(long numberValue) {
        this.numberValue = numberValue;
        return this;
    }

    public Recycler.Handle<KeyValueImpl<K, V>> handle() {
        return this.handle;
    }

    @Override
    public K key() {
        return this.key;
    }

    @Override
    public V value() {
        return this.value;
    }

    @Override
    public long createRevision() {
        return this.createRevision;
    }

    @Override
    public long modifiedRevision() {
        return this.modifiedRevision;
    }

    @Override
    public long version() {
        return this.version;
    }

    @Override
    public boolean isNumber() {
        return this.isNumber;
    }

    @Override
    public long numberValue() {
        return this.numberValue;
    }

    public String toString() {
        return "KeyValueImpl(key=" + this.key() + ", value=" + this.value() + ", createRevision=" + this.createRevision() + ", modifiedRevision=" + this.modifiedRevision() + ", version=" + this.version() + ", isNumber=" + this.isNumber() + ", numberValue=" + this.numberValue() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyValueImpl)) {
            return false;
        }
        KeyValueImpl other = (KeyValueImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        K this$key = this.key();
        K other$key = other.key();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        V this$value = this.value();
        V other$value = other.value();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        if (this.createRevision() != other.createRevision()) {
            return false;
        }
        if (this.modifiedRevision() != other.modifiedRevision()) {
            return false;
        }
        if (this.version() != other.version()) {
            return false;
        }
        if (this.isNumber() != other.isNumber()) {
            return false;
        }
        return this.numberValue() == other.numberValue();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KeyValueImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        K $key = this.key();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        V $value = this.value();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        long $createRevision = this.createRevision();
        result = result * 59 + (int)($createRevision >>> 32 ^ $createRevision);
        long $modifiedRevision = this.modifiedRevision();
        result = result * 59 + (int)($modifiedRevision >>> 32 ^ $modifiedRevision);
        long $version = this.version();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + (this.isNumber() ? 79 : 97);
        long $numberValue = this.numberValue();
        result = result * 59 + (int)($numberValue >>> 32 ^ $numberValue);
        return result;
    }
}

