/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BookieService.class);
    private final ServerConfiguration serverConf = new ServerConfiguration();
    private BookieServer bs;

    public BookieService(BookieConfiguration conf, StatsLogger statsLogger) {
        super("bookie-server", (ComponentConfiguration)conf, statsLogger);
        this.serverConf.loadConf(conf.getUnderlyingConf());
    }

    protected void doStart() {
        List<Object> indexDirs = null == this.serverConf.getIndexDirs() ? Collections.emptyList() : Arrays.asList(this.serverConf.getIndexDirs());
        log.info("Hello, I'm your bookie, listening on port {} : metadata service uri = {}, journals = {}, ledgers = {}, index = {}", new Object[]{this.serverConf.getBookiePort(), this.serverConf.getMetadataServiceUriUnchecked(), Arrays.asList(this.serverConf.getJournalDirNames()), Arrays.asList(this.serverConf.getLedgerDirs()), indexDirs});
        try {
            this.bs = new BookieServer(this.serverConf, this.statsLogger);
            this.bs.start();
            log.info("Started bookie server successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start bookie server", e);
        }
    }

    protected void doStop() {
        if (null != this.bs) {
            this.bs.shutdown();
        }
    }

    protected void doClose() throws IOException {
    }

    public ServerConfiguration serverConf() {
        return this.serverConf;
    }
}

