/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server.service;

import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieImpl;
import org.apache.bookkeeper.bookie.BookieResources;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.LegacyCookieValidation;
import org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.bookkeeper.bookie.UncleanShutdownDetection;
import org.apache.bookkeeper.bookie.UncleanShutdownDetectionImpl;
import org.apache.bookkeeper.common.allocator.ByteBufAllocatorWithOomHandler;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.component.ComponentInfoPublisher;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.BookieServiceInfo;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataBookieDriver;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.apache.bookkeeper.util.DiskChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieService
extends AbstractLifecycleComponent<BookieConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(BookieService.class);
    private final ServerConfiguration serverConf = new ServerConfiguration();
    private BookieServer bs;
    private MetadataBookieDriver metadataDriver;
    private RegistrationManager rm;
    private LedgerManagerFactory lmFactory;
    private LedgerManager ledgerManager;
    private Supplier<BookieServiceInfo> bookieServiceInfoProvider;

    public BookieService(BookieConfiguration conf, StatsLogger statsLogger, Supplier<BookieServiceInfo> bookieServiceInfoProvider) throws Exception {
        super("bookie-server", (ComponentConfiguration)conf, statsLogger);
        this.serverConf.loadConf(conf.getUnderlyingConf());
        this.bookieServiceInfoProvider = bookieServiceInfoProvider;
        String hello = String.format("Hello, I'm your bookie, bookieId is %1$s, listening on port %2$s. Metadata service uri is %3$s. Journals are in %4$s. Ledgers are stored in %5$s.", this.serverConf.getBookieId() != null ? this.serverConf.getBookieId() : "<not-set>", this.serverConf.getBookiePort(), this.serverConf.getMetadataServiceUriUnchecked(), Arrays.asList(this.serverConf.getJournalDirNames()), Arrays.asList(this.serverConf.getLedgerDirNames()));
        ByteBufAllocatorWithOomHandler allocator = BookieResources.createAllocator((ServerConfiguration)this.serverConf);
        this.metadataDriver = BookieResources.createMetadataDriver((ServerConfiguration)this.serverConf, (StatsLogger)statsLogger);
        StatsLogger bookieStats = statsLogger.scope("bookie");
        this.rm = this.metadataDriver.createRegistrationManager();
        this.lmFactory = this.metadataDriver.getLedgerManagerFactory();
        this.ledgerManager = this.lmFactory.newLedgerManager();
        DiskChecker diskChecker = BookieResources.createDiskChecker((ServerConfiguration)this.serverConf);
        LedgerDirsManager ledgerDirsManager = BookieResources.createLedgerDirsManager((ServerConfiguration)this.serverConf, (DiskChecker)diskChecker, (StatsLogger)bookieStats.scope("ledger"));
        LedgerDirsManager indexDirsManager = BookieResources.createIndexDirsManager((ServerConfiguration)this.serverConf, (DiskChecker)diskChecker, (StatsLogger)bookieStats.scope("index"), (LedgerDirsManager)ledgerDirsManager);
        LedgerStorage storage = BookieResources.createLedgerStorage((ServerConfiguration)this.serverConf, (LedgerManager)this.ledgerManager, (LedgerDirsManager)ledgerDirsManager, (LedgerDirsManager)indexDirsManager, (StatsLogger)bookieStats, (ByteBufAllocator)allocator);
        UncleanShutdownDetectionImpl uncleanShutdownDetection = new UncleanShutdownDetectionImpl(ledgerDirsManager);
        LegacyCookieValidation cookieValidation = new LegacyCookieValidation(this.serverConf, this.rm);
        cookieValidation.checkCookies(Main.storageDirectoriesFromConf((ServerConfiguration)this.serverConf));
        Object bookie = this.serverConf.isForceReadOnlyBookie() ? new ReadOnlyBookie(this.serverConf, this.rm, storage, diskChecker, ledgerDirsManager, indexDirsManager, statsLogger.scope("bookie"), (ByteBufAllocator)allocator, bookieServiceInfoProvider) : new BookieImpl(this.serverConf, this.rm, storage, diskChecker, ledgerDirsManager, indexDirsManager, statsLogger.scope("bookie"), (ByteBufAllocator)allocator, bookieServiceInfoProvider);
        this.bs = new BookieServer(this.serverConf, (Bookie)bookie, statsLogger, (ByteBufAllocator)allocator, (UncleanShutdownDetection)uncleanShutdownDetection);
        log.info(hello);
    }

    protected void doStart() {
        try {
            this.bs.start();
            log.info("Started bookie server successfully.");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start bookie server", e);
        }
    }

    protected void doStop() {
        if (null != this.bs) {
            this.bs.shutdown();
        }
        if (this.rm != null) {
            this.rm.close();
        }
        if (this.ledgerManager != null) {
            try {
                this.ledgerManager.close();
            }
            catch (Exception e) {
                log.error("Error shutting down ledger manager", (Throwable)e);
            }
        }
        if (this.lmFactory != null) {
            try {
                this.lmFactory.close();
            }
            catch (Exception e) {
                log.error("Error shutting down ledger manager factory", (Throwable)e);
            }
        }
        if (null != this.metadataDriver) {
            this.metadataDriver.close();
        }
    }

    protected void doClose() throws IOException {
    }

    public BookieServer getServer() {
        return this.bs;
    }

    public void publishInfo(ComponentInfoPublisher componentInfoPublisher) {
        try {
            BookieSocketAddress localAddress = this.bs.getLocalAddress();
            ArrayList<String> extensions = new ArrayList<String>();
            if (this.serverConf.getTLSProviderFactoryClass() != null) {
                extensions.add("tls");
            }
            ComponentInfoPublisher.EndpointInfo endpoint = new ComponentInfoPublisher.EndpointInfo("bookie", localAddress.getPort(), localAddress.getHostName(), "bookie-rpc", null, extensions);
            componentInfoPublisher.publishEndpoint(endpoint);
        }
        catch (UnknownHostException err) {
            log.error("Cannot compute local address", (Throwable)err);
        }
    }

    public ServerConfiguration serverConf() {
        return this.serverConf;
    }
}

