/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cluster;

import java.io.File;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.commons.configuration.CompositeConfiguration;

public class StreamClusterSpec {
    int numServers;
    CompositeConfiguration baseConf;
    ServiceURI metadataServiceUri;
    boolean shouldStartZooKeeper;
    int zkPort;
    int initialBookiePort;
    int initialGrpcPort;
    File storageRootDir;

    private static int $default$numServers() {
        return 3;
    }

    private static ServiceURI $default$metadataServiceUri() {
        return null;
    }

    private static boolean $default$shouldStartZooKeeper() {
        return true;
    }

    private static int $default$zkPort() {
        return 2181;
    }

    private static int $default$initialBookiePort() {
        return 3181;
    }

    private static int $default$initialGrpcPort() {
        return 4181;
    }

    private static File $default$storageRootDir() {
        return new File("data/bookkeeper");
    }

    StreamClusterSpec(int numServers, CompositeConfiguration baseConf, ServiceURI metadataServiceUri, boolean shouldStartZooKeeper, int zkPort, int initialBookiePort, int initialGrpcPort, File storageRootDir) {
        this.numServers = numServers;
        this.baseConf = baseConf;
        this.metadataServiceUri = metadataServiceUri;
        this.shouldStartZooKeeper = shouldStartZooKeeper;
        this.zkPort = zkPort;
        this.initialBookiePort = initialBookiePort;
        this.initialGrpcPort = initialGrpcPort;
        this.storageRootDir = storageRootDir;
    }

    public static StreamClusterSpecBuilder builder() {
        return new StreamClusterSpecBuilder();
    }

    public int numServers() {
        return this.numServers;
    }

    public CompositeConfiguration baseConf() {
        return this.baseConf;
    }

    public ServiceURI metadataServiceUri() {
        return this.metadataServiceUri;
    }

    public boolean shouldStartZooKeeper() {
        return this.shouldStartZooKeeper;
    }

    public int zkPort() {
        return this.zkPort;
    }

    public int initialBookiePort() {
        return this.initialBookiePort;
    }

    public int initialGrpcPort() {
        return this.initialGrpcPort;
    }

    public File storageRootDir() {
        return this.storageRootDir;
    }

    public StreamClusterSpec numServers(int numServers) {
        this.numServers = numServers;
        return this;
    }

    public StreamClusterSpec baseConf(CompositeConfiguration baseConf) {
        this.baseConf = baseConf;
        return this;
    }

    public StreamClusterSpec metadataServiceUri(ServiceURI metadataServiceUri) {
        this.metadataServiceUri = metadataServiceUri;
        return this;
    }

    public StreamClusterSpec shouldStartZooKeeper(boolean shouldStartZooKeeper) {
        this.shouldStartZooKeeper = shouldStartZooKeeper;
        return this;
    }

    public StreamClusterSpec zkPort(int zkPort) {
        this.zkPort = zkPort;
        return this;
    }

    public StreamClusterSpec initialBookiePort(int initialBookiePort) {
        this.initialBookiePort = initialBookiePort;
        return this;
    }

    public StreamClusterSpec initialGrpcPort(int initialGrpcPort) {
        this.initialGrpcPort = initialGrpcPort;
        return this;
    }

    public StreamClusterSpec storageRootDir(File storageRootDir) {
        this.storageRootDir = storageRootDir;
        return this;
    }

    public static class StreamClusterSpecBuilder {
        private boolean numServers$set;
        private int numServers;
        private CompositeConfiguration baseConf;
        private boolean metadataServiceUri$set;
        private ServiceURI metadataServiceUri;
        private boolean shouldStartZooKeeper$set;
        private boolean shouldStartZooKeeper;
        private boolean zkPort$set;
        private int zkPort;
        private boolean initialBookiePort$set;
        private int initialBookiePort;
        private boolean initialGrpcPort$set;
        private int initialGrpcPort;
        private boolean storageRootDir$set;
        private File storageRootDir;

        StreamClusterSpecBuilder() {
        }

        public StreamClusterSpecBuilder numServers(int numServers) {
            this.numServers = numServers;
            this.numServers$set = true;
            return this;
        }

        public StreamClusterSpecBuilder baseConf(CompositeConfiguration baseConf) {
            this.baseConf = baseConf;
            return this;
        }

        public StreamClusterSpecBuilder metadataServiceUri(ServiceURI metadataServiceUri) {
            this.metadataServiceUri = metadataServiceUri;
            this.metadataServiceUri$set = true;
            return this;
        }

        public StreamClusterSpecBuilder shouldStartZooKeeper(boolean shouldStartZooKeeper) {
            this.shouldStartZooKeeper = shouldStartZooKeeper;
            this.shouldStartZooKeeper$set = true;
            return this;
        }

        public StreamClusterSpecBuilder zkPort(int zkPort) {
            this.zkPort = zkPort;
            this.zkPort$set = true;
            return this;
        }

        public StreamClusterSpecBuilder initialBookiePort(int initialBookiePort) {
            this.initialBookiePort = initialBookiePort;
            this.initialBookiePort$set = true;
            return this;
        }

        public StreamClusterSpecBuilder initialGrpcPort(int initialGrpcPort) {
            this.initialGrpcPort = initialGrpcPort;
            this.initialGrpcPort$set = true;
            return this;
        }

        public StreamClusterSpecBuilder storageRootDir(File storageRootDir) {
            this.storageRootDir = storageRootDir;
            this.storageRootDir$set = true;
            return this;
        }

        public StreamClusterSpec build() {
            int numServers = this.numServers;
            if (!this.numServers$set) {
                numServers = StreamClusterSpec.$default$numServers();
            }
            ServiceURI metadataServiceUri = this.metadataServiceUri;
            if (!this.metadataServiceUri$set) {
                metadataServiceUri = StreamClusterSpec.$default$metadataServiceUri();
            }
            boolean shouldStartZooKeeper = this.shouldStartZooKeeper;
            if (!this.shouldStartZooKeeper$set) {
                shouldStartZooKeeper = StreamClusterSpec.$default$shouldStartZooKeeper();
            }
            int zkPort = this.zkPort;
            if (!this.zkPort$set) {
                zkPort = StreamClusterSpec.$default$zkPort();
            }
            int initialBookiePort = this.initialBookiePort;
            if (!this.initialBookiePort$set) {
                initialBookiePort = StreamClusterSpec.$default$initialBookiePort();
            }
            int initialGrpcPort = this.initialGrpcPort;
            if (!this.initialGrpcPort$set) {
                initialGrpcPort = StreamClusterSpec.$default$initialGrpcPort();
            }
            File storageRootDir = this.storageRootDir;
            if (!this.storageRootDir$set) {
                storageRootDir = StreamClusterSpec.$default$storageRootDir();
            }
            return new StreamClusterSpec(numServers, this.baseConf, metadataServiceUri, shouldStartZooKeeper, zkPort, initialBookiePort, initialGrpcPort, storageRootDir);
        }

        public String toString() {
            return "StreamClusterSpec.StreamClusterSpecBuilder(numServers=" + this.numServers + ", baseConf=" + this.baseConf + ", metadataServiceUri=" + this.metadataServiceUri + ", shouldStartZooKeeper=" + this.shouldStartZooKeeper + ", zkPort=" + this.zkPort + ", initialBookiePort=" + this.initialBookiePort + ", initialGrpcPort=" + this.initialGrpcPort + ", storageRootDir=" + this.storageRootDir + ")";
        }
    }
}

