/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.server;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.base.Preconditions;
import io.grpc.ClientInterceptor;
import java.io.File;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.internal.StorageServerClientManagerImpl;
import org.apache.bookkeeper.common.component.ComponentStarter;
import org.apache.bookkeeper.common.component.LifecycleComponent;
import org.apache.bookkeeper.common.component.LifecycleComponentStack;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.statelib.impl.rocksdb.checkpoint.dlog.DLCheckpointStore;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stream.proto.common.Endpoint;
import org.apache.bookkeeper.stream.server.ExitCode;
import org.apache.bookkeeper.stream.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stream.server.conf.DLConfiguration;
import org.apache.bookkeeper.stream.server.conf.StorageServerConfiguration;
import org.apache.bookkeeper.stream.server.grpc.GrpcServerSpec;
import org.apache.bookkeeper.stream.server.service.BookieService;
import org.apache.bookkeeper.stream.server.service.BookieWatchService;
import org.apache.bookkeeper.stream.server.service.ClusterControllerService;
import org.apache.bookkeeper.stream.server.service.CuratorProviderService;
import org.apache.bookkeeper.stream.server.service.DLNamespaceProviderService;
import org.apache.bookkeeper.stream.server.service.GrpcService;
import org.apache.bookkeeper.stream.server.service.RegistrationServiceProvider;
import org.apache.bookkeeper.stream.server.service.RegistrationStateService;
import org.apache.bookkeeper.stream.server.service.StatsProviderService;
import org.apache.bookkeeper.stream.server.service.StorageService;
import org.apache.bookkeeper.stream.storage.StorageContainerStoreBuilder;
import org.apache.bookkeeper.stream.storage.StorageResources;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterControllerLeaderSelector;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterMetadataStore;
import org.apache.bookkeeper.stream.storage.conf.StorageConfiguration;
import org.apache.bookkeeper.stream.storage.impl.cluster.ClusterControllerImpl;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterControllerLeaderSelector;
import org.apache.bookkeeper.stream.storage.impl.cluster.ZkClusterMetadataStore;
import org.apache.bookkeeper.stream.storage.impl.routing.RoutingHeaderProxyInterceptor;
import org.apache.bookkeeper.stream.storage.impl.sc.DefaultStorageContainerController;
import org.apache.bookkeeper.stream.storage.impl.sc.StorageContainerController;
import org.apache.bookkeeper.stream.storage.impl.sc.StorageContainerPlacementPolicyImpl;
import org.apache.bookkeeper.stream.storage.impl.sc.ZkStorageContainerManager;
import org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactory;
import org.apache.bookkeeper.stream.storage.impl.store.MVCCStoreFactoryImpl;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageServer {
    private static final Logger log = LoggerFactory.getLogger(StorageServer.class);

    private static void loadConfFile(CompositeConfiguration conf, String confFile) throws IllegalArgumentException {
        try {
            PropertiesConfiguration loadedConf = new PropertiesConfiguration(new File(confFile).toURI().toURL());
            conf.addConfiguration((Configuration)loadedConf);
        }
        catch (MalformedURLException e) {
            log.error("Could not open configuration file {}", (Object)confFile, (Object)e);
            throw new IllegalArgumentException("Could not open configuration file " + confFile, e);
        }
        catch (ConfigurationException e) {
            log.error("Malformed configuration file {}", (Object)confFile, (Object)e);
            throw new IllegalArgumentException("Malformed configuration file " + confFile, e);
        }
        log.info("Loaded configuration file {}", (Object)confFile);
    }

    public static Endpoint createLocalEndpoint(int port, boolean useHostname) throws UnknownHostException {
        String hostname = useHostname ? InetAddress.getLocalHost().getHostName() : InetAddress.getLocalHost().getHostAddress();
        return Endpoint.newBuilder().setHostname(hostname).setPort(port).build();
    }

    public static void main(String[] args) {
        int retCode = StorageServer.doMain(args);
        Runtime.getRuntime().exit(retCode);
    }

    static int doMain(String[] args) {
        LifecycleComponent storageServer;
        Thread.setDefaultUncaughtExceptionHandler((thread, exception) -> log.error("Uncaught exception in thread {}: {}", (Object)thread.getName(), (Object)exception.getMessage()));
        ServerArguments arguments = new ServerArguments();
        JCommander jCommander = new JCommander((Object)arguments);
        jCommander.setProgramName("StorageServer");
        jCommander.parse(args);
        if (arguments.help) {
            jCommander.usage();
            return ExitCode.INVALID_CONF.code();
        }
        CompositeConfiguration conf = new CompositeConfiguration();
        if (null != arguments.serverConfigFile) {
            StorageServer.loadConfFile(conf, arguments.serverConfigFile);
        }
        int grpcPort = arguments.port;
        try {
            storageServer = StorageServer.buildStorageServer(conf, grpcPort);
        }
        catch (ConfigurationException e) {
            log.error("Invalid storage configuration", (Throwable)e);
            return ExitCode.INVALID_CONF.code();
        }
        catch (UnknownHostException e) {
            log.error("Unknonw host name", (Throwable)e);
            return ExitCode.UNKNOWN_HOSTNAME.code();
        }
        CompletableFuture liveFuture = ComponentStarter.startComponent((LifecycleComponent)storageServer);
        try {
            liveFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.info("Storage server is interrupted. Exiting ...");
        }
        catch (ExecutionException e) {
            log.info("Storage server is exiting ...");
        }
        return ExitCode.OK.code();
    }

    public static LifecycleComponent buildStorageServer(CompositeConfiguration conf, int grpcPort) throws UnknownHostException, ConfigurationException {
        return StorageServer.buildStorageServer(conf, grpcPort, true, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public static LifecycleComponent buildStorageServer(CompositeConfiguration conf, int grpcPort, boolean startBookieAndStartProvider, StatsLogger externalStatsLogger) throws ConfigurationException, UnknownHostException {
        ServerConfiguration bkServerConf;
        StatsLogger rootStatsLogger;
        LifecycleComponentStack.Builder serverBuilder = LifecycleComponentStack.newBuilder().withName("storage-server");
        BookieConfiguration bkConf = BookieConfiguration.of(conf);
        bkConf.validate();
        DLConfiguration dlConf = DLConfiguration.of(conf);
        dlConf.validate();
        StorageServerConfiguration serverConf = StorageServerConfiguration.of(conf);
        serverConf.validate();
        StorageConfiguration storageConf = new StorageConfiguration(conf);
        storageConf.validate();
        Endpoint myEndpoint = StorageServer.createLocalEndpoint(grpcPort, false);
        StorageResources storageResources = StorageResources.create();
        if (startBookieAndStartProvider) {
            StatsProviderService statsProviderService = new StatsProviderService(bkConf);
            rootStatsLogger = statsProviderService.getStatsProvider().getStatsLogger("");
            serverBuilder.addComponent((LifecycleComponent)statsProviderService);
            log.info("Bookie configuration : {}", (Object)bkConf.asJson());
        } else {
            rootStatsLogger = (StatsLogger)Preconditions.checkNotNull((Object)externalStatsLogger, (Object)"External stats logger is not provided while not starting stats provider");
        }
        log.info("Dlog configuration : {}", (Object)dlConf.asJson());
        log.info("Storage configuration : {}", (Object)storageConf.asJson());
        log.info("Server configuration : {}", (Object)serverConf.asJson());
        if (startBookieAndStartProvider) {
            BookieService bookieService = new BookieService(bkConf, rootStatsLogger);
            serverBuilder.addComponent((LifecycleComponent)bookieService);
            bkServerConf = bookieService.serverConf();
        } else {
            bkServerConf = new ServerConfiguration();
            bkServerConf.loadConf(bkConf.getUnderlyingConf());
        }
        DistributedLogConfiguration dlogConf = new DistributedLogConfiguration();
        dlogConf.loadConf((Configuration)dlConf);
        BookieWatchService bkWatchService = new BookieWatchService(dlogConf.getEnsembleSize(), bkConf, (StatsLogger)NullStatsLogger.INSTANCE);
        CuratorProviderService curatorProviderService = new CuratorProviderService(bkServerConf, dlConf, rootStatsLogger.scope("curator"));
        DLNamespaceProviderService dlNamespaceProvider = new DLNamespaceProviderService(bkServerConf, dlConf, rootStatsLogger.scope("dlog"));
        StorageClientSettings proxyClientSettings = StorageClientSettings.newBuilder().serviceUri("bk://localhost:" + grpcPort).build();
        StorageContainerStoreBuilder storageContainerStoreBuilder = StorageContainerStoreBuilder.newBuilder().withStatsLogger(rootStatsLogger.scope("storage")).withStorageConfiguration(storageConf).withStorageResources(storageResources).withStorageContainerPlacementPolicyFactory(() -> {
            long numStorageContainers;
            try (ZkClusterMetadataStore store = new ZkClusterMetadataStore(curatorProviderService.get(), ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf), "/stream");){
                numStorageContainers = store.getClusterMetadata().getNumStorageContainers();
            }
            return StorageContainerPlacementPolicyImpl.of((int)((int)numStorageContainers));
        }).withDefaultBackendUri(dlNamespaceProvider.getDlogUri()).withStorageContainerManagerFactory((storeConf, registry) -> new ZkStorageContainerManager(myEndpoint, storageConf, (ClusterMetadataStore)new ZkClusterMetadataStore(curatorProviderService.get(), ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf), "/stream"), registry, rootStatsLogger.scope("sc").scope("manager"))).withRangeStoreFactory((MVCCStoreFactory)new MVCCStoreFactoryImpl((Supplier)dlNamespaceProvider, () -> new DLCheckpointStore(dlNamespaceProvider.get()), storageConf.getRangeStoreDirs(), storageResources, storageConf.getServeReadOnlyTables())).withStorageServerClientManager(() -> new StorageServerClientManagerImpl(proxyClientSettings, storageResources.scheduler(), StorageServerChannel.factory((StorageClientSettings)proxyClientSettings).andThen(channel -> channel.intercept(new ClientInterceptor[]{new RoutingHeaderProxyInterceptor()}))));
        StorageService storageService = new StorageService(storageConf, storageContainerStoreBuilder, rootStatsLogger.scope("storage"));
        StatsLogger rpcStatsLogger = rootStatsLogger.scope("grpc");
        GrpcServerSpec serverSpec = GrpcServerSpec.builder().storeSupplier(storageService).storeServerConf(serverConf).endpoint(myEndpoint).statsLogger(rpcStatsLogger).build();
        GrpcService grpcService = new GrpcService(serverConf, serverSpec, rpcStatsLogger);
        RegistrationServiceProvider regService = new RegistrationServiceProvider(bkServerConf, dlConf, rootStatsLogger.scope("registration").scope("provider"));
        RegistrationStateService regStateService = new RegistrationStateService(myEndpoint, bkServerConf, bkConf, regService, rootStatsLogger.scope("registration"));
        ClusterControllerService clusterControllerService = new ClusterControllerService(storageConf, () -> new ClusterControllerImpl((ClusterMetadataStore)new ZkClusterMetadataStore(curatorProviderService.get(), ZKMetadataDriverBase.resolveZkServers((AbstractConfiguration)bkServerConf), "/stream"), regService.get(), (StorageContainerController)new DefaultStorageContainerController(), (ClusterControllerLeaderSelector)new ZkClusterControllerLeaderSelector(curatorProviderService.get(), "/stream"), storageConf), rootStatsLogger.scope("cluster_controller"));
        return serverBuilder.addComponent((LifecycleComponent)bkWatchService).addComponent((LifecycleComponent)curatorProviderService).addComponent((LifecycleComponent)dlNamespaceProvider).addComponent((LifecycleComponent)storageService).addComponent((LifecycleComponent)grpcService).addComponent((LifecycleComponent)regService).addComponent((LifecycleComponent)regStateService).addComponent((LifecycleComponent)clusterControllerService).build();
    }

    private static class ServerArguments {
        @Parameter(names={"-c", "--conf"}, description="Configuration file for storage server")
        private String serverConfigFile;
        @Parameter(names={"-p", "--port"}, description="Port to listen on for gPRC server")
        private int port = 4181;
        @Parameter(names={"-h", "--help"}, description="Show this help message")
        private boolean help = false;

        private ServerArguments() {
        }
    }
}

